<?php
// Set page title
$page_title = "Setting Borrower Users";

// Include header
include '../template_it/header.php';

// Get all borrowers with WC info using direct query instead of VIEW
$query = "SELECT 
            bu.id, 
            bu.username, 
            bu.nama_borrower, 
            bu.nik, 
            bu.email, 
            bu.wc_id,
            bu.status, 
            bu.created_at,
            bu.updated_at,
            wc.wc_code,
            wc.wc_description,
            wc.category as wc_category
          FROM borrower_users bu
          LEFT JOIN wc_master wc ON bu.wc_id = wc.id
          ORDER BY wc.wc_code ASC";
$result = $conn->query($query);

// Get WC Master data for dropdown
$query_wc = "SELECT id, wc_code, wc_description, category FROM wc_master WHERE is_active = 1 ORDER BY category ASC, wc_code ASC";
$result_wc = $conn->query($query_wc);
?>

<style>
.borrower-card {
    transition: all 0.3s ease;
}

.borrower-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

.wc-badge {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.category-painting {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.category-packing {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.action-btn {
    transition: all 0.2s ease;
}

.action-btn:hover {
    transform: scale(1.05);
}

.status-active {
    background-color: #d4edda;
    color: #155724;
}

.status-nonactive {
    background-color: #f8d7da;
    color: #721c24;
}
</style>

<div class="container mx-auto">
    <!-- Page Header -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-users text-blue-600 mr-2"></i>
                    Setting Borrower Users
                </h2>
                <p class="text-gray-600 mt-1">Kelola data borrower users dan Work Center assignment</p>
            </div>
            <button 
                onclick="showAddBorrowerModal()" 
                class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors">
                <i class="fas fa-plus mr-2"></i>Tambah Borrower
            </button>
        </div>
    </div>

    <!-- Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-blue-100 p-3 rounded-full">
                    <i class="fas fa-users text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Total Borrower</p>
                    <p class="text-2xl font-bold text-gray-800"><?php echo $result->num_rows; ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-green-100 p-3 rounded-full">
                    <i class="fas fa-check-circle text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Active Users</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $active_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['status'] == 'active') {
                                $active_count++;
                            }
                        }
                        echo $active_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-purple-100 p-3 rounded-full">
                    <i class="fas fa-paint-brush text-purple-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Painting Users</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $painting_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['wc_category'] == 'PAINTING') {
                                $painting_count++;
                            }
                        }
                        echo $painting_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center">
                <div class="bg-orange-100 p-3 rounded-full">
                    <i class="fas fa-box text-orange-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-gray-600 text-sm">Packing Users</p>
                    <p class="text-2xl font-bold text-gray-800">
                        <?php 
                        $result->data_seek(0);
                        $packing_count = 0;
                        while($row = $result->fetch_assoc()) {
                            if($row['wc_category'] == 'PACKING') {
                                $packing_count++;
                            }
                        }
                        echo $packing_count;
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Borrowers List -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-6 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">
                <i class="fas fa-list mr-2"></i>Daftar Borrower Users
            </h3>
        </div>
        
        <div class="p-6">
            <?php if($result->num_rows > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php 
                    $result->data_seek(0);
                    while($borrower = $result->fetch_assoc()): 
                        $category_class = $borrower['wc_category'] == 'PAINTING' ? 'category-painting' : 'category-packing';
                    ?>
                        <div class="borrower-card bg-gray-50 rounded-lg p-4 border border-gray-200">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h4 class="font-semibold text-gray-800 text-lg">
                                        <?php echo htmlspecialchars($borrower['nama_borrower']); ?>
                                    </h4>
                                    <p class="text-sm text-gray-600 mb-2">
                                        @<?php echo htmlspecialchars($borrower['username']); ?>
                                    </p>
                                    <?php if(!empty($borrower['wc_code'])): ?>
                                    <div class="wc-badge text-white px-3 py-1 rounded-full text-sm font-medium inline-block mb-2">
                                        <?php echo htmlspecialchars($borrower['wc_code']); ?>
                                    </div>
                                    <?php endif; ?>
                                    <div class="<?php echo $borrower['status'] == 'active' ? 'status-active' : 'status-nonactive'; ?> px-2 py-1 rounded text-xs font-semibold inline-block ml-2">
                                        <?php echo $borrower['status'] == 'active' ? 'Active' : 'Non-Active'; ?>
                                    </div>
                                </div>
                                <div class="flex gap-1">
                                    <button 
                                        onclick="editBorrower(<?php echo $borrower['id']; ?>)"
                                        class="action-btn bg-blue-500 hover:bg-blue-600 text-white p-2 rounded text-sm"
                                        title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button 
                                        onclick="deleteBorrower(<?php echo $borrower['id']; ?>, '<?php echo htmlspecialchars(addslashes($borrower['nama_borrower'])); ?>')"
                                        class="action-btn bg-red-500 hover:bg-red-600 text-white p-2 rounded text-sm"
                                        title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <?php if(!empty($borrower['wc_category'])): ?>
                            <div class="text-sm text-gray-600 mb-2">
                                <div class="<?php echo $category_class; ?> text-white px-2 py-1 rounded text-xs font-semibold inline-block mb-1">
                                    <?php echo $borrower['wc_category']; ?>
                                </div>
                                <?php if(!empty($borrower['wc_description'])): ?>
                                <p class="mt-1"><?php echo htmlspecialchars($borrower['wc_description']); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            
                            <div class="text-sm text-gray-600 mb-2">
                                <i class="fas fa-id-card mr-1"></i>
                                NIK: <?php echo htmlspecialchars($borrower['nik']); ?>
                            </div>
                            
                            <?php if($borrower['email']): ?>
                            <div class="text-sm text-gray-600 mb-2">
                                <i class="fas fa-envelope mr-1"></i>
                                <?php echo htmlspecialchars($borrower['email']); ?>
                            </div>
                            <?php endif; ?>
                            
                            <div class="text-xs text-gray-500">
                                <i class="fas fa-calendar mr-1"></i>
                                Dibuat: <?php echo date('d/m/Y', strtotime($borrower['created_at'])); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php else: ?>
                <div class="text-center py-12">
                    <i class="fas fa-users text-gray-300 text-6xl mb-4"></i>
                    <p class="text-gray-500 text-lg">Belum ada data borrower</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Tambah Borrower -->
<div id="addBorrowerModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-lg bg-white">
        <div class="flex items-center justify-between mb-4 border-b pb-3">
            <h3 class="text-xl font-bold text-gray-800">
                <i class="fas fa-user-plus text-blue-600 mr-2"></i>
                Tambah Borrower User
            </h3>
            <button onclick="closeAddBorrowerModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <form id="formAddBorrower" onsubmit="submitAddBorrower(event)">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Username <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="addUsername" 
                        name="username"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        placeholder="Username untuk login"
                        oninput="document.getElementById('addNik').value = this.value"
                        required>
                </div>
                
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Nama Borrower <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="addNamaBorrower" 
                        name="nama_borrower"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        placeholder="Nama lengkap borrower"
                        required>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        NIK <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="addNik" 
                        name="nik"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-100"
                        placeholder="Auto-filled dari username"
                        maxlength="16"
                        readonly
                        required>
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Email
                    </label>
                    <input 
                        type="email" 
                        id="addEmail" 
                        name="email"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        placeholder="email@company.com">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    Work Center <span class="text-red-500">*</span>
                </label>
                <select 
                    id="addWcId" 
                    name="wc_id"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                    <option value="">-- Pilih Work Center --</option>
                    <?php 
                    $result_wc->data_seek(0);
                    $current_category = '';
                    while($wc = $result_wc->fetch_assoc()): 
                        if($wc['category'] != $current_category):
                            if($current_category != '') echo '</optgroup>';
                            echo '<optgroup label="'.$wc['category'].'">';
                            $current_category = $wc['category'];
                        endif;
                    ?>
                        <option value="<?php echo $wc['id']; ?>">
                            <?php echo htmlspecialchars($wc['wc_code'] . ' - ' . $wc['wc_description']); ?>
                        </option>
                    <?php endwhile; ?>
                    <?php if($current_category != '') echo '</optgroup>'; ?>
                </select>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    Password <span class="text-red-500">*</span>
                </label>
                <input 
                    type="password" 
                    id="addPassword" 
                    name="password"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    placeholder="Password untuk login"
                    required>
            </div>

            <div class="flex gap-3">
                <button 
                    type="submit" 
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-save mr-2"></i> Simpan Borrower
                </button>
                <button 
                    type="button" 
                    onclick="closeAddBorrowerModal()"
                    class="flex-1 bg-gray-400 hover:bg-gray-500 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-times mr-2"></i> Batal
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Edit Borrower -->
<div id="editBorrowerModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-lg bg-white">
        <div class="flex items-center justify-between mb-4 border-b pb-3">
            <h3 class="text-xl font-bold text-gray-800">
                <i class="fas fa-user-edit text-blue-600 mr-2"></i>
                Edit Borrower User
            </h3>
            <button onclick="closeEditBorrowerModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <form id="formEditBorrower" onsubmit="submitEditBorrower(event)">
            <input type="hidden" id="editBorrowerId" name="borrower_id">
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Username <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="editUsername" 
                        name="username"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        oninput="document.getElementById('editNik').value = this.value"
                        required>
                </div>
                
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Nama Borrower <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="editNamaBorrower" 
                        name="nama_borrower"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        NIK <span class="text-red-500">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="editNik" 
                        name="nik"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-100"
                        maxlength="16"
                        readonly
                        required>
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Email
                    </label>
                    <input 
                        type="email" 
                        id="editEmail" 
                        name="email"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    Work Center <span class="text-red-500">*</span>
                </label>
                <select 
                    id="editWcId" 
                    name="wc_id"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                    required>
                    <option value="">-- Pilih Work Center --</option>
                    <?php 
                    $result_wc->data_seek(0);
                    $current_category = '';
                    while($wc = $result_wc->fetch_assoc()): 
                        if($wc['category'] != $current_category):
                            if($current_category != '') echo '</optgroup>';
                            echo '<optgroup label="'.$wc['category'].'">';
                            $current_category = $wc['category'];
                        endif;
                    ?>
                        <option value="<?php echo $wc['id']; ?>">
                            <?php echo htmlspecialchars($wc['wc_code'] . ' - ' . $wc['wc_description']); ?>
                        </option>
                    <?php endwhile; ?>
                    <?php if($current_category != '') echo '</optgroup>'; ?>
                </select>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Status <span class="text-red-500">*</span>
                    </label>
                    <select 
                        id="editStatus" 
                        name="status"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        required>
                        <option value="active">Active</option>
                        <option value="nonactive">Non-Active</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        Password Baru
                    </label>
                    <input 
                        type="password" 
                        id="editPassword" 
                        name="password"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                        placeholder="Kosongkan jika tidak ingin mengubah">
                </div>
            </div>

            <div class="flex gap-3">
                <button 
                    type="submit" 
                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-save mr-2"></i> Update Borrower
                </button>
                <button 
                    type="button" 
                    onclick="closeEditBorrowerModal()"
                    class="flex-1 bg-gray-400 hover:bg-gray-500 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    <i class="fas fa-times mr-2"></i> Batal
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Modal Add Borrower
function showAddBorrowerModal() {
    document.getElementById('addBorrowerModal').classList.remove('hidden');
}

function closeAddBorrowerModal() {
    document.getElementById('addBorrowerModal').classList.add('hidden');
    document.getElementById('formAddBorrower').reset();
}

function submitAddBorrower(event) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    const params = new URLSearchParams();
    for (const pair of formData.entries()) {
        params.append(pair[0], pair[1]);
    }
    params.append('action', 'add_borrower');
    
    fetch('process_borrower.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params.toString()
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Borrower berhasil ditambahkan!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

// Modal Edit Borrower
function editBorrower(borrowerId) {
    fetch(`get_borrower.php?id=${borrowerId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('editBorrowerId').value = data.borrower.id;
                document.getElementById('editUsername').value = data.borrower.username;
                document.getElementById('editNamaBorrower').value = data.borrower.nama_borrower;
                document.getElementById('editNik').value = data.borrower.nik;
                document.getElementById('editEmail').value = data.borrower.email || '';
                document.getElementById('editWcId').value = data.borrower.wc_id;
                document.getElementById('editStatus').value = data.borrower.status;
                
                document.getElementById('editBorrowerModal').classList.remove('hidden');
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading borrower data');
        });
}

function closeEditBorrowerModal() {
    document.getElementById('editBorrowerModal').classList.add('hidden');
    document.getElementById('formEditBorrower').reset();
}

function submitEditBorrower(event) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    const params = new URLSearchParams();
    for (const pair of formData.entries()) {
        params.append(pair[0], pair[1]);
    }
    params.append('action', 'edit_borrower');
    
    fetch('process_borrower.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: params.toString()
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Borrower berhasil diupdate!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

// Delete Borrower
function deleteBorrower(borrowerId, borrowerName) {
    if(confirm(`Hapus borrower "${borrowerName}"?`)) {
        fetch('process_borrower.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=delete_borrower&borrower_id=${borrowerId}`
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                alert('Borrower berhasil dihapus!');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error: ' + error);
        });
    }
}
</script>

<?php
include '../template_it/footer.php';
?>