<?php
// get_archive_detail.php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'borrower') {
    echo '<div class="text-center py-4 text-red-500">Access denied</div>';
    exit();
}

include '../config/connection.php';

$archive_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$borrower_id = $_SESSION['user_id'];

// Get archive detail
$query = "SELECT * FROM peminjaman_selesai WHERE id = ? AND borrower_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("ii", $archive_id, $borrower_id);
$stmt->execute();
$archive = $stmt->get_result()->fetch_assoc();

if (!$archive) {
    echo '<div class="text-center py-4 text-red-500">Archive not found</div>';
    exit();
}

// Parse JSON items_data
$items = json_decode($archive['items_data'], true);
?>

<div class="space-y-6">
    <!-- Transaction Info -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg p-4 border border-blue-200">
        <h4 class="font-semibold text-blue-800 mb-3 flex items-center">
            <i class="fas fa-info-circle mr-2"></i>
            Informasi Transaksi (Archived)
        </h4>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
            <div>
                <span class="font-medium text-blue-600">No. Transaksi:</span>
                <p class="font-mono text-blue-800 font-bold"><?php echo htmlspecialchars($archive['transaction_number']); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Original ID:</span>
                <p class="font-bold text-blue-800">#<?php echo $archive['original_transaction_id']; ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Peminjam:</span>
                <p class="text-blue-800"><?php echo htmlspecialchars($archive['borrower_name']); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">NIK:</span>
                <p class="text-blue-800"><?php echo htmlspecialchars($archive['borrower_nik']); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Tanggal Pinjam:</span>
                <p class="text-blue-800"><?php echo date('d M Y H:i', strtotime($archive['transaction_date'])); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Tanggal Kembali:</span>
                <p class="text-blue-800"><?php echo date('d M Y H:i', strtotime($archive['actual_return_date'])); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Durasi Peminjaman:</span>
                <p class="text-blue-800 font-bold"><?php echo $archive['total_days_borrowed']; ?> hari</p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Total Items:</span>
                <p class="text-blue-800 font-bold"><?php echo $archive['total_items']; ?> item(s)</p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Archived At:</span>
                <p class="text-blue-800"><?php echo date('d M Y H:i', strtotime($archive['archived_at'])); ?></p>
            </div>
            <div>
                <span class="font-medium text-blue-600">Status:</span>
                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                    Completed & Archived
                </span>
            </div>
        </div>
    </div>

    <!-- Items List (From JSON) -->
    <div>
        <h4 class="font-semibold text-gray-800 mb-3 flex items-center">
            <i class="fas fa-box-open mr-2 text-red-600"></i>
            Daftar Item yang Telah Dihapus dari Stock
        </h4>
        
        <div class="bg-red-50 border border-red-200 rounded-lg p-3 mb-4">
            <p class="text-sm text-red-700">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <strong>Catatan:</strong> Semua item di bawah ini sudah DIHAPUS PERMANEN dari stock dan tidak bisa dipinjam lagi untuk menjaga kualitas warna.
            </p>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full bg-white border border-gray-200 rounded-lg">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">#</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code Color</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Color Name</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Component</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Lokasi</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Pinjam → Kembali</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php if (!empty($items)): ?>
                        <?php foreach ($items as $index => $item): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 text-sm text-gray-500">
                                <?php echo $index + 1; ?>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                <div class="font-medium text-purple-600 font-mono">
                                    <?php echo htmlspecialchars($item['code_color'] ?? '-'); ?>
                                </div>
                                <div class="text-xs text-gray-500">
                                    <?php echo htmlspecialchars($item['code_barang_lemari5'] ?? '-'); ?>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-sm text-gray-900">
                                <?php echo htmlspecialchars($item['color_name'] ?? '-'); ?>
                            </td>
                            <td class="px-4 py-3 text-sm text-gray-500">
                                <?php echo htmlspecialchars($item['component_name'] ?? '-'); ?>
                            </td>
                            <td class="px-4 py-3 text-sm text-gray-500">
                                <div><?php echo htmlspecialchars($item['lokasi_penyimpanan'] ?? '-'); ?></div>
                                <div class="text-xs">Lemari: <?php echo htmlspecialchars($item['lemari_number'] ?? '-'); ?></div>
                            </td>
                            <td class="px-4 py-3 text-sm text-gray-500">
                                <div class="text-xs">
                                    <div><strong>Pinjam:</strong> <?php echo date('d M Y', strtotime($item['borrow_date'])); ?></div>
                                    <div><strong>Kembali:</strong> <?php echo date('d M Y', strtotime($item['actual_return_date'])); ?></div>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                <div class="space-y-1">
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                        <i class="fas fa-trash mr-1"></i>Deleted
                                    </span>
                                    <div class="text-xs text-gray-500">
                                        Condition: <?php echo ucfirst($item['return_condition'] ?? 'normal'); ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="px-4 py-8 text-center text-gray-500">Tidak ada data item</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Notes -->
    <?php if ($archive['transaction_notes']): ?>
    <div>
        <h4 class="font-semibold text-gray-800 mb-3">Catatan</h4>
        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
            <p class="text-sm text-yellow-800"><?php echo nl2br(htmlspecialchars($archive['transaction_notes'])); ?></p>
        </div>
    </div>
    <?php endif; ?>

    <!-- Summary -->
    <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
        <h4 class="font-semibold text-purple-800 mb-2 flex items-center">
            <i class="fas fa-chart-bar mr-2"></i>
            Ringkasan Archive
        </h4>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
            <div>
                <span class="font-medium text-purple-600">Total Item Dihapus:</span>
                <p class="text-purple-800 font-bold text-lg"><?php echo $archive['total_items']; ?> item(s)</p>
            </div>
            <div>
                <span class="font-medium text-purple-600">Durasi Pinjam:</span>
                <p class="text-purple-800 font-bold text-lg"><?php echo $archive['total_days_borrowed']; ?> hari</p>
            </div>
            <div>
                <span class="font-medium text-purple-600">Diarsipkan:</span>
                <p class="text-purple-800 font-bold"><?php echo date('d M Y H:i', strtotime($archive['archived_at'])); ?></p>
            </div>
        </div>
    </div>

    <!-- Warning Box -->
    <div class="bg-orange-50 border-l-4 border-orange-400 p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-circle text-orange-400 text-xl"></i>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-orange-800">Informasi Penting</h3>
                <div class="mt-2 text-sm text-orange-700">
                    <ul class="list-disc list-inside space-y-1">
                        <li>Transaksi ini sudah selesai dan diarsipkan secara permanen</li>
                        <li>Semua item fisik sudah dihapus dari database stock (color_stock_items)</li>
                        <li>Item tidak dapat dipinjam lagi untuk menjaga kualitas warna produksi</li>
                        <li>Data ini disimpan untuk keperluan tracking dan audit</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>