<!-- borrower/profile.php -->
<?php
// Set page title
$page_title = "Profile";

// Include header
include '../template_borrower/header.php';

// Get borrower information dari database dengan JOIN ke wc_master
$borrower_id = $_SESSION['user_id'];

$query = "SELECT bu.*, wc.wc_code, wc.wc_description, wc.category 
          FROM borrower_users bu
          LEFT JOIN wc_master wc ON bu.wc_id = wc.id
          WHERE bu.id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $borrower_id);
$stmt->execute();
$result = $stmt->get_result();
$borrower_data = $result->fetch_assoc();
$stmt->close();

// Jika data tidak ditemukan, redirect ke dashboard
if (!$borrower_data) {
    header("Location: dashboard.php");
    exit();
}
?>

<!-- Profile Content -->
<div class="w-full max-w-4xl mx-auto px-2 sm:px-4">
    <!-- Header Profile -->
    <div class="bg-gradient-to-r from-purple-500 to-indigo-600 rounded-lg shadow-lg p-6 sm:p-8 mb-4 sm:mb-6 text-white">
        <div class="flex flex-col sm:flex-row items-center gap-4 sm:gap-6">
            <!-- Avatar -->
            <div class="relative">
                <div class="w-24 h-24 sm:w-32 sm:h-32 rounded-full bg-white flex items-center justify-center text-purple-600 text-4xl sm:text-5xl font-bold shadow-lg ring-4 ring-white ring-opacity-50">
                    <?php echo strtoupper(substr($borrower_data['nama_borrower'], 0, 1)); ?>
                </div>
                <div class="absolute bottom-0 right-0 bg-green-500 w-6 h-6 sm:w-8 sm:h-8 rounded-full border-4 border-white flex items-center justify-center">
                    <i class="fas fa-check text-white text-xs"></i>
                </div>
            </div>
            
            <!-- Info Utama -->
            <div class="text-center sm:text-left flex-1">
                <h2 class="text-2xl sm:text-3xl font-bold mb-1"><?php echo htmlspecialchars($borrower_data['nama_borrower']); ?></h2>
                <p class="text-sm sm:text-base opacity-90 mb-1">
                    <i class="fas fa-building mr-2"></i>
                    <?php echo htmlspecialchars($borrower_data['wc_code'] ?? '-'); ?> - 
                    <?php echo htmlspecialchars($borrower_data['wc_description'] ?? '-'); ?>
                </p>
                <p class="text-sm opacity-75 mb-2">
                    <i class="fas fa-id-card mr-2"></i>NIK: <?php echo htmlspecialchars($borrower_data['nik']); ?>
                </p>
                <div class="flex flex-wrap gap-2 justify-center sm:justify-start">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-white bg-opacity-20">
                        <i class="fas fa-circle text-green-400 mr-2 text-xs"></i>
                        Status: <?php echo $borrower_data['status'] == 'active' ? 'Aktif' : 'Nonaktif'; ?>
                    </span>
                    <?php if (isset($borrower_data['category'])): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-white bg-opacity-20">
                        <i class="fas fa-tag mr-2 text-xs"></i>
                        <?php echo htmlspecialchars($borrower_data['category']); ?>
                    </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Informasi Detail -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
        <!-- Card: Informasi Akun -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
                <i class="fas fa-user-circle text-purple-500 mr-2"></i>
                Informasi Akun
            </h3>
            <div class="space-y-4">
                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Username</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-user text-gray-400 mr-3"></i>
                        <span class="text-sm sm:text-base text-gray-800 font-medium"><?php echo htmlspecialchars($borrower_data['username']); ?></span>
                    </div>
                </div>

                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Email</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-envelope text-gray-400 mr-3"></i>
                        <span class="text-sm sm:text-base text-gray-800 break-all">
                            <?php echo isset($borrower_data['email']) && $borrower_data['email'] ? htmlspecialchars($borrower_data['email']) : '-'; ?>
                        </span>
                    </div>
                </div>

                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Status Akun</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-info-circle text-gray-400 mr-3"></i>
                        <span class="inline-flex items-center">
                            <?php if ($borrower_data['status'] == 'active'): ?>
                                <span class="w-2 h-2 bg-green-500 rounded-full mr-2"></span>
                                <span class="text-sm sm:text-base text-green-600 font-medium">Aktif</span>
                            <?php else: ?>
                                <span class="w-2 h-2 bg-red-500 rounded-full mr-2"></span>
                                <span class="text-sm sm:text-base text-red-600 font-medium">Nonaktif</span>
                            <?php endif; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card: Informasi Personal -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
                <i class="fas fa-id-badge text-indigo-500 mr-2"></i>
                Informasi Personal
            </h3>
            <div class="space-y-4">
                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Nama Lengkap</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-user-tag text-gray-400 mr-3"></i>
                        <span class="text-sm sm:text-base text-gray-800 font-medium break-words"><?php echo htmlspecialchars($borrower_data['nama_borrower']); ?></span>
                    </div>
                </div>

                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">NIK</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-id-card text-gray-400 mr-3"></i>
                        <span class="text-sm sm:text-base text-gray-800 font-medium"><?php echo htmlspecialchars($borrower_data['nik']); ?></span>
                    </div>
                </div>

                <div>
                    <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Work Center ID</label>
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <i class="fas fa-hashtag text-gray-400 mr-3"></i>
                        <span class="text-sm sm:text-base text-gray-800 font-medium">
                            <?php echo htmlspecialchars($borrower_data['wc_id']); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Card: Informasi Work Center -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
            <i class="fas fa-industry text-green-500 mr-2"></i>
            Informasi Work Center
        </h3>
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
            <div>
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Kode WC</label>
                <div class="flex items-center p-3 bg-gradient-to-r from-green-50 to-emerald-50 rounded-lg border border-green-200">
                    <i class="fas fa-barcode text-green-600 mr-3"></i>
                    <span class="text-sm sm:text-base text-gray-800 font-bold">
                        <?php echo htmlspecialchars($borrower_data['wc_code'] ?? '-'); ?>
                    </span>
                </div>
            </div>

            <div>
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Deskripsi WC</label>
                <div class="flex items-center p-3 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg border border-blue-200">
                    <i class="fas fa-info-circle text-blue-600 mr-3"></i>
                    <span class="text-sm sm:text-base text-gray-800 font-medium truncate">
                        <?php echo htmlspecialchars($borrower_data['wc_description'] ?? '-'); ?>
                    </span>
                </div>
            </div>

            <div>
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Kategori</label>
                <div class="flex items-center p-3 bg-gradient-to-r from-purple-50 to-pink-50 rounded-lg border border-purple-200">
                    <i class="fas fa-tag text-purple-600 mr-3"></i>
                    <span class="text-sm sm:text-base text-gray-800 font-medium">
                        <?php 
                        $category = $borrower_data['category'] ?? '-';
                        $category_color = $category == 'PAINTING' ? 'text-purple-700' : 'text-pink-700';
                        ?>
                        <span class="<?php echo $category_color; ?> font-bold">
                            <?php echo htmlspecialchars($category); ?>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Card: Informasi Aktivitas -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 flex items-center border-b pb-3">
            <i class="fas fa-history text-blue-500 mr-2"></i>
            Informasi Aktivitas
        </h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
            <div>
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Akun Dibuat</label>
                <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                    <i class="fas fa-calendar-plus text-gray-400 mr-3"></i>
                    <div class="flex-1">
                        <p class="text-sm sm:text-base text-gray-800">
                            <?php echo isset($borrower_data['created_at']) ? date('d F Y', strtotime($borrower_data['created_at'])) : '-'; ?>
                        </p>
                        <p class="text-xs text-gray-500">
                            <?php echo isset($borrower_data['created_at']) ? date('H:i', strtotime($borrower_data['created_at'])) . ' WIB' : ''; ?>
                        </p>
                    </div>
                </div>
            </div>

            <div>
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Login Terakhir</label>
                <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                    <i class="fas fa-clock text-gray-400 mr-3"></i>
                    <div class="flex-1">
                        <?php if (isset($borrower_data['last_login']) && $borrower_data['last_login']): ?>
                            <p class="text-sm sm:text-base text-gray-800">
                                <?php echo date('d F Y', strtotime($borrower_data['last_login'])); ?>
                            </p>
                            <p class="text-xs text-gray-500">
                                <?php echo date('H:i', strtotime($borrower_data['last_login'])) . ' WIB'; ?>
                            </p>
                        <?php else: ?>
                            <p class="text-sm sm:text-base text-gray-500">Belum pernah login</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <?php if (isset($borrower_data['updated_at']) && $borrower_data['updated_at']): ?>
            <div class="sm:col-span-2">
                <label class="text-xs sm:text-sm text-gray-500 font-medium block mb-1">Terakhir Diupdate</label>
                <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                    <i class="fas fa-sync-alt text-gray-400 mr-3"></i>
                    <div class="flex-1">
                        <p class="text-sm sm:text-base text-gray-800">
                            <?php echo date('d F Y', strtotime($borrower_data['updated_at'])); ?>
                        </p>
                        <p class="text-xs text-gray-500">
                            <?php echo date('H:i', strtotime($borrower_data['updated_at'])) . ' WIB'; ?>
                        </p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Info Box -->
    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-lg shadow-md p-4 sm:p-5 border border-blue-200 mb-4 sm:mb-6">
        <div class="flex items-start gap-3">
            <div class="bg-blue-500 rounded-full p-2 flex-shrink-0">
                <i class="fas fa-info-circle text-white text-base sm:text-lg"></i>
            </div>
            <div class="flex-1 min-w-0">
                <h3 class="text-sm sm:text-base font-bold text-gray-800 mb-2">Informasi Penting</h3>
                <div class="space-y-2 text-xs sm:text-sm text-gray-700">
                    <p class="flex items-start">
                        <i class="fas fa-check-circle text-blue-500 mr-2 mt-0.5 flex-shrink-0"></i>
                        <span>Data profil Anda hanya dapat diubah oleh IT Administrator</span>
                    </p>
                    <p class="flex items-start">
                        <i class="fas fa-check-circle text-blue-500 mr-2 mt-0.5 flex-shrink-0"></i>
                        <span>Pastikan informasi kontak Anda selalu up-to-date dengan menghubungi IT</span>
                    </p>
                    <p class="flex items-start">
                        <i class="fas fa-check-circle text-blue-500 mr-2 mt-0.5 flex-shrink-0"></i>
                        <span>Jika ada perubahan Work Center atau data lainnya, silakan hubungi IT Administrator</span>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <div class="flex justify-center sm:justify-start">
        <a href="dashboard.php" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-500 to-indigo-600 text-white rounded-lg hover:from-purple-600 hover:to-indigo-700 transition-all duration-200 shadow-md hover:shadow-lg">
            <i class="fas fa-arrow-left mr-2"></i>
            Kembali ke Dashboard
        </a>
    </div>
</div>

<?php
// Include footer
include '../template_borrower/footer.php';
?>