<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'pawc5944_semarang_color');
define('DB_PASS', 'SemarangColor1#');
define('DB_NAME', 'pawc5944_semarang_color');

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set charset to utf8mb4
$conn->set_charset("utf8mb4");

// Set timezone
date_default_timezone_set('Asia/Jakarta');

// Query untuk mendapatkan data peminjaman yang masih borrowed
$query = "
    SELECT 
        ti.id,
        ti.code_color,
        CASE 
            WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
            THEN ti.created_at 
            ELSE ti.borrow_date 
        END as borrow_date,
        ti.expected_return_date,
        bu.nama_borrower,
        bu.nik,
        wc.wc_description,
        wc.wc_code,
        COALESCE(mc.color_name, 'N/A') as color_name,
        COALESCE(mc.description, '') as color_description,
        COALESCE(b.nama_buyer, 'N/A') as nama_buyer,
        DATEDIFF(
            NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        ) as days_borrowed
    FROM transaction_items ti
    INNER JOIN borrower_users bu ON ti.borrower_id = bu.id
    INNER JOIN wc_master wc ON bu.wc_id = wc.id
    LEFT JOIN color_stock_items csi ON ti.stock_item_id = csi.id
    LEFT JOIN master_color mc ON csi.master_color_id = mc.id
    LEFT JOIN buyers b ON mc.buyer_id = b.id
    WHERE ti.borrow_status = 'borrowed'
    ORDER BY days_borrowed DESC
";

$result = $conn->query($query);

if (!$result) {
    die("Query Error: " . $conn->error);
}

// Hitung total peminjaman aktif
$total_borrowed = $result->num_rows;
$warning_count = 0;
$critical_count = 0;
$data = [];

// Hitung warning dan critical
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $days_borrowed = (int)$row['days_borrowed'];
        $remaining_days = 80 - $days_borrowed; // 90 - 10 = 80 days warning threshold
        
        if ($remaining_days <= 0) {
            $critical_count++;
        } elseif ($remaining_days <= 10) {
            $warning_count++;
        }
        
        $data[] = $row;
    }
}

// Query untuk mendapatkan summary per borrower
$borrower_query = "
    SELECT 
        bu.id as borrower_id,
        bu.nama_borrower,
        bu.nik,
        wc.wc_description,
        wc.wc_code,
        COUNT(ti.id) as total_items,
        MIN(DATEDIFF(
            NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        )) as min_days,
        MAX(DATEDIFF(
            NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        )) as max_days,
        SUM(CASE WHEN DATEDIFF(NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        ) >= 80 THEN 1 ELSE 0 END) as critical_items,
        SUM(CASE WHEN DATEDIFF(NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        ) BETWEEN 70 AND 79 THEN 1 ELSE 0 END) as warning_items
    FROM transaction_items ti
    INNER JOIN borrower_users bu ON ti.borrower_id = bu.id
    INNER JOIN wc_master wc ON bu.wc_id = wc.id
    WHERE ti.borrow_status = 'borrowed'
    GROUP BY bu.id, bu.nama_borrower, bu.nik, wc.wc_description, wc.wc_code
    ORDER BY critical_items DESC, warning_items DESC, total_items DESC
";

$borrower_result = $conn->query($borrower_query);
$borrowers = [];
if ($borrower_result && $borrower_result->num_rows > 0) {
    while($row = $borrower_result->fetch_assoc()) {
        $borrowers[] = $row;
    }
}

// Query untuk mendapatkan list WC yang memiliki peminjaman aktif
$wc_query = "
    SELECT DISTINCT
        wc.id,
        wc.wc_code,
        wc.wc_description
    FROM wc_master wc
    INNER JOIN borrower_users bu ON wc.id = bu.wc_id
    INNER JOIN transaction_items ti ON bu.id = ti.borrower_id
    WHERE ti.borrow_status = 'borrowed'
    ORDER BY wc.wc_code
";

$wc_result = $conn->query($wc_query);
$wc_list = [];
if ($wc_result && $wc_result->num_rows > 0) {
    while($row = $wc_result->fetch_assoc()) {
        $wc_list[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Monitoring - Color Stock Borrowing</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            padding-top: 10px;
        }

        .container {
            max-width: 100%;
            margin: 0 auto;
            padding: 0 10px;
        }

        .header {
            background: white;
            border-radius: 16px;
            padding: 20px 30px;
            margin-bottom: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            position: sticky;
            top: 10px;
            z-index: 100;
        }

        .header h1 {
            color: #1a202c;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .header p {
            color: #718096;
            font-size: 14px;
        }

        /* Navigation Tabs */
        .nav-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
        }

        .nav-tab {
            flex: 1;
            padding: 15px 20px;
            background: white;
            border-radius: 12px;
            border: none;
            cursor: pointer;
            font-size: 15px;
            font-weight: 600;
            color: #718096;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        }

        .nav-tab.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .nav-tab:hover:not(.active) {
            background: #f7fafc;
            transform: translateY(-1px);
        }

        /* Screen Views */
        .screen-view {
            display: none;
        }

        .screen-view.active {
            display: block;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-bottom: 15px;
            position: sticky;
            top: 110px;
            z-index: 99;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-4px);
        }

        .stat-card.total {
            border-left: 4px solid #4299e1;
        }

        .stat-card.warning {
            border-left: 4px solid #f6ad55;
        }

        .stat-card.critical {
            border-left: 4px solid #fc8181;
        }

        .stat-label {
            color: #718096;
            font-size: 13px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
        }

        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: #1a202c;
        }

        .stat-card.total .stat-value { color: #4299e1; }
        .stat-card.warning .stat-value { color: #f6ad55; }
        .stat-card.critical .stat-value { color: #fc8181; }

        /* Borrower Cards Grid */
        .borrower-cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .borrower-card {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .borrower-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }

        .borrower-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }

        .borrower-card:hover::before {
            transform: scaleX(1);
        }

        .borrower-card.has-critical {
            border-left: 4px solid #fc8181;
        }

        .borrower-card.has-warning {
            border-left: 4px solid #f6ad55;
        }

        .borrower-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
        }

        .borrower-name-section {
            flex: 1;
        }

        .borrower-name {
            font-size: 18px;
            font-weight: 700;
            color: #1a202c;
            margin-bottom: 5px;
        }

        .borrower-nik {
            font-size: 14px;
            color: #718096;
            font-family: 'Courier New', monospace;
        }

        .borrower-badge-container {
            display: flex;
            gap: 8px;
        }

        .borrower-item-badge {
            padding: 6px 12px;
            background: #edf2f7;
            border-radius: 8px;
            font-size: 12px;
            font-weight: 700;
            color: #4a5568;
        }

        .borrower-wc {
            display: inline-block;
            padding: 8px 14px;
            background: linear-gradient(135deg, #e6f3ff 0%, #f0e7ff 100%);
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            color: #5a67d8;
            margin-bottom: 15px;
        }

        .borrower-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
        }

        .borrower-stat-item {
            text-align: center;
        }

        .borrower-stat-value {
            font-size: 24px;
            font-weight: 700;
            color: #1a202c;
        }

        .borrower-stat-value.critical { color: #fc8181; }
        .borrower-stat-value.warning { color: #f6ad55; }

        .borrower-stat-label {
            font-size: 11px;
            color: #718096;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 4px;
        }

        .table-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            height: calc(100vh - 240px);
            display: flex;
            flex-direction: column;
        }

        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 30px;
            background: white;
            border-bottom: 2px solid #e2e8f0;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .table-title {
            font-size: 20px;
            font-weight: 700;
            color: #1a202c;
        }

        .last-update {
            color: #718096;
            font-size: 13px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .table-wrapper {
            flex: 1;
            overflow-y: auto;
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        thead {
            background: #f7fafc;
            position: sticky;
            top: 0;
            z-index: 9;
        }

        thead::after {
            content: '';
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            height: 2px;
            background: #e2e8f0;
        }

        th {
            padding: 14px 16px;
            text-align: left;
            font-size: 12px;
            font-weight: 600;
            color: #4a5568;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            background: #f7fafc;
        }

        td {
            padding: 16px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
            color: #2d3748;
        }

        tbody tr {
            transition: background-color 0.2s ease;
        }

        tbody tr:hover {
            background-color: #f7fafc;
        }

        .borrower-info {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .borrower-name-text {
            font-weight: 600;
            color: #1a202c;
        }

        .borrower-nik-text {
            font-size: 12px;
            color: #718096;
        }

        .borrower-wc-text {
            font-size: 12px;
            color: #4299e1;
            font-weight: 500;
        }

        .color-info {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .color-code {
            font-weight: 600;
            color: #1a202c;
            font-family: 'Courier New', monospace;
        }

        .color-name {
            font-size: 12px;
            color: #2d3748;
            font-weight: 500;
        }

        .color-description {
            font-size: 11px;
            color: #718096;
            font-style: italic;
        }

        .buyer-badge {
            display: inline-block;
            padding: 4px 10px;
            background: #edf2f7;
            color: #4a5568;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 500;
        }

        .countdown-badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 700;
            font-size: 16px;
            min-width: 80px;
        }

        .countdown-badge.safe {
            background: #c6f6d5;
            color: #22543d;
        }

        .countdown-badge.warning {
            background: #feebc8;
            color: #7c2d12;
            animation: pulse-warning 2s ease-in-out infinite;
        }

        .countdown-badge.critical {
            background: #fed7d7;
            color: #742a2a;
            animation: pulse-critical 1.5s ease-in-out infinite;
        }

        @keyframes pulse-warning {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        @keyframes pulse-critical {
            0%, 100% { 
                opacity: 1; 
                transform: scale(1);
            }
            50% { 
                opacity: 0.8;
                transform: scale(1.05);
            }
        }

        .status-text {
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 4px;
        }

        .date-badge {
            display: inline-block;
            padding: 6px 12px;
            background: #edf2f7;
            border-radius: 6px;
            font-size: 13px;
            color: #2d3748;
            font-weight: 500;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .empty-state-icon {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        .empty-state-text {
            font-size: 18px;
            color: #718096;
            font-weight: 500;
        }

        .legend {
            display: flex;
            gap: 25px;
            padding: 20px 30px;
            border-top: 1px solid #e2e8f0;
            background: white;
            position: sticky;
            bottom: 0;
            z-index: 10;
        }

        .legend-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 12px;
            color: #4a5568;
        }

        .legend-badge {
            width: 14px;
            height: 14px;
            border-radius: 4px;
            flex-shrink: 0;
        }

        .legend-badge.safe { background: #c6f6d5; }
        .legend-badge.warning { background: #feebc8; }
        .legend-badge.critical { background: #fed7d7; }

        /* Filter Section */
        .filter-section {
            background: white;
            border-radius: 12px;
            padding: 20px 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08);
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }

        .filter-label {
            font-size: 14px;
            font-weight: 600;
            color: #4a5568;
            margin-right: 10px;
        }

        .filter-select {
            padding: 10px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            color: #2d3748;
            background: white;
            cursor: pointer;
            transition: all 0.3s ease;
            min-width: 250px;
            font-weight: 500;
        }

        .filter-select:hover {
            border-color: #cbd5e0;
        }

        .filter-select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .filter-reset {
            padding: 10px 20px;
            background: #f7fafc;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            color: #4a5568;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .filter-reset:hover {
            background: #edf2f7;
            border-color: #cbd5e0;
        }

        .filter-info {
            margin-left: auto;
            font-size: 13px;
            color: #718096;
            font-weight: 500;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 1000;
            animation: fadeIn 0.3s ease;
        }

        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .modal-content {
            background: white;
            border-radius: 20px;
            max-width: 900px;
            width: 100%;
            max-height: 90vh;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            animation: slideUp 0.3s ease;
        }

        @keyframes slideUp {
            from { 
                transform: translateY(50px);
                opacity: 0;
            }
            to { 
                transform: translateY(0);
                opacity: 1;
            }
        }

        .modal-header {
            padding: 25px 30px;
            border-bottom: 2px solid #e2e8f0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-title-section h2 {
            font-size: 24px;
            color: #1a202c;
            margin-bottom: 5px;
        }

        .modal-title-section p {
            font-size: 14px;
            color: #718096;
        }

        .modal-close {
            background: #f7fafc;
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            cursor: pointer;
            font-size: 20px;
            color: #4a5568;
            transition: all 0.3s ease;
        }

        .modal-close:hover {
            background: #e2e8f0;
            transform: rotate(90deg);
        }

        .modal-body {
            padding: 30px;
            overflow-y: auto;
            flex: 1;
        }

        .detail-item {
            background: #f7fafc;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 4px solid #667eea;
            transition: all 0.3s ease;
        }

        .detail-item:hover {
            background: #edf2f7;
            transform: translateX(5px);
        }

        .detail-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 12px;
        }

        .detail-color-code {
            font-size: 18px;
            font-weight: 700;
            color: #1a202c;
            font-family: 'Courier New', monospace;
        }

        .detail-color-name {
            font-size: 14px;
            color: #4a5568;
            font-weight: 500;
            margin-top: 4px;
        }

        .detail-color-description {
            font-size: 13px;
            color: #718096;
            font-style: italic;
            margin-top: 2px;
        }

        .detail-info-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #e2e8f0;
        }

        .detail-info-item {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .detail-info-label {
            font-size: 11px;
            color: #718096;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .detail-info-value {
            font-size: 14px;
            color: #2d3748;
            font-weight: 600;
        }

        @media (max-width: 768px) {
            .header h1 {
                font-size: 24px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .borrower-cards-grid {
                grid-template-columns: 1fr;
            }

            .table-container {
                padding: 20px;
            }

            .table-wrapper {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }

            .detail-info-grid {
                grid-template-columns: 1fr;
            }

            .nav-tabs {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>🎨 Color Stock Monitoring Dashboard</h1>
            <p>Sistem monitoring peminjaman color panel secara real-time</p>
        </div>

        <!-- Navigation Tabs -->
        <div class="nav-tabs">
            <button class="nav-tab active" onclick="switchScreen('details')">
                📋 Detail Peminjaman (<?php echo $total_borrowed; ?>)
            </button>
            <button class="nav-tab" onclick="switchScreen('borrowers')">
                👥 Peminjam (<?php echo count($borrowers); ?>)
            </button>
        </div>

        <!-- Screen 1: Details Table -->
        <div id="screen-details" class="screen-view active">
            <!-- Statistics Cards -->
            <div class="stats-grid">
                <div class="stat-card total">
                    <div class="stat-label">Total Peminjaman Aktif</div>
                    <div class="stat-value"><?php echo $total_borrowed; ?></div>
                </div>
                <div class="stat-card warning">
                    <div class="stat-label">⚠️ Perlu Perhatian (≤10 Hari)</div>
                    <div class="stat-value"><?php echo $warning_count; ?></div>
                </div>
                <div class="stat-card critical">
                    <div class="stat-label">🚨 Melewati Batas Waktu</div>
                    <div class="stat-value"><?php echo $critical_count; ?></div>
                </div>
            </div>

            <!-- Table -->
            <div class="table-container">
                <div class="table-header">
                    <div class="table-title">Daftar Peminjaman Aktif</div>
                    <div class="last-update">
                        <span>⏰</span>
                        <span>Update: <?php echo date('d M Y, H:i:s'); ?></span>
                    </div>
                </div>

                <?php if (count($data) > 0): ?>
                <div class="table-wrapper">
                    <table>
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Peminjam</th>
                                <th>Color Code</th>
                                <th>Buyer</th>
                                <th>Tanggal Pinjam</th>
                                <th>Sisa Waktu</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            foreach($data as $row): 
                                $days_borrowed = (int)$row['days_borrowed'];
                                $remaining_days = 80 - $days_borrowed; // 90 - 10 = 80 days
                                
                                // Tentukan status badge
                                if ($remaining_days <= 0) {
                                    $badge_class = 'critical';
                                    $status_text = 'Terlambat ' . abs($remaining_days) . ' hari';
                                } elseif ($remaining_days <= 10) {
                                    $badge_class = 'warning';
                                    $status_text = 'Segera kembalikan';
                                } else {
                                    $badge_class = 'safe';
                                    $status_text = 'Aman';
                                }
                            ?>
                            <tr>
                                <td style="font-weight: 600; color: #718096;"><?php echo $no++; ?></td>
                                <td>
                                    <div class="borrower-info">
                                        <span class="borrower-name-text"><?php echo htmlspecialchars($row['nama_borrower']); ?></span>
                                        <span class="borrower-nik-text">NIK: <?php echo htmlspecialchars($row['nik']); ?></span>
                                        <span class="borrower-wc-text"><?php echo htmlspecialchars($row['wc_code']) . ' - ' . htmlspecialchars($row['wc_description']); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div class="color-info">
                                        <span class="color-code"><?php echo htmlspecialchars($row['code_color']); ?></span>
                                        <span class="color-name"><?php echo htmlspecialchars($row['color_name']); ?></span>
                                        <?php if (!empty($row['color_description'])): ?>
                                        <span class="color-description"><?php echo htmlspecialchars($row['color_description']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="buyer-badge"><?php echo htmlspecialchars($row['nama_buyer']); ?></span>
                                </td>
                                <td>
                                    <?php 
                                    // Handle invalid dates
                                    $borrow_date_display = $row['borrow_date'];
                                    if ($borrow_date_display && $borrow_date_display != '0000-00-00 00:00:00') {
                                        $formatted_date = date('d M Y', strtotime($borrow_date_display));
                                        $time_display = date('H:i', strtotime($borrow_date_display));
                                    } else {
                                        $formatted_date = 'N/A';
                                        $time_display = '';
                                    }
                                    ?>
                                    <span class="date-badge"><?php echo $formatted_date; ?></span>
                                    <?php if ($time_display): ?>
                                    <div style="font-size: 11px; color: #a0aec0; margin-top: 4px;">
                                        <?php echo $time_display . ' • ' . $days_borrowed . ' hari lalu'; ?>
                                    </div>
                                    <?php else: ?>
                                    <div style="font-size: 11px; color: #a0aec0; margin-top: 4px;">
                                        <?php echo $days_borrowed; ?> hari yang lalu
                                    </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="countdown-badge <?php echo $badge_class; ?>">
                                        <?php 
                                        if ($remaining_days > 0) {
                                            echo $remaining_days . ' hari';
                                        } else {
                                            echo '0 hari';
                                        }
                                        ?>
                                    </div>
                                    <div class="status-text" style="color: <?php echo $badge_class === 'critical' ? '#742a2a' : ($badge_class === 'warning' ? '#7c2d12' : '#22543d'); ?>">
                                        <?php echo $status_text; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Legend -->
                <div class="legend">
                    <div class="legend-item">
                        <span class="legend-badge safe"></span>
                        <span><strong>Aman:</strong> Masih >10 hari</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-badge warning"></span>
                        <span><strong>Warning:</strong> ≤10 hari (segera kembalikan)</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-badge critical"></span>
                        <span><strong>Critical:</strong> Melewati batas 80 hari (akan terkena denda SOP)</span>
                    </div>
                </div>

                <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">✅</div>
                    <div class="empty-state-text">Tidak ada peminjaman aktif saat ini</div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Screen 2: Borrowers Cards -->
        <div id="screen-borrowers" class="screen-view">
            <!-- Filter Section -->
            <div class="filter-section">
                <label class="filter-label">🔍 Filter Work Center:</label>
                <select id="wcFilter" class="filter-select" onchange="filterByWC()">
                    <option value="">Semua Work Center</option>
                    <?php foreach($wc_list as $wc): ?>
                    <option value="<?php echo htmlspecialchars($wc['wc_code']); ?>">
                        <?php echo htmlspecialchars($wc['wc_code']) . ' - ' . htmlspecialchars($wc['wc_description']); ?>
                    </option>
                    <?php endforeach; ?>
                </select>
                <button class="filter-reset" onclick="resetFilter()">Reset Filter</button>
                <div class="filter-info">
                    <span id="filterInfo">Menampilkan semua peminjam</span>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="stats-grid">
                <div class="stat-card total">
                    <div class="stat-label">Total Peminjam Aktif</div>
                    <div class="stat-value"><?php echo count($borrowers); ?></div>
                </div>
                <div class="stat-card warning">
                    <div class="stat-label">⚠️ Ada Item Warning</div>
                    <div class="stat-value">
                        <?php 
                        $borrowers_with_warning = array_filter($borrowers, function($b) {
                            return $b['warning_items'] > 0;
                        });
                        echo count($borrowers_with_warning);
                        ?>
                    </div>
                </div>
                <div class="stat-card critical">
                    <div class="stat-label">🚨 Ada Item Critical</div>
                    <div class="stat-value">
                        <?php 
                        $borrowers_with_critical = array_filter($borrowers, function($b) {
                            return $b['critical_items'] > 0;
                        });
                        echo count($borrowers_with_critical);
                        ?>
                    </div>
                </div>
            </div>

            <!-- Borrower Cards -->
            <?php if (count($borrowers) > 0): ?>
            <div class="borrower-cards-grid">
                <?php foreach($borrowers as $borrower): 
                    $card_class = '';
                    if ($borrower['critical_items'] > 0) {
                        $card_class = 'has-critical';
                    } elseif ($borrower['warning_items'] > 0) {
                        $card_class = 'has-warning';
                    }
                ?>
                <div class="borrower-card <?php echo $card_class; ?>" 
                     data-wc="<?php echo htmlspecialchars($borrower['wc_code']); ?>"
                     onclick="showBorrowerDetails('<?php echo $borrower['nik']; ?>')">
                    <div class="borrower-header">
                        <div class="borrower-name-section">
                            <div class="borrower-name"><?php echo htmlspecialchars($borrower['nama_borrower']); ?></div>
                            <div class="borrower-nik">NIK: <?php echo htmlspecialchars($borrower['nik']); ?></div>
                        </div>
                        <div class="borrower-badge-container">
                            <div class="borrower-item-badge"><?php echo $borrower['total_items']; ?> Items</div>
                        </div>
                    </div>
                    
                    <div class="borrower-wc">
                        <?php echo htmlspecialchars($borrower['wc_code']) . ' - ' . htmlspecialchars($borrower['wc_description']); ?>
                    </div>

                    <div class="borrower-stats">
                        <div class="borrower-stat-item">
                            <div class="borrower-stat-value"><?php echo $borrower['total_items']; ?></div>
                            <div class="borrower-stat-label">Total Pinjam</div>
                        </div>
                        <div class="borrower-stat-item">
                            <div class="borrower-stat-value warning"><?php echo $borrower['warning_items']; ?></div>
                            <div class="borrower-stat-label">Warning</div>
                        </div>
                        <div class="borrower-stat-item">
                            <div class="borrower-stat-value critical"><?php echo $borrower['critical_items']; ?></div>
                            <div class="borrower-stat-label">Critical</div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php else: ?>
            <div class="table-container">
                <div class="empty-state">
                    <div class="empty-state-icon">✅</div>
                    <div class="empty-state-text">Tidak ada peminjaman aktif saat ini</div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Modal for Borrower Details -->
    <div id="borrowerModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title-section">
                    <h2 id="modalBorrowerName">Loading...</h2>
                    <p id="modalBorrowerInfo">NIK: -</p>
                </div>
                <button class="modal-close" onclick="closeModal()">×</button>
            </div>
            <div class="modal-body" id="modalBody">
                <div style="text-align: center; padding: 40px;">
                    <div style="font-size: 48px; margin-bottom: 20px;">⏳</div>
                    <div style="color: #718096;">Memuat data...</div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Switch between screens
        function switchScreen(screen) {
            // Update tabs
            document.querySelectorAll('.nav-tab').forEach(tab => {
                tab.classList.remove('active');
            });
            event.target.classList.add('active');

            // Update screens
            document.querySelectorAll('.screen-view').forEach(view => {
                view.classList.remove('active');
            });
            
            if (screen === 'borrowers') {
                document.getElementById('screen-borrowers').classList.add('active');
            } else {
                document.getElementById('screen-details').classList.add('active');
            }
        }

        // Filter borrowers by WC
        function filterByWC() {
            const selectedWC = document.getElementById('wcFilter').value;
            const cards = document.querySelectorAll('.borrower-card');
            let visibleCount = 0;
            
            console.log('Filter WC:', selectedWC); // Debug
            
            cards.forEach(card => {
                const cardWC = card.getAttribute('data-wc');
                console.log('Card WC:', cardWC); // Debug
                
                if (selectedWC === '' || cardWC === selectedWC) {
                    card.style.display = '';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });
            
            // Update filter info
            const filterInfo = document.getElementById('filterInfo');
            if (selectedWC === '') {
                filterInfo.textContent = 'Menampilkan semua peminjam (' + visibleCount + ' peminjam)';
            } else {
                filterInfo.textContent = `Menampilkan ${visibleCount} peminjam dari WC ${selectedWC}`;
            }
        }

        // Reset filter
        function resetFilter() {
            document.getElementById('wcFilter').value = '';
            filterByWC();
        }

        // Show borrower details in modal
        function showBorrowerDetails(nik) {
            const modal = document.getElementById('borrowerModal');
            modal.classList.add('active');
            
            // Fetch details via AJAX
            fetch('get_borrower_details.php?nik=' + encodeURIComponent(nik))
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('modalBorrowerName').textContent = data.borrower.nama_borrower;
                        document.getElementById('modalBorrowerInfo').textContent = 
                            'NIK: ' + data.borrower.nik + ' • ' + data.borrower.wc_code + ' - ' + data.borrower.wc_description;
                        
                        let html = '';
                        data.items.forEach((item, index) => {
                            const remainingDays = 80 - item.days_borrowed;
                            let statusClass = 'safe';
                            let statusText = 'Aman';
                            
                            if (remainingDays <= 0) {
                                statusClass = 'critical';
                                statusText = 'Terlambat ' + Math.abs(remainingDays) + ' hari';
                            } else if (remainingDays <= 10) {
                                statusClass = 'warning';
                                statusText = 'Segera kembalikan';
                            }
                            
                            html += `
                                <div class="detail-item">
                                    <div class="detail-header">
                                        <div>
                                            <div class="detail-color-code">${item.code_color}</div>
                                            <div class="detail-color-name">${item.color_name}</div>
                                            ${item.color_description ? '<div class="detail-color-description">' + item.color_description + '</div>' : ''}
                                        </div>
                                        <div class="countdown-badge ${statusClass}">
                                            ${remainingDays > 0 ? remainingDays + ' hari' : '0 hari'}
                                        </div>
                                    </div>
                                    <div class="detail-info-grid">
                                        <div class="detail-info-item">
                                            <div class="detail-info-label">Buyer</div>
                                            <div class="detail-info-value">${item.nama_buyer}</div>
                                        </div>
                                        <div class="detail-info-item">
                                            <div class="detail-info-label">Status</div>
                                            <div class="detail-info-value" style="color: ${statusClass === 'critical' ? '#fc8181' : (statusClass === 'warning' ? '#f6ad55' : '#48bb78')}">${statusText}</div>
                                        </div>
                                        <div class="detail-info-item">
                                            <div class="detail-info-label">Tanggal Pinjam</div>
                                            <div class="detail-info-value">${item.borrow_date_formatted}</div>
                                        </div>
                                        <div class="detail-info-item">
                                            <div class="detail-info-label">Lama Pinjam</div>
                                            <div class="detail-info-value">${item.days_borrowed} hari</div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        });
                        
                        document.getElementById('modalBody').innerHTML = html;
                    } else {
                        document.getElementById('modalBody').innerHTML = `
                            <div style="text-align: center; padding: 40px;">
                                <div style="font-size: 48px; margin-bottom: 20px;">❌</div>
                                <div style="color: #718096;">Gagal memuat data</div>
                            </div>
                        `;
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('modalBody').innerHTML = `
                        <div style="text-align: center; padding: 40px;">
                            <div style="font-size: 48px; margin-bottom: 20px;">⚠️</div>
                            <div style="color: #718096;">Terjadi kesalahan saat memuat data</div>
                        </div>
                    `;
                });
        }

        // Close modal
        function closeModal() {
            document.getElementById('borrowerModal').classList.remove('active');
        }

        // Close modal when clicking outside
        document.getElementById('borrowerModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });

        // Update waktu real-time
        function updateTime() {
            const now = new Date();
            const options = { 
                day: '2-digit', 
                month: 'short', 
                year: 'numeric',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit',
                hour12: false
            };
            const timeString = now.toLocaleString('id-ID', options);
            
            const timeElements = document.querySelectorAll('.last-update span:last-child');
            timeElements.forEach(el => {
                el.textContent = 'Update: ' + timeString;
            });
        }

        // Update setiap detik
        setInterval(updateTime, 1000);
    </script>
</body>
</html>
<?php
$conn->close();
?>