<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'pawc5944_semarang_color');
define('DB_PASS', 'SemarangColor1#');
define('DB_NAME', 'pawc5944_semarang_color');

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

// Set charset to utf8mb4
$conn->set_charset("utf8mb4");

// Set timezone
date_default_timezone_set('Asia/Jakarta');

// Get NIK from parameter
$nik = isset($_GET['nik']) ? $_GET['nik'] : '';

if (empty($nik)) {
    echo json_encode(['success' => false, 'message' => 'NIK is required']);
    exit;
}

// Get borrower info
$borrower_query = "
    SELECT 
        bu.id,
        bu.nama_borrower,
        bu.nik,
        wc.wc_description,
        wc.wc_code
    FROM borrower_users bu
    INNER JOIN wc_master wc ON bu.wc_id = wc.id
    WHERE bu.nik = ?
    LIMIT 1
";

$stmt = $conn->prepare($borrower_query);
$stmt->bind_param("s", $nik);
$stmt->execute();
$borrower_result = $stmt->get_result();

if ($borrower_result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Borrower not found']);
    exit;
}

$borrower = $borrower_result->fetch_assoc();

// Get all borrowed items for this borrower
$items_query = "
    SELECT 
        ti.id,
        ti.code_color,
        CASE 
            WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
            THEN ti.created_at 
            ELSE ti.borrow_date 
        END as borrow_date,
        ti.expected_return_date,
        COALESCE(mc.color_name, 'N/A') as color_name,
        COALESCE(mc.description, '') as color_description,
        COALESCE(b.nama_buyer, 'N/A') as nama_buyer,
        DATEDIFF(
            NOW(), 
            CASE 
                WHEN ti.borrow_date = '0000-00-00 00:00:00' OR ti.borrow_date IS NULL 
                THEN ti.created_at 
                ELSE ti.borrow_date 
            END
        ) as days_borrowed
    FROM transaction_items ti
    INNER JOIN borrower_users bu ON ti.borrower_id = bu.id
    LEFT JOIN color_stock_items csi ON ti.stock_item_id = csi.id
    LEFT JOIN master_color mc ON csi.master_color_id = mc.id
    LEFT JOIN buyers b ON mc.buyer_id = b.id
    WHERE bu.nik = ? AND ti.borrow_status = 'borrowed'
    ORDER BY days_borrowed DESC
";

$stmt2 = $conn->prepare($items_query);
$stmt2->bind_param("s", $nik);
$stmt2->execute();
$items_result = $stmt2->get_result();

$items = [];
while ($row = $items_result->fetch_assoc()) {
    // Format borrow date
    $borrow_date_display = $row['borrow_date'];
    if ($borrow_date_display && $borrow_date_display != '0000-00-00 00:00:00') {
        $formatted_date = date('d M Y, H:i', strtotime($borrow_date_display));
    } else {
        $formatted_date = 'N/A';
    }
    
    $row['borrow_date_formatted'] = $formatted_date;
    $items[] = $row;
}

// Return JSON response
echo json_encode([
    'success' => true,
    'borrower' => $borrower,
    'items' => $items
]);

$conn->close();
?>