<?php
// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database connection
require_once __DIR__ . '/../config/connection.php';

// Check if user is logged in and has IT privileges
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'it') {
    header("Location: ../login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' | Color Access System' : 'IT Panel | Color Access System'; ?></title>
    <link rel="icon" href="../images/logo.png" type="image/png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                    backgroundImage: {
                        'gradient-primary': 'linear-gradient(135deg, #2C5364 0%, #203A43 50%, #0F2027 100%)',
                        'gradient-side': 'linear-gradient(225deg, #2C5364 0%, #203A43 50%, #0F2027 100%)',
                    },
                    colors: {
                        primary: '#203A43',
                        secondary: '#2C5364',
                        tertiary: '#0F2027',
                        'light-blue': '#e0f7fa',
                    }
                }
            }
        }
    </script>
    <style>
        /* Additional custom styles */
        .bg-custom-blue {
            background-color: #e0f7fa;
        }
        .main-content-area {
            background-color: #e0f7fa;
        }
        
        /* Active menu styling */
        .menu-active {
            background-color: rgba(59, 130, 246, 0.3) !important;
            border-left: 4px solid #3b82f6;
            font-weight: 600;
        }
        
        .submenu-active {
            background-color: rgba(96, 165, 250, 0.25) !important;
            border-left: 3px solid #60a5fa;
            font-weight: 500;
        }
    </style>
</head>
<body class="font-poppins bg-custom-blue flex h-screen">
    <!-- Sidebar -->
    <div id="sidebar" class="bg-gradient-side text-white w-64 py-4 px-6 flex flex-col transition-all duration-300 h-full shadow-lg fixed lg:relative z-20">
        <div class="flex flex-col items-center mb-6">
            <!-- Logo above IT Panel text -->
            <div class="relative flex justify-center">
                <div class="rounded-full p-1 bg-white ring-4 ring-white">
                    <img src="../images/logo.png" alt="Logo" class="h-20 w-20 rounded-full object-cover">
                </div>
            </div>
            <h2 class="text-2xl font-bold mt-3">IT Panel</h2>
        </div>
        <div class="flex items-center justify-end lg:hidden">
            <button id="closeSidebar" class="text-white">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="flex-1 flex flex-col overflow-y-auto">
            <!-- Main Menu -->
            <div class="mb-4">
                <div class="text-xs uppercase font-semibold text-white/70 mb-2 pl-2">Main Menu</div>
                <ul>
                    <!-- Dashboard Menu (Single) -->
                    <li class="mb-1">
                        <a href="dashboard.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="dashboard.php">
                            <i class="fas fa-home w-5"></i>
                            <span class="ml-2">Dashboard</span>
                        </a>
                    </li>
                    
                    <!-- Management Color Submenu -->
                    <li class="mb-1">
                        <div class="submenu">
                            <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                <div class="flex items-center">
                                    <i class="fas fa-cogs w-5"></i>
                                    <span class="ml-2">Management Color</span>
                                </div>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </div>
                            <ul class="pl-6 mt-1 hidden">
                                <li class="mb-1">
                                    <a href="form_data.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="form_data.php">
                                        <i class="fas fa-plus-circle w-5"></i>
                                        <span class="ml-2">New Data</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="buyer_collection.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="buyer_collection.php">
                                        <i class="fas fa-shopping-cart w-5"></i>
                                        <span class="ml-2">Buyer Collection</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="stock_color_panel.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="stock_color_panel.php">
                                        <i class="fas fa-box w-5"></i>
                                        <span class="ml-2">Stock Color Panel</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="add_component_stock.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="add_component_stock.php">
                                        <i class="fas fa-box w-5"></i>
                                        <span class="ml-2">Add Components</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="edit_tanggal.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="edit_tanggal.php">
                                        <i class="fas fa-box w-5"></i>
                                        <span class="ml-2">Edit Tanggal</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                <a href="reset_color_data.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="reset_color_data.php">
                                        <i class="fas fa-box w-5"></i>
                                        <span class="ml-2">Reset Color Data</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    
                    <!-- Management Account Submenu -->
                    <li class="mb-1">
                        <div class="submenu">
                            <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                <div class="flex items-center">
                                    <i class="fas fa-users-cog w-5"></i>
                                    <span class="ml-2">Management Account</span>
                                </div>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </div>
                            <ul class="pl-6 mt-1 hidden">
                                <li class="mb-1">
                                    <a href="setting_borrower.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="setting_borrower.php">
                                        <i class="fas fa-user-tag w-5"></i>
                                        <span class="ml-2">Akun Borrower</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="create_wc.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="create_wc.php">
                                        <i class="fas fa-user-tag w-5"></i>
                                        <span class="ml-2">Create Work Center</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li class="mb-1">
                        <div class="submenu">
                            <div class="flex items-center justify-between py-2 px-3 rounded-lg hover:bg-white/20 cursor-pointer transition-colors duration-200" onclick="toggleSubmenu(this)">
                                <div class="flex items-center">
                                    <i class="fas fa-qrcode w-5"></i>
                                    <span class="ml-2">Manajemen QR</span>
                                </div>
                                <i class="fas fa-chevron-down text-xs"></i>
                            </div>
                            <ul class="pl-6 mt-1 hidden">
                                <li class="mb-1">
                                    <a href="data_qr_master.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="data_qr_master.php">
                                        <i class="fas fa-barcode w-5"></i>
                                        <span class="ml-2">QR Master</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="master_turunan.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="master_turunan.php">
                                        <i class="fas fa-barcode w-5"></i>
                                        <span class="ml-2">QR Master Turunan</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="data_qr_stock.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="data_qr_stock.php">
                                        <i class="fas fa-warehouse w-5"></i>
                                        <span class="ml-2">QR Stock</span>
                                    </a>
                                </li>
                                <li class="mb-1">
                                    <a href="delete_all_qr.php" class="flex items-center py-2 px-3 rounded-lg hover:bg-white/20 transition-colors duration-200" data-page="delete_all_qr.php">
                                        <i class="fas fa-warehouse w-5"></i>
                                        <span class="ml-2">Delete QR Code</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col min-h-screen">
        <!-- Top Navigation Bar -->
        <header class="bg-white shadow-sm z-10">
            <div class="flex items-center justify-between px-6 py-3">
                <div class="flex items-center">
                    <button id="toggleSidebar" class="text-gray-600 hover:text-primary lg:hidden">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-semibold ml-4 text-gray-800"><?php echo $page_title ?? 'Dashboard'; ?></h1>
                </div>
                
                <!-- User Profile Dropdown -->
                <div class="relative">
                    <button id="profileDropdown" class="flex items-center px-3 py-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors duration-200">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-primary flex items-center justify-center text-white">
                                <?php echo isset($_SESSION['username']) ? strtoupper(substr($_SESSION['username'], 0, 1)) : 'IT'; ?>
                            </div>
                            <span class="ml-2 font-medium text-sm text-gray-700 hidden md:block">
                                <?php echo htmlspecialchars($_SESSION['username'] ?? 'IT User'); ?>
                            </span>
                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-500"></i>
                        </div>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 z-20 hidden">
                        <div class="px-4 py-2 text-sm text-gray-500 border-b border-gray-200">
                            IT Department
                        </div>
                        <a href="profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-user mr-2 text-primary"></i> Profile
                        </a>
                        <a href="change_password.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            <i class="fas fa-key mr-2 text-primary"></i> Ubah Password
                        </a>
                        <div class="border-t border-gray-200 my-1"></div>
                        <a href="../logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content Area -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-custom-blue p-6">