<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ItemRequest extends Model
{
    protected $fillable = [
        'company_id',
        'requester_id',      
        'flow_template_id',
        'current_step_no',
        'status',
        'posting_date',
        'remarks',
        'vendor_name',
    ];

    protected $casts = [
        'posting_date' => 'date',
    ];

    public function requester(): BelongsTo { return $this->belongsTo(User::class, 'requester_id'); }
    public function lines(): HasMany { return $this->hasMany(ItemRequestLine::class, 'item_request_id'); }
    public function flow(): BelongsTo { return $this->belongsTo(ApprovalFlowTemplate::class, 'flow_template_id'); }
    public function instance(): HasOne { return $this->hasOne(ApprovalInstance::class); }
    public function attachments(){return $this->hasMany(\App\Models\ItemRequestAttachment::class);}
    public function comments()
    {return $this->hasMany(ItemRequestComment::class, 'item_request_id');}
    public function company(): BelongsTo
    {
        return $this->belongsTo(\App\Models\Company::class, 'company_id');
    }
}