<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ItemRequestComment extends Model
{
    use HasFactory;

    protected $fillable = [
        'item_request_id',
        'user_id',
        'body',
    ];

    public function request()
    {
        return $this->belongsTo(ItemRequest::class, 'item_request_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}