<?php

namespace App\Services;

use Laravel\Socialite\Contracts\User as SocialiteUser;
use Illuminate\Support\Facades\Session;

class AzureAuthService
{
    public function storeUserInSession(SocialiteUser $user): void
    {
        Session::put('user', [
            'name' => $user->getName(),
            'email' => $user->getEmail(),
        ]);
    }

    public function clearSession(): void
    {
        Session::forget('user');
    }

    public function isAuthenticated(): bool
    {
        return Session::has('user');
    }

    public function user(): ?array
    {
        return Session::get('user');
    }
}
