@extends('layouts.app')

@push('styles')
<style>
  .hero{background:linear-gradient(135deg,#0d6efd 0%,#20c997 100%);color:#fff;border-radius:1rem}
  .badge-status{font-weight:600}
  .card-rounded{border-radius:1rem}
  .quote-pill{border:1px solid var(--bs-border-color); border-radius:.75rem; padding:.25rem .5rem}
  .quote-selected{background:rgba(25,135,84,.1); border-color:rgba(25,135,84,.35)}
  .sig-box{min-height:100px; border:1px dashed #d0d7de; border-radius:.75rem; display:flex; align-items:center; justify-content:center; background:#fff}
  .sig-box img{max-height:90px; max-width:100%; object-fit:contain}
  @media print{
    .d-print-none{display:none!important}
    .hero{color:#000; background:#fff}
    .card{box-shadow:none!important}
  }
</style>
@endpush

@section('content')
@php use Illuminate\Support\Str; @endphp
<div class="container my-4">

  @if (session('success'))
    <div class="alert alert-success d-print-none d-flex align-items-center" role="alert">
      <i class="fa fa-check-circle me-2"></i>
      <div>{{ session('success') }}</div>
    </div>
  @endif

  <div class="hero p-4 mb-4 shadow-sm d-print-none">
    <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
      <div>
        <div class="d-flex align-items-center gap-3">
          <h2 class="mb-0">Request <span class="opacity-75">#{{ $req->id ?? $req->id }}</span></h2>
          @php
            $status = $req->status;
            $statusClass = match($status) {
              'Draft' => 'bg-secondary',
              'InReview' => 'bg-warning text-dark',
              'Approved' => 'bg-success',
              'Rejected' => 'bg-danger',
              'Cancelled' => 'bg-dark',
              default => 'bg-secondary'
            };
          @endphp
          <span class="badge badge-status {{ $statusClass }}">{{ $status }}</span>
          @if($status === 'InReview')
            <span class="badge bg-info">Step {{ $req->current_step_no }}</span>
          @endif
        </div>
        <div class="mt-2 small opacity-75">
          Flow: {{ optional($req->flow)->name ?? '—' }}
          @if(optional($req->flow)->version) <span class="ms-1">v{{ $req->flow->version }}</span> @endif
          &nbsp;&middot;&nbsp; Created: {{ $req->created_at?->timezone('Asia/Singapore')->format('Y-m-d H:i') ?? '—' }}
        </div>
      </div>

      <div class="d-flex gap-2">
        <a href="{{ route('approvals.mine') }}" class="btn btn-light d-print-none">
          <i class="fa fa-inbox me-1"></i> My Forms
        </a>
        @php
          $me = auth()->user();
          $isOwner = $me && ((int)$me->id === (int)$req->requester_id);
          $isAdmin = $me && (method_exists($me,'isAdmin') ? $me->isAdmin() : optional($me->role)->code === 'ADMIN');
        
          $canEdit = false;
          if (in_array($req->status, ['Draft','Rejected','Cancelled', 'InReview'], true)) {
            $canEdit = $isOwner || $isAdmin;
          } elseif ($req->status === 'Approved') {
            if ($isAdmin) {
              $canEdit = true;
            } else {
              $maxStep = \App\Models\ApprovalStepTemplate::where('flow_template_id', $req->flow_template_id)->max('step_no');
              if ($req->current_step_no === $maxStep) {
                  $lastApprove = optional($req->instance)->actions
                      ->where('action','Approve')
                      ->sortByDesc('acted_at')
                      ->first();
        
                  if ($lastApprove && $lastApprove->actor?->id === $me->id) {
                      $canEdit = true;
                  }
              }
            }
          }
        @endphp
        @if($canEdit)
          <a href="{{ route('approvals.edit',$req->id) }}" class="btn btn-outline-light d-print-none">
            <i class="fa fa-pen me-1"></i> Edit Draft
          </a>
        @endif
        <a href="{{ url()->previous() }}" class="btn btn-outline-light d-print-none">
          <i class="fa fa-arrow-left me-1"></i> Back
        </a>
      </div>
    </div>
  </div>

  <div class="row g-4">
    <div class="col-lg-8">

      <div class="card card-rounded shadow-sm">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
          <div class="fw-semibold"><i class="fa fa-list me-2"></i>Lines</div>
          <div class="d-flex align-items-center gap-2 d-print-none">
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllLineDetails(true)">
              <i class="fa fa-eye me-1"></i> Open all
            </button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="toggleAllLineDetails(false)">
              <i class="fa fa-eye-slash me-1"></i> Collapse all
            </button>
            <span class="badge bg-primary ms-2">
              {{ $req->lines->count() }} item{{ $req->lines->count()===1?'':'s' }}
            </span>
          </div>
        </div>
        <div class="card-body">
          @if($req->lines->isEmpty())
            <div class="text-muted">No lines.</div>
          @else
            <div class="table-responsive">
              <table class="table align-middle">
                <thead class="table-light">
                  <tr>
                    <th style="width:60px">#</th>
                    <th>Article</th>
                    <th style="width:130px">Type</th>
                    <th style="width:110px">Unit</th>
                    <th style="width:140px">GL Account</th>
                    <th style="width:140px">Local Code</th>
                    <th>Remarks</th>
                    <th style="width:110px" class="d-print-none"></th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($req->lines as $i => $l)
                    @php
                      $rowId = 'line-'.$l->id.'-'.$i;
                      $quotes = is_array($l->vendor_quotes) ? $l->vendor_quotes : [];
                      $selIdx = null;
                      foreach ($quotes as $qi => $q) { if (!empty($q['selected'])) { $selIdx = $qi; break; } }
                    @endphp
                    <tr>
                      <td><span class="badge bg-secondary">{{ $i+1 }}</span></td>
                      <td>{{ $l->article_name }}</td>
                      <td>
                        <span class="badge {{ $l->type==='Inventory'?'bg-primary':($l->type==='Service'?'bg-success':'bg-warning text-dark') }}">
                          {{ $l->type }}
                        </span>
                      </td>
                      <td>{{ $l->base_unit_code }}</td>
                      <td>{{ $l->gl_account_no ?: '—' }}</td>
                      <td>{{ $l->article_no ?: '—' }}</td>
                      <td class="small text-muted">{{ Str::limit($l->line_remarks, 200) ?: '—' }}</td>
                      <td class="text-end d-print-none">
                        <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="collapse" data-bs-target="#{{ $rowId }}">
                          <i class="fa fa-eye me-1"></i> Details
                        </button>
                      </td>
                    </tr>

                    <!-- Details -->
                    <tr class="collapse bg-light" id="{{ $rowId }}" data-line-collapse>
                      <td colspan="8">
                        <div class="row g-3 py-2">
                          <div class="col-md-4">
                            <div class="text-muted small">Inventory Posting Group</div>
                            <div>{{ $l->inventory_posting_group_code ?: '—' }}</div>
                          </div>
                          <div class="col-md-4">
                            <div class="text-muted small">Gen. Prod. Posting Group</div>
                            <div>{{ $l->gen_prod_posting_group_code ?: '—' }}</div>
                          </div>
                          <div class="col-md-2">
                            <div class="text-muted small">L1</div>
                            <div>{{ $l->l1 ?: '—' }}</div>
                          </div>
                          <div class="col-md-2">
                            <div class="text-muted small">L2</div>
                            <div>{{ $l->l2 ?: '—' }}</div>
                          </div>
                          <div class="col-12">
                            <div class="text-muted small mb-1">Vendor Quotes</div>
                            @if(!count($quotes))
                              <div class="text-muted">—</div>
                            @else
                              <div class="d-flex flex-wrap gap-2">
                                @foreach($quotes as $qi => $q)
                                  <div class="quote-pill {{ $selIdx === $qi ? 'quote-selected' : '' }}">
                                    <strong>{{ $q['name'] ?? '—' }}</strong>
                                    <span class="ms-2">{{ number_format((float)($q['price'] ?? 0), 2) }}</span>
                                    <span class="text-muted">{{ $q['currency'] ?? 'IDR' }}</span>
                                    @if($selIdx === $qi)
                                      <span class="badge bg-success ms-2">Selected</span>
                                    @endif
                                  </div>
                                @endforeach
                              </div>
                            @endif
                          </div>
                          <!-- /Vendor quotes summary -->
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          @endif
        </div>
      </div>
      
      <h3 class="mt-5">Comments</h3>

    <div class="card mb-3">
        <div class="card-body" style="max-height: 300px; overflow-y: auto;">
            @forelse($req->comments()->with('user')->latest()->get() as $comment)
                <div class="mb-3 p-2 border rounded">
                    <strong>{{ $comment->user->name ?? 'Unknown' }}</strong>
                    <small class="text-muted">{{ $comment->created_at->diffForHumans() }}</small>
                    <p class="mb-0">{{ $comment->body }}</p>
                </div>
            @empty
                <p class="text-muted">No comments yet.</p>
            @endforelse
        </div>
    </div>
    
    <form action="{{ route('approvals.comments.store', $req->id) }}" method="POST">
        @csrf
        <div class="input-group">
            <input type="text" name="body" class="form-control" placeholder="Write a comment..." required>
            <button class="btn btn-primary" type="submit">Send</button>
        </div>
    </form>

      @php $actions = optional($req->instance)->actions ?? collect(); @endphp
      @if($actions->count())
      <div class="card card-rounded shadow-sm mt-4">
        <div class="card-header bg-light fw-semibold">
          <i class="fa fa-clock-rotate-left me-2"></i>Approval History
        </div>
        <div class="card-body">
          <ul class="list-group list-group-flush">
            @foreach($actions->sortBy('acted_at') as $act)
              @php
                $ac = $act->action;
                $ic = match($ac) {
                'Submit'  => 'fa-paper-plane',
                'Approve' => 'fa-thumbs-up',
                'Reject'  => 'fa-thumbs-down',
                'Cancel'  => 'fa-ban',            
                default   => 'fa-circle-question'
              };
              $bc = match($ac) {
                'Submit'  => 'bg-secondary',
                'Approve' => 'bg-success',
                'Reject'  => 'bg-danger',
                'Cancel'  => 'bg-dark',         
                default   => 'bg-secondary'
              };
              @endphp
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="me-3">
                  <span class="badge {{ $bc }}"><i class="fa {{ $ic }} me-1"></i>{{ $ac }}</span>
                  <span class="ms-2">{{ $act->actor?->name ?? 'User #'.$act->actor_user_id }}</span>
                  <small class="text-muted ms-2">Step {{ $act->step_no }}</small>
                  @if($act->comment)
                    <div class="small text-muted mt-1"><i class="fa fa-comment-dots me-1"></i>{{ $act->comment }}</div>
                  @endif
                </div>
                <div class="text-nowrap small text-muted">
                  {{ \Illuminate\Support\Carbon::parse($act->acted_at)->timezone('Asia/Singapore')->format('Y-m-d H:i') }}
                </div>
              </li>
            @endforeach
          </ul>
        </div>
      </div>
      @endif
    </div>

    <div class="col-lg-4">
      <div class="card card-rounded shadow-sm mb-4">
        <div class="card-header bg-light fw-semibold"><i class="fa fa-circle-info me-2"></i>Details</div>
        <div class="card-body">
          <dl class="row mb-0">
            <dt class="col-5">ID</dt>
            <dd class="col-7">{{ $req->id ?? '—' }}</dd>

            <dt class="col-5">Requester</dt>
            <dd class="col-7">
              {{ optional($req->requester)->name ?? '—' }}
              @if(optional($req->requester)->email)
                <div class="small text-muted">{{ $req->requester->email }}</div>
              @endif
            </dd>

            <dt class="col-5">Company</dt>
            <dd class="col-7">{{ optional($req->company ?? null)->code ?? ($req->company_id ?? '—') }}</dd>

            <dt class="col-5">Flow</dt>
            <dd class="col-7">{{ optional($req->flow)->name ?? '—' }}</dd>

            <dt class="col-5">Vendor</dt>
            <dd class="col-7">{{ $req->vendor_name ?: '—' }}</dd>

            <dt class="col-5">Posting Date</dt>
            <dd class="col-7">{{ $req->posting_date?->format('Y-m-d') ?? '—' }}</dd>

            <dt class="col-5">Remarks</dt>
            <dd class="col-7">{{ $req->remarks ?: '—' }}</dd>
          </dl>
        </div>
      </div>

      @if(in_array($req->status, ['Draft','Rejected','Cancelled']))
        <div class="card card-rounded shadow-sm d-print-none">
          <div class="card-header bg-light fw-semibold"><i class="fa fa-paper-plane me-2"></i>Submit</div>
          <div class="card-body">
            <form method="POST" action="{{ route('approvals.web.submit', $req->id) }}">
              @csrf
              <button class="btn btn-primary w-100"><i class="fa fa-paper-plane me-1"></i> Submit for approval</button>
            </form>
          </div>
        </div>
        @php
          $me = auth()->user(); // cleaner than re-querying by email
        
          $isOwner = $me && ((int) $me->id === (int) $req->requester_id);
          $isAdmin = optional($me->role)->code === 'ADMIN';
        
          $canDelete = $req->status === 'Draft' && ($isOwner || $isAdmin);
        @endphp

        @if($canDelete)
          <div class="card card-rounded shadow-sm d-print-none mt-3">
            <div class="card-header bg-light fw-semibold">
              <i class="fa fa-trash me-2"></i>Delete Draft
            </div>
            <div class="card-body">
              <form method="POST" action="{{ route('approvals.destroy', $req->id) }}"
                    onsubmit="return confirm('Delete this draft permanently?');">
                @csrf
                @method('DELETE')
                <button class="btn btn-outline-danger w-100">
                  <i class="fa fa-trash me-1"></i> Delete Draft
                </button>
              </form>
            </div>
          </div>
        @endif
      @elseif($req->status === 'InReview')
        <div class="card card-rounded shadow-sm d-print-none">
          <div class="card-header bg-light fw-semibold"><i class="fa fa-gavel me-2"></i>Approval Actions</div>
          <div class="card-body">
            <form class="mb-2" method="POST" action="{{ route('approvals.web.approve', $req->id) }}">
              @csrf
              <div class="mb-2"><input type="text" class="form-control" name="comment" placeholder="Comment (optional)"></div>
              <button class="btn btn-success w-100"><i class="fa fa-thumbs-up me-1"></i> Approve</button>
            </form>
            <form method="POST" action="{{ route('approvals.web.reject', $req->id) }}">
              @csrf
              <div class="mb-2"><input type="text" class="form-control" name="comment" placeholder="Comment (optional)"></div>
              <button class="btn btn-danger w-100"><i class="fa fa-thumbs-down me-1"></i> Reject</button>
            </form>
          </div>
          @php
              $me = auth()->user();
            
              $status    = strtoupper(trim((string) $req->status));
              $isOwner   = $me && ((int)$me->id === (int)$req->requester_id);
              $isAdmin   = optional($me->role)->code === 'ADMIN';
            
              $canCancel = ($status === 'INREVIEW') && ($isOwner || $isAdmin);
            @endphp
          @if($canCancel)
            <div class="card card-rounded shadow-sm mt-3">
              <div class="card-header bg-light fw-semibold">
                <i class="fa fa-ban me-2"></i>Cancel Request
              </div>
              <div class="card-body">
                <form method="POST" action="{{ route('approvals.web.cancel', $req->id) }}"
                      onsubmit="return confirm('Cancel this request? This will stop the approval flow.');">
                  @csrf
                  <div class="mb-2">
                    <input type="text" class="form-control" name="comment" placeholder="Reason (optional)">
                  </div>
                  <button class="btn btn-outline-danger w-100">
                    <i class="fa fa-ban me-1"></i> Cancel Request
                  </button>
                </form>
              </div>
            </div>
          @endif
        </div>
      @endif
      @php
          $me = auth()->user();
        
          $status    = strtoupper(trim((string) $req->status));
          $isOwner   = $me && ((int)$me->id === (int)$req->requester_id);
          $isAdmin   = optional($me->role)->code === 'ADMIN';
        
          $canRevise = ($status === 'REJECTED') && ($isOwner || $isAdmin);
        @endphp
      @if($canRevise)
        <div class="card card-rounded shadow-sm mt-3">
          <div class="card-header bg-light fw-semibold">
            <i class="fa fa-repeat me-2"></i>Revise Request
          </div>
          <div class="card-body">
            <form method="POST" action="{{ route('approvals.web.duplicate', $req->id) }}">
              @csrf
              <div class="form-check mb-2">
                <input class="form-check-input" type="checkbox" name="copy_attachments" id="copy_attachments" value="1">
                <label class="form-check-label" for="copy_attachments">Copy attachments</label>
              </div>
              <button class="btn btn-outline-primary w-100">
                <i class="fa fa-copy me-1"></i> Create new draft from this
              </button>
            </form>
            <div class="small text-muted mt-2">
              We’ll copy header, lines, and vendor quotes (including the selected vendor per line). Approval history is not copied.
            </div>
          </div>
        </div>
      @endif

      <div class="card card-rounded shadow-sm mt-4">
        <div class="card-header bg-light fw-semibold d-flex justify-content-between align-items-center">
          <span><i class="fa fa-signature me-2"></i>Sign-off</span>
          <a href="{{ route('approvals.print', $req->id) }}" target="_blank"
               class="btn btn-sm btn-outline-secondary d-print-none">
              <i class="fa fa-print me-1"></i> Print
            </a>
        </div>
        <div class="card-body">
          @php
            $steps = optional($req->flow)->steps ?? collect();
            $byStep = ($actions ?? collect())->groupBy('step_no');
          @endphp
           @if($req->attachments->isNotEmpty())
            <div class="card card-rounded shadow-sm mb-3">
              <div class="card-header bg-light fw-semibold">
                <i class="fa fa-paperclip me-2"></i>Attachments
              </div>
              <div class="card-body p-2">
                <ul class="list-group">
                  @foreach($req->attachments as $att)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                      <div class="text-truncate">
                        <i class="fa fa-file me-2"></i>
                        <a href="{{ route('approvals.attachments.preview', [$req->id, $att->id]) }}" target="_blank">
                          {{ $att->original_name }}
                        </a>
                      </div>
                      <small class="text-muted">{{ number_format($att->size/1024/1024,1) }} MB</small>
                    </li>
                  @endforeach
                </ul>
              </div>
            </div>
          @endif
          @forelse($steps as $st)
            @php
                $done      = ($byStep[$st->step_no] ?? collect())->firstWhere('action','Approve');
                $approver  = $st->approverUser ?: optional($st->approverRole);
                $sigPath   = $done?->actor?->signature_path ?? $st->approverUser?->signature_path ?? null;
            
                $base = request()->getSchemeAndHttpHost().request()->getBaseUrl();
                $imgUrl = null;
                if ($sigPath) {
                    $rel = ltrim($sigPath, '/');                                  // signatures/u-1.png
                    $rel = str_starts_with($rel, 'storage/') ? $rel : "storage/{$rel}"; // ensure 'storage/' prefix
                    if (file_exists(public_path($rel))) {
                        $imgUrl = "{$base}/public/{$rel}";
                    }
                }
            
                if (!$imgUrl) {
                    $uid = $done?->actor?->id ?? $st->approverUser?->id;
                    if ($uid) {
                        $rel = "storage/signatures/{$uid}.png";
                        if (file_exists(public_path($rel))) {
                            $imgUrl = "{$base}/public/{$rel}";
                        }
                    }
                }
              @endphp
        
              <div class="mb-3">
                <div class="small text-muted">Step {{ $st->step_no }}</div>
                <div class="d-flex align-items-center gap-3">
                  <div class="sig-box flex-grow-1 text-center">
                    @if($imgUrl)
                      <img src="{{ $imgUrl }}?v={{ filemtime(public_path(str_replace($base.'/public/', '', $imgUrl))) }}" alt="signature">
                    @else
                      <span class="text-muted">— signature —</span>
                    @endif
                  </div>
                  <div class="small">
                    <div class="fw-semibold">
                      {{ $done?->actor?->name ?? ($st->approverUser?->name ?? ($st->approverRole?->code ?? '')) }}
                    </div>
                    <div class="text-muted">
                      @if($done)
                        Approved at {{ \Illuminate\Support\Carbon::parse($done->acted_at)->timezone('Asia/Singapore')->format('Y-m-d H:i') }}
                      @else
                        Pending
                      @endif
                    </div>
                  </div>
                </div>
              </div>
            @empty
            <div class="text-muted">No steps configured.</div>
          @endforelse
        </div>
      </div>
    </div>
  </div>
</div>

@push('scripts')
<script>
  window.toggleAllLineDetails = function(open) {
    document.querySelectorAll('[data-line-collapse]').forEach(function(el){
      if (window.bootstrap && window.bootstrap.Collapse) {
        const inst = window.bootstrap.Collapse.getOrCreateInstance(el, { toggle: false });
        open ? inst.show() : inst.hide();
      } else {
        el.classList.toggle('show', !!open);
      }
    });
  };
</script>
@endpush
@endsection
