<?php

namespace App\Helpers;

use App\Models\Quotation;

class QuotationHelper
{
    /**
     * Generate unique quotation number
     * Format: QT-YYYYMMDD-XXXX
     */
    public static function generateQuotationNumber()
    {
        $date = date('Ymd');
        $lastQuotation = Quotation::whereDate('created_at', today())
            ->orderBy('id', 'desc')
            ->first();
        
        if ($lastQuotation) {
            $lastNumber = intval(substr($lastQuotation->quotation_number, -4));
            $newNumber = str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            $newNumber = '0001';
        }
        
        return 'QT-' . $date . '-' . $newNumber;
    }
}