@extends('layouts.app')

@section('title', 'Dashboard Admin')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('admin.dashboard') }}" class="active">📊 Dashboard</a></li>
    <li><a href="{{ route('admin.quotations.create') }}">🛒 Pemesanan Baru</a></li>
    <li><a href="{{ route('admin.quotations.index') }}">📄 Riwayat Quotations</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Dashboard Admin</h1>
    <p style="color: var(--gray-600);">Selamat datang, {{ Auth::user()->name }}</p>
</div>

<div class="grid grid-3">
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">My Quotations</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green);">{{ $myQuotations }}</p>
    </div>
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Draft</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--gray-400);">{{ $draftQuotations }}</p>
    </div>
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Submitted</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green-dark);">{{ $submittedQuotations }}</p>
    </div>
</div>

<div class="card" style="margin-top: 30px; padding: 30px; text-align: center;">
    <h2 style="margin-bottom: 15px;">Buat Quotation Baru</h2>
    <p style="color: var(--gray-600); margin-bottom: 20px;">Mulai buat penawaran untuk customer</p>
    <a href="{{ route('admin.quotations.create') }}" class="btn btn-primary" style="display: inline-block; text-decoration: none; padding: 14px 30px; font-size: 16px;">🛒 Mulai Pemesanan</a>
</div>
@endsection