@extends('layouts.app')

@section('title', 'Dashboard SuperAdmin')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}" class="active">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Dashboard SuperAdmin</h1>
    <p style="color: var(--gray-600);">Selamat datang di panel SuperAdmin</p>
</div>

<div class="grid grid-4">
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Total Buyers</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green);">{{ $totalBuyers }}</p>
    </div>
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Total Products</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green);">{{ $totalProducts }}</p>
    </div>
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Total Materials</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green);">{{ $totalMaterials }}</p>
    </div>
    <div class="card">
        <h3 style="color: var(--gray-600); font-size: 14px; margin-bottom: 10px;">Total Quotations</h3>
        <p style="font-size: 32px; font-weight: 700; color: var(--primary-green);">{{ $totalQuotations }}</p>
    </div>
</div>
@endsection