@extends('layouts.app')

@section('title', 'Edit Dimension')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}" class="active">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Edit Dimension</h1>
    <p style="color: var(--gray-600);">Update informasi dimension</p>
</div>

<div class="card" style="max-width: 600px;">
    <form action="{{ route('superadmin.dimensions.update', $dimension->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="value">Nilai (mm) *</label>
            <input type="number" id="value" name="value" class="form-control" value="{{ old('value', $dimension->value) }}" step="0.01" required>
            @error('value')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="type">Tipe *</label>
            <select id="type" name="type" class="form-control" required>
                <option value="">Pilih Tipe</option>
                <option value="lebar" {{ old('type', $dimension->type) == 'lebar' ? 'selected' : '' }}>Lebar</option>
                <option value="panjang" {{ old('type', $dimension->type) == 'panjang' ? 'selected' : '' }}>Panjang</option>
            </select>
            @error('type')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $dimension->is_active) ? 'checked' : '' }} style="width: auto; margin-right: 8px;">
                <span>Status Aktif</span>
            </label>
        </div>

        <div style="display: flex; gap: 10px; margin-top: 30px;">
            <button type="submit" class="btn btn-primary">Update</button>
            <a href="{{ route('superadmin.dimensions.index') }}" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: var(--gray-700);
        font-weight: 600;
        font-size: 14px;
    }

    .error-message {
        color: #ef4444;
        font-size: 12px;
        margin-top: 5px;
        display: block;
    }

    select.form-control {
        cursor: pointer;
    }
</style>
@endpush