@extends('layouts.app')

@section('title', 'Edit Product')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}" class="active">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Edit Product</h1>
    <p style="color: var(--gray-600);">Update informasi product</p>
</div>

<div class="card" style="max-width: 800px;">
    <form action="{{ route('superadmin.products.update', $product->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="name">Nama Product *</label>
            <input type="text" id="name" name="name" class="form-control" value="{{ old('name', $product->name) }}" required>
            @error('name')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="code">Kode Product *</label>
            <input type="text" id="code" name="code" class="form-control" value="{{ old('code', $product->code) }}" required>
            @error('code')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="description">Deskripsi</label>
            <textarea id="description" name="description" class="form-control" rows="4">{{ old('description', $product->description) }}</textarea>
            @error('description')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="image">Gambar Product</label>
            
            @if($product->image)
            <div style="margin-bottom: 15px;">
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 10px;">Gambar saat ini:</p>
                <img src="{{ asset('assets/images/products/' . $product->image) }}" alt="{{ $product->name }}" style="max-width: 300px; border-radius: 8px; border: 2px solid var(--gray-300);">
            </div>
            @endif
            
            <input type="file" id="image" name="image" class="form-control" accept="image/jpeg,image/png,image/jpg" onchange="previewImage(event)">
            <small style="color: var(--gray-500); font-size: 12px; display: block; margin-top: 5px;">Format: JPG, JPEG, PNG. Max: 2MB. Kosongkan jika tidak ingin mengubah gambar.</small>
            @error('image')
                <span class="error-message">{{ $message }}</span>
            @enderror
            
            <div id="imagePreview" style="margin-top: 15px; display: none;">
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 10px;">Preview gambar baru:</p>
                <img id="preview" src="" alt="Preview" style="max-width: 300px; border-radius: 8px; border: 2px solid var(--gray-300);">
            </div>
        </div>

        <div class="form-group">
            <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $product->is_active) ? 'checked' : '' }} style="width: auto; margin-right: 8px;">
                <span>Status Aktif</span>
            </label>
        </div>

        <div style="display: flex; gap: 10px; margin-top: 30px;">
            <button type="submit" class="btn btn-primary">Update</button>
            <a href="{{ route('superadmin.products.index') }}" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: var(--gray-700);
        font-weight: 600;
        font-size: 14px;
    }

    .error-message {
        color: #ef4444;
        font-size: 12px;
        margin-top: 5px;
        display: block;
    }
</style>
@endpush

@push('scripts')
<script>
    function previewImage(event) {
        const input = event.target;
        const preview = document.getElementById('preview');
        const previewContainer = document.getElementById('imagePreview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.src = e.target.result;
                previewContainer.style.display = 'block';
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endpush