

<?php $__env->startSection('title', 'Riwayat Quotations'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('admin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('admin.quotations.create')); ?>">🛒 Pemesanan Baru</a></li>
    <li><a href="<?php echo e(route('admin.quotations.index')); ?>" class="active">📄 Riwayat Quotations</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Riwayat Quotations</h1>
        <p style="color: var(--gray-600);">Daftar semua quotation yang pernah dibuat</p>
    </div>
    <a href="<?php echo e(route('admin.quotations.create')); ?>" class="btn btn-primary">+ Buat Quotation Baru</a>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="card">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: var(--gray-100); text-align: left;">
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">No. Quotation</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Buyer</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Product</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Total Harga</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Status</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Tanggal</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300); text-align: center;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><strong><?php echo e($quotation->quotation_number); ?></strong></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($quotation->buyer->name); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($quotation->product->name); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><strong style="color: var(--primary-green);">Rp <?php echo e(number_format($quotation->total_price, 0, ',', '.')); ?></strong></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">
                    <?php if($quotation->status == 'draft'): ?>
                        <span style="background: #f3f4f6; color: #374151; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Draft</span>
                    <?php elseif($quotation->status == 'submitted'): ?>
                        <span style="background: #dbeafe; color: #1e40af; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Submitted</span>
                    <?php elseif($quotation->status == 'approved'): ?>
                        <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Approved</span>
                    <?php else: ?>
                        <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Rejected</span>
                    <?php endif; ?>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($quotation->created_at->format('d M Y')); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200); text-align: center;">
                    <a href="<?php echo e(route('admin.quotations.show', $quotation->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; margin-right: 5px;">Lihat</a>
                    <form action="<?php echo e(route('admin.quotations.destroy', $quotation->id)); ?>" method="POST" style="display: inline-block;" onsubmit="return confirm('Yakin ingin menghapus quotation ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn" style="padding: 6px 12px; background: #ef4444; color: white;">Hapus</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" style="padding: 40px; text-align: center; color: var(--gray-500);">
                    Belum ada quotation. <a href="<?php echo e(route('admin.quotations.create')); ?>" style="color: var(--primary-green);">Buat quotation pertama</a>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 20px;">
        <?php echo e($quotations->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/admin/quotations/index.blade.php ENDPATH**/ ?>