

<?php $__env->startSection('title', 'Pilih Product'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('admin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('admin.quotations.create')); ?>" class="active">🛒 Pemesanan Baru</a></li>
    <li><a href="<?php echo e(route('admin.quotations.index')); ?>">📄 Riwayat Quotations</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Buat Quotation Baru</h1>
    <p style="color: var(--gray-600);">Step 2 dari 3: Pilih Product</p>
</div>

<!-- Progress Bar -->
<div style="background: var(--gray-200); height: 8px; border-radius: 4px; margin-bottom: 30px; overflow: hidden;">
    <div style="background: var(--primary-green); height: 100%; width: 66%;"></div>
</div>

<!-- Selected Buyer Info -->
<div class="card" style="margin-bottom: 30px; background: var(--primary-green-light); border: 2px solid var(--primary-green);">
    <div style="display: flex; align-items: center; gap: 15px;">
        <span style="font-size: 32px;">✓</span>
        <div>
            <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 5px;">Buyer Terpilih:</p>
            <h3 style="font-size: 18px; color: var(--gray-800);"><?php echo e($buyer->name); ?> (<?php echo e($buyer->code); ?>)</h3>
        </div>
    </div>
</div>

<form action="<?php echo e(route('admin.quotations.build-components')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="buyer_id" value="<?php echo e($buyer->id); ?>">
    
    <h2 style="font-size: 20px; margin-bottom: 20px; color: var(--gray-800);">Pilih Product</h2>
    
    <div class="grid grid-3">
        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <label class="card product-card" style="cursor: pointer; transition: all 0.3s ease;">
            <input type="radio" name="product_id" value="<?php echo e($product->id); ?>" required style="display: none;" class="product-radio">
            
            <?php if($product->image): ?>
                <img src="<?php echo e(asset('assets/images/products/' . $product->image)); ?>" alt="<?php echo e($product->name); ?>" style="width: 100%; height: 180px; object-fit: cover; border-radius: 8px; margin-bottom: 15px;">
            <?php else: ?>
                <div style="width: 100%; height: 180px; background: var(--gray-200); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
                    <span style="font-size: 48px;">📦</span>
                </div>
            <?php endif; ?>
            
            <div class="checkmark-container" style="position: absolute; top: 15px; right: 15px; display: none;">
                <span class="checkmark">✓</span>
            </div>
            
            <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px;"><?php echo e($product->name); ?></h3>
            <p style="color: var(--primary-green); font-weight: 600; font-size: 14px; margin-bottom: 10px;"><?php echo e($product->code); ?></p>
            
            <?php if($product->description): ?>
            <p style="color: var(--gray-600); font-size: 13px;"><?php echo e(Str::limit($product->description, 80)); ?></p>
            <?php endif; ?>
        </label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
            <div style="font-size: 64px; margin-bottom: 20px;">📦</div>
            <p style="font-size: 18px;">Belum ada data product. Silakan hubungi SuperAdmin untuk menambahkan product.</p>
        </div>
        <?php endif; ?>
    </div>

    <?php if($products->count() > 0): ?>
    <div style="margin-top: 30px; display: flex; gap: 10px;">
        <button type="submit" class="btn btn-primary" id="nextBtn" disabled>Lanjut ke Step 3 →</button>
        <a href="<?php echo e(route('admin.quotations.create')); ?>" class="btn btn-secondary">← Kembali</a>
    </div>
    <?php endif; ?>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .product-card {
        position: relative;
        border: 2px solid transparent;
    }
    
    .product-card:hover {
        border-color: var(--primary-green);
        transform: translateY(-4px);
    }
    
    .product-card.selected {
        border-color: var(--primary-green);
        background: var(--primary-green-light);
    }
    
    .checkmark-container {
        background: var(--primary-green);
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .checkmark {
        color: white;
        font-size: 18px;
        font-weight: bold;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const productCards = document.querySelectorAll('.product-card');
        const nextBtn = document.getElementById('nextBtn');
        
        productCards.forEach(card => {
            card.addEventListener('click', function() {
                // Remove selected class from all cards
                productCards.forEach(c => {
                    c.classList.remove('selected');
                    c.querySelector('.checkmark-container').style.display = 'none';
                });
                
                // Add selected class to clicked card
                this.classList.add('selected');
                this.querySelector('.checkmark-container').style.display = 'flex';
                
                // Check the radio button
                this.querySelector('.product-radio').checked = true;
                
                // Enable next button
                nextBtn.disabled = false;
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/admin/quotations/step2-product.blade.php ENDPATH**/ ?>