

<?php $__env->startSection('title', 'Build Components'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('admin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('admin.quotations.create')); ?>" class="active">🛒 Pemesanan Baru</a></li>
    <li><a href="<?php echo e(route('admin.quotations.index')); ?>">📄 Riwayat Quotations</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Buat Quotation Baru</h1>
    <p style="color: var(--gray-600);">Step 3 dari 3: Build Components (Focus: TOP PANEL)</p>
</div>

<!-- Progress Bar -->
<div style="background: var(--gray-200); height: 8px; border-radius: 4px; margin-bottom: 30px; overflow: hidden;">
    <div style="background: var(--primary-green); height: 100%; width: 100%;"></div>
</div>

<!-- Selected Info -->
<div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px;">
    <div class="card" style="background: var(--primary-green-light); border: 2px solid var(--primary-green);">
        <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 5px;">Buyer:</p>
        <h3 style="font-size: 18px; color: var(--gray-800);"><?php echo e($buyer->name); ?></h3>
    </div>
    <div class="card" style="background: var(--primary-green-light); border: 2px solid var(--primary-green);">
        <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 5px;">Product:</p>
        <h3 style="font-size: 18px; color: var(--gray-800);"><?php echo e($product->name); ?></h3>
    </div>
</div>

<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px;">
    <!-- Left Side: Component Selection -->
    <div>
        <h2 style="font-size: 20px; margin-bottom: 20px; color: var(--gray-800);">Komponen TOP PANEL</h2>

        <!-- Step 1: Input Lebar & Panjang untuk M2 Base -->
        <div class="card" id="step-base-dimensions" style="margin-bottom: 20px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">📐 Input Dimensi Dasar</h3>
                <span class="step-status" id="status-base">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Lebar (mm) *</label>
                    <input type="number" id="base-lebar" class="form-control" placeholder="Contoh: 483" step="0.01" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Panjang (mm) *</label>
                    <input type="number" id="base-panjang" class="form-control" placeholder="Contoh: 660" step="0.01" required>
                </div>
            </div>
            
            <div style="margin-top: 15px; padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="base-result">
                <p style="font-size: 14px; color: var(--gray-600); margin-bottom: 5px;">M² Base:</p>
                <p style="font-size: 24px; font-weight: 700; color: var(--primary-green);" id="base-m2-display">0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculateBaseM2()">Hitung M² Base</button>
        </div>

        <!-- Step 2: Patching Panel 1 -->
        <div class="card component-card" id="step-patching-panel-1" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">1️⃣ Patching Panel 1</h3>
                <span class="step-status" id="status-panel-1">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Material *</label>
                    <select id="panel-1-material" class="form-control" required>
                        <option value="">-- Pilih Material --</option>
                        <?php $__currentLoopData = $panels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $panel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($panel->id); ?>" data-price="<?php echo e($panel->price_per_m2); ?>" data-name="<?php echo e($panel->name); ?>" data-thickness="<?php echo e($panel->thickness); ?>">
                            <?php echo e($panel->name); ?> <?php echo e($panel->thickness); ?>mm - Rp <?php echo e(number_format($panel->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="panel-1-qty" class="form-control" value="1" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="panel-1-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="panel-1-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculatePatchingPanel1()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 3: Patching Solid 2 -->
        <div class="card component-card" id="step-patching-solid-2" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">2️⃣ Patching Solid 2 (Panjang)</h3>
                <span class="step-status" id="status-solid-2">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Tebal (mm) *</label>
                    <select id="solid-2-tebal" class="form-control" required>
                        <option value="">-- Pilih --</option>
                        <?php $__currentLoopData = $dimensions->where('type', 'lebar'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dim): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dim->value); ?>"><?php echo e($dim->value); ?> mm</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Panjang (mm) *</label>
                    <input type="text" class="form-control" value="<?php echo e(old('base-panjang')); ?>" readonly style="background: var(--gray-100);" id="solid-2-panjang-display">
                </div>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Material *</label>
                    <select id="solid-2-material" class="form-control" required>
                        <option value="">-- Pilih Material --</option>
                        <?php $__currentLoopData = $solids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($solid->id); ?>" data-price="<?php echo e($solid->price_per_m2); ?>" data-name="<?php echo e($solid->name); ?>" data-thickness="<?php echo e($solid->thickness); ?>">
                            <?php echo e($solid->name); ?> <?php echo e($solid->thickness); ?>mm - Rp <?php echo e(number_format($solid->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="solid-2-qty" class="form-control" value="2" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="solid-2-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="solid-2-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculatePatchingSolid2()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 4: Patching Solid 3 -->
        <div class="card component-card" id="step-patching-solid-3" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">3️⃣ Patching Solid 3 (Lebar)</h3>
                <span class="step-status" id="status-solid-3">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Tebal (mm) *</label>
                    <select id="solid-3-tebal" class="form-control" required>
                        <option value="">-- Pilih --</option>
                        <?php $__currentLoopData = $dimensions->where('type', 'lebar'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dim): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dim->value); ?>"><?php echo e($dim->value); ?> mm</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Lebar (mm) *</label>
                    <input type="text" class="form-control" value="<?php echo e(old('base-lebar')); ?>" readonly style="background: var(--gray-100);" id="solid-3-lebar-display">
                </div>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Material *</label>
                    <select id="solid-3-material" class="form-control" required>
                        <option value="">-- Pilih Material --</option>
                        <?php $__currentLoopData = $solids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($solid->id); ?>" data-price="<?php echo e($solid->price_per_m2); ?>" data-name="<?php echo e($solid->name); ?>" data-thickness="<?php echo e($solid->thickness); ?>">
                            <?php echo e($solid->name); ?> <?php echo e($solid->thickness); ?>mm - Rp <?php echo e(number_format($solid->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="solid-3-qty" class="form-control" value="2" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="solid-3-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="solid-3-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculatePatchingSolid3()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 5: Crossgrain -->
        <div class="card component-card" id="step-crossgrain" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">4️⃣ Crossgrain</h3>
                <span class="step-status" id="status-crossgrain">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Material *</label>
                    <select id="crossgrain-material" class="form-control" required>
                        <option value="">-- Pilih Material --</option>
                        <?php $__currentLoopData = $mdfs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mdf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($mdf->id); ?>" data-price="<?php echo e($mdf->price_per_m2); ?>" data-name="<?php echo e($mdf->name); ?>" data-thickness="<?php echo e($mdf->thickness); ?>">
                            <?php echo e($mdf->name); ?> <?php echo e($mdf->thickness); ?>mm - Rp <?php echo e(number_format($mdf->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="crossgrain-qty" class="form-control" value="2" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="crossgrain-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="crossgrain-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculateCrossgrain()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 6: Veneer Face -->
        <div class="card component-card" id="step-veneer-face" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">5️⃣ Veneer Face</h3>
                <span class="step-status" id="status-veneer-face">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Veneer *</label>
                    <select id="veneer-face-material" class="form-control" required>
                        <option value="">-- Pilih Veneer --</option>
                        <?php $__currentLoopData = $veneers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $veneer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($veneer->id); ?>" data-price="<?php echo e($veneer->price_per_m2); ?>" data-name="<?php echo e($veneer->name); ?>" data-pattern="<?php echo e($veneer->pattern); ?>">
                            <?php echo e($veneer->name); ?> <?php echo e($veneer->thickness); ?>mm (<?php echo e(ucfirst($veneer->pattern)); ?>) - Rp <?php echo e(number_format($veneer->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="veneer-face-qty" class="form-control" value="1" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="veneer-face-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="veneer-face-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculateVeneerFace()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 7: Veneer Back -->
        <div class="card component-card" id="step-veneer-back" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">6️⃣ Veneer Back</h3>
                <span class="step-status" id="status-veneer-back">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Veneer *</label>
                    <select id="veneer-back-material" class="form-control" required>
                        <option value="">-- Pilih Veneer --</option>
                        <?php $__currentLoopData = $veneers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $veneer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($veneer->id); ?>" data-price="<?php echo e($veneer->price_per_m2); ?>" data-name="<?php echo e($veneer->name); ?>" data-pattern="<?php echo e($veneer->pattern); ?>">
                            <?php echo e($veneer->name); ?> <?php echo e($veneer->thickness); ?>mm (<?php echo e(ucfirst($veneer->pattern)); ?>) - Rp <?php echo e(number_format($veneer->price_per_m2, 0, ',', '.')); ?>/m²
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="veneer-back-qty" class="form-control" value="1" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="veneer-back-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="veneer-back-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculateVeneerBack()">Tambahkan ke Invoice</button>
        </div>

        <!-- Step 8: Other Component (Cleat / Support Drawer / Cleat Drawer) -->
        <div class="card component-card" id="step-other-component" style="margin-bottom: 20px; opacity: 0.5; pointer-events: none;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="font-size: 16px; color: var(--gray-800);">7️⃣ Pilih Salah Satu: Cleat / Support Drawer / Cleat Drawer</h3>
                <span class="step-status" id="status-other">⏳ Pending</span>
            </div>
            
            <div class="grid grid-2" style="gap: 15px; margin-bottom: 15px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Pilih Component *</label>
                    <select id="other-component-material" class="form-control" required>
                        <option value="">-- Pilih Component --</option>
                        <?php $__currentLoopData = $otherComponents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($comp->id); ?>" data-price="<?php echo e($comp->price_per_unit); ?>" data-name="<?php echo e($comp->name); ?>" data-unit="<?php echo e($comp->unit); ?>">
                            <?php echo e($comp->name); ?> - Rp <?php echo e(number_format($comp->price_per_unit, 0, ',', '.')); ?>/<?php echo e($comp->unit); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; font-size: 14px;">Qty *</label>
                    <input type="number" id="other-component-qty" class="form-control" value="6" min="1" required>
                </div>
            </div>
            
            <div style="padding: 12px; background: var(--gray-100); border-radius: 8px; display: none;" id="other-component-result">
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Subtotal:</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);" id="other-component-subtotal">Rp 0</p>
            </div>
            
            <button type="button" class="btn btn-primary" style="margin-top: 15px; width: 100%;" onclick="calculateOtherComponent()">Tambahkan ke Invoice</button>
        </div>
    </div>

    <!-- Right Side: Invoice Summary -->
    <div>
        <div class="card" style="position: sticky; top: 20px;">
            <h2 style="font-size: 18px; margin-bottom: 20px; color: var(--gray-800); border-bottom: 2px solid var(--gray-200); padding-bottom: 10px;">📄 Invoice Summary</h2>
            
            <div id="invoice-items" style="margin-bottom: 20px;">
                <p style="color: var(--gray-500); text-align: center; padding: 20px;">Belum ada item</p>
            </div>
            
            <div style="border-top: 2px solid var(--gray-200); padding-top: 15px; margin-top: 15px;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span style="font-size: 14px; color: var(--gray-600);">Total Item:</span>
                    <span style="font-size: 14px; font-weight: 600;" id="total-items">0</span>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <span style="font-size: 18px; font-weight: 700;">TOTAL:</span>
                    <span style="font-size: 24px; font-weight: 700; color: var(--primary-green);" id="grand-total">Rp 0</span>
                </div>
            </div>
            
            <form action="<?php echo e(route('admin.quotations.store')); ?>" method="POST" id="form-quotation">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="buyer_id" value="<?php echo e($buyer->id); ?>">
                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                <input type="hidden" name="product_code" value="<?php echo e($product->code); ?>">
                <input type="hidden" name="item_name" value="<?php echo e($product->name); ?>">
                <input type="hidden" name="total_price" id="input-total-price" value="0">
                <input type="hidden" name="components" id="input-components" value="[]">
                
                <button type="submit" class="btn btn-primary" style="width: 100%; margin-top: 20px;" id="btn-submit" disabled>
                    Simpan Quotation
                </button>
            </form>
            
            <a href="<?php echo e(route('admin.quotations.create')); ?>" class="btn btn-secondary" style="width: 100%; margin-top: 10px; text-align: center; text-decoration: none; display: block;">← Mulai Ulang</a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .step-status {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
    }
    
    .component-card {
        transition: all 0.3s ease;
    }
    
    .component-card.active {
        opacity: 1 !important;
        pointer-events: auto !important;
        border: 2px solid var(--primary-green);
    }
    
    .invoice-item {
        padding: 12px;
        background: var(--gray-50);
        border-radius: 8px;
        margin-bottom: 10px;
        border-left: 4px solid var(--primary-green);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    let baseM2 = 0;
    let baseLebar = 0;
    let basePanjang = 0;
    let invoiceItems = [];
    let grandTotal = 0;
    
    // Calculate Base M2
    function calculateBaseM2() {
        baseLebar = parseFloat(document.getElementById('base-lebar').value);
        basePanjang = parseFloat(document.getElementById('base-panjang').value);
        
        if (!baseLebar || !basePanjang) {
            alert('Mohon isi Lebar dan Panjang!');
            return;
        }
        
        baseM2 = (baseLebar * basePanjang) / 1000000;
        
        document.getElementById('base-m2-display').textContent = baseM2.toFixed(6) + ' m²';
        document.getElementById('base-result').style.display = 'block';
        document.getElementById('status-base').textContent = '✓ Selesai';
        document.getElementById('status-base').style.background = '#d1fae5';
        document.getElementById('status-base').style.color = '#065f46';
        
        // Update display untuk Solid 2 & 3
        document.getElementById('solid-2-panjang-display').value = basePanjang;
        document.getElementById('solid-3-lebar-display').value = baseLebar;
        
        // Enable next step
        enableStep('step-patching-panel-1');
    }
    
    function enableStep(stepId) {
        document.getElementById(stepId).classList.add('active');
    }
    
    function formatRupiah(number) {
        return 'Rp ' + number.toLocaleString('id-ID');
    }
    
    function updateInvoiceSummary() {
        const container = document.getElementById('invoice-items');
        
        if (invoiceItems.length === 0) {
            container.innerHTML = '<p style="color: var(--gray-500); text-align: center; padding: 20px;">Belum ada item</p>';
            document.getElementById('btn-submit').disabled = true;
        } else {
            let html = '';
            invoiceItems.forEach((item, index) => {
                html += `
                    <div class="invoice-item">
                        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 5px;">
                            <strong style="font-size: 14px; color: var(--gray-800);">${item.name}</strong>
                            <button type="button" onclick="removeItem(${index})" style="background: #ef4444; color: white; border: none; border-radius: 4px; padding: 2px 8px; font-size: 12px; cursor: pointer;">✕</button>
                        </div>
                        <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 3px;">${item.details}</p>
                        <p style="font-size: 14px; font-weight: 600; color: var(--primary-green);">${formatRupiah(item.subtotal)}</p>
                    </div>
                `;
            });
            container.innerHTML = html;
            document.getElementById('btn-submit').disabled = false;
        }
        
        document.getElementById('total-items').textContent = invoiceItems.length;
        document.getElementById('grand-total').textContent = formatRupiah(grandTotal);
        document.getElementById('input-total-price').value = grandTotal;
        document.getElementById('input-components').value = JSON.stringify(invoiceItems);
    }
    
    function removeItem(index) {
        grandTotal -= invoiceItems[index].subtotal;
        invoiceItems.splice(index, 1);
        updateInvoiceSummary();
    }
    
    // Calculate Patching Panel 1
    function calculatePatchingPanel1() {
        const materialSelect = document.getElementById('panel-1-material');
        const qty = parseFloat(document.getElementById('panel-1-qty').value);
        
        if (!materialSelect.value) {
            alert('Mohon pilih material!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const thickness = selectedOption.dataset.thickness;
        
        const subtotal = baseM2 * pricePerM2;
        
        document.getElementById('panel-1-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('panel-1-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Patching Panel 1',
            material_type: materialName + ' ' + thickness + 'mm',
            length: basePanjang,
            width: baseLebar,
            thickness: thickness,
            m2: baseM2,
            qty: 1,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `${baseM2.toFixed(6)} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} ${thickness}mm | ${baseM2.toFixed(6)} m² × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-panel-1').textContent = '✓ Selesai';
        document.getElementById('status-panel-1').style.background = '#d1fae5';
        document.getElementById('status-panel-1').style.color = '#065f46';
        document.getElementById('step-patching-panel-1').style.opacity = '0.7';
        document.getElementById('step-patching-panel-1').style.pointerEvents = 'none';
        
        enableStep('step-patching-solid-2');
    }
    
    // Calculate Patching Solid 2
    function calculatePatchingSolid2() {
        const tebal = parseFloat(document.getElementById('solid-2-tebal').value);
        const materialSelect = document.getElementById('solid-2-material');
        const qty = parseFloat(document.getElementById('solid-2-qty').value);
        
        if (!tebal || !materialSelect.value) {
            alert('Mohon lengkapi semua field!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const thickness = selectedOption.dataset.thickness;
        
        const m2 = (tebal * basePanjang) / 1000000;
        const subtotal = m2 * qty * pricePerM2;
        
        document.getElementById('solid-2-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('solid-2-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Patching Solid 2',
            material_type: materialName + ' ' + thickness + 'mm',
            length: basePanjang,
            width: tebal,
            thickness: thickness,
            m2: m2,
            qty: qty,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `(${tebal} × ${basePanjang}) / 1,000,000 × ${qty} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} ${thickness}mm | ${m2.toFixed(6)} m² × ${qty} × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-solid-2').textContent = '✓ Selesai';
        document.getElementById('status-solid-2').style.background = '#d1fae5';
        document.getElementById('status-solid-2').style.color = '#065f46';
        document.getElementById('step-patching-solid-2').style.opacity = '0.7';
        document.getElementById('step-patching-solid-2').style.pointerEvents = 'none';
        
        enableStep('step-patching-solid-3');
    }
    
    // Calculate Patching Solid 3
    function calculatePatchingSolid3() {
        const tebal = parseFloat(document.getElementById('solid-3-tebal').value);
        const materialSelect = document.getElementById('solid-3-material');
        const qty = parseFloat(document.getElementById('solid-3-qty').value);
        
        if (!tebal || !materialSelect.value) {
            alert('Mohon lengkapi semua field!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const thickness = selectedOption.dataset.thickness;
        
        const m2 = (tebal * baseLebar) / 1000000;
        const subtotal = m2 * qty * pricePerM2;
        
        document.getElementById('solid-3-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('solid-3-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Patching Solid 3',
            material_type: materialName + ' ' + thickness + 'mm',
            length: tebal,
            width: baseLebar,
            thickness: thickness,
            m2: m2,
            qty: qty,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `(${tebal} × ${baseLebar}) / 1,000,000 × ${qty} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} ${thickness}mm | ${m2.toFixed(6)} m² × ${qty} × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-solid-3').textContent = '✓ Selesai';
        document.getElementById('status-solid-3').style.background = '#d1fae5';
        document.getElementById('status-solid-3').style.color = '#065f46';
        document.getElementById('step-patching-solid-3').style.opacity = '0.7';
        document.getElementById('step-patching-solid-3').style.pointerEvents = 'none';
        
        enableStep('step-crossgrain');
    }
    
    // Calculate Crossgrain
    function calculateCrossgrain() {
        const materialSelect = document.getElementById('crossgrain-material');
        const qty = parseFloat(document.getElementById('crossgrain-qty').value);
        
        if (!materialSelect.value) {
            alert('Mohon pilih material!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const thickness = selectedOption.dataset.thickness;
        
        const subtotal = baseM2 * qty * pricePerM2;
        
        document.getElementById('crossgrain-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('crossgrain-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Crossgrain',
            material_type: materialName + ' ' + thickness + 'mm',
            length: basePanjang,
            width: baseLebar,
            thickness: thickness,
            m2: baseM2,
            qty: qty,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `${baseM2.toFixed(6)} × ${qty} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} ${thickness}mm | ${baseM2.toFixed(6)} m² × ${qty} × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-crossgrain').textContent = '✓ Selesai';
        document.getElementById('status-crossgrain').style.background = '#d1fae5';
        document.getElementById('status-crossgrain').style.color = '#065f46';
        document.getElementById('step-crossgrain').style.opacity = '0.7';
        document.getElementById('step-crossgrain').style.pointerEvents = 'none';
        
        enableStep('step-veneer-face');
    }
    
    // Calculate Veneer Face
    function calculateVeneerFace() {
        const materialSelect = document.getElementById('veneer-face-material');
        const qty = parseFloat(document.getElementById('veneer-face-qty').value);
        
        if (!materialSelect.value) {
            alert('Mohon pilih veneer!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const pattern = selectedOption.dataset.pattern;
        
        const subtotal = baseM2 * qty * pricePerM2;
        
        document.getElementById('veneer-face-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('veneer-face-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Veneer Face',
            material_type: materialName + ' (' + pattern + ')',
            length: basePanjang,
            width: baseLebar,
            thickness: 0.5,
            m2: baseM2,
            qty: qty,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `${baseM2.toFixed(6)} × ${qty} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} (${pattern}) | ${baseM2.toFixed(6)} m² × ${qty} × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-veneer-face').textContent = '✓ Selesai';
        document.getElementById('status-veneer-face').style.background = '#d1fae5';
        document.getElementById('status-veneer-face').style.color = '#065f46';
        document.getElementById('step-veneer-face').style.opacity = '0.7';
        document.getElementById('step-veneer-face').style.pointerEvents = 'none';
        
        enableStep('step-veneer-back');
    }
    
    // Calculate Veneer Back
    function calculateVeneerBack() {
        const materialSelect = document.getElementById('veneer-back-material');
        const qty = parseFloat(document.getElementById('veneer-back-qty').value);
        
        if (!materialSelect.value) {
            alert('Mohon pilih veneer!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerM2 = parseFloat(selectedOption.dataset.price);
        const materialName = selectedOption.dataset.name;
        const pattern = selectedOption.dataset.pattern;
        
        const subtotal = baseM2 * qty * pricePerM2;
        
        document.getElementById('veneer-back-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('veneer-back-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: 'Veneer Back',
            material_type: materialName + ' (' + pattern + ')',
            length: basePanjang,
            width: baseLebar,
            thickness: 0.5,
            m2: baseM2,
            qty: qty,
            price_per_unit: pricePerM2,
            subtotal: subtotal,
            note: `${baseM2.toFixed(6)} × ${qty} × ${formatRupiah(pricePerM2)}`,
            details: `${materialName} (${pattern}) | ${baseM2.toFixed(6)} m² × ${qty} × ${formatRupiah(pricePerM2)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-veneer-back').textContent = '✓ Selesai';
        document.getElementById('status-veneer-back').style.background = '#d1fae5';
        document.getElementById('status-veneer-back').style.color = '#065f46';
        document.getElementById('step-veneer-back').style.opacity = '0.7';
        document.getElementById('step-veneer-back').style.pointerEvents = 'none';
        
        enableStep('step-other-component');
    }
    
    // Calculate Other Component
    function calculateOtherComponent() {
        const materialSelect = document.getElementById('other-component-material');
        const qty = parseFloat(document.getElementById('other-component-qty').value);
        
        if (!materialSelect.value) {
            alert('Mohon pilih component!');
            return;
        }
        
        const selectedOption = materialSelect.options[materialSelect.selectedIndex];
        const pricePerUnit = parseFloat(selectedOption.dataset.price);
        const componentName = selectedOption.dataset.name;
        const unit = selectedOption.dataset.unit;
        
        const subtotal = qty * pricePerUnit;
        
        document.getElementById('other-component-subtotal').textContent = formatRupiah(subtotal);
        document.getElementById('other-component-result').style.display = 'block';
        
        // Add to invoice
        invoiceItems.push({
            name: componentName,
            material_type: componentName,
            length: null,
            width: null,
            thickness: null,
            m2: null,
            qty: qty,
            price_per_unit: pricePerUnit,
            subtotal: subtotal,
            note: `${qty} × ${formatRupiah(pricePerUnit)}`,
            details: `${componentName} | ${qty} ${unit} × ${formatRupiah(pricePerUnit)}`
        });
        
        grandTotal += subtotal;
        updateInvoiceSummary();
        
        document.getElementById('status-other').textContent = '✓ Selesai';
        document.getElementById('status-other').style.background = '#d1fae5';
        document.getElementById('status-other').style.color = '#065f46';
        document.getElementById('step-other-component').style.opacity = '0.7';
        document.getElementById('step-other-component').style.pointerEvents = 'none';
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/admin/quotations/step3-components.blade.php ENDPATH**/ ?>