<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\User;

class AdminOnly
{
    public function handle(Request $request, Closure $next)
    {
        $sess = session('user') ?? [];
        $email = $sess['email'] ?? null;
        $name  = $sess['name'] ?? ($sess['displayName'] ?? 'MS User');

        if (!$email) abort(401, 'Not authenticated');

        $me = User::firstOrCreate(['email' => $email], ['name' => $name]);

        if (!$me->relationLoaded('role')) $me->load('role');
        if (!$me->isAdmin()) abort(403, 'Admins only');

        $request->attributes->set('me', $me);

        return $next($request);
    }
}
