<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UploadedForm extends Model
{
    protected $table = 'uploaded_forms';

    protected $fillable = [
        'user_id',
        'title',
        'original_name',
        'path',
        'size',
        'status',
        'user_id',
        'flow',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function isSigned(): bool
    {
        return $this->status === 1;
    }

    public function isUnsigned(): bool
    {
        return $this->status === 0;
    }
}