<?php

namespace App\Services;

use Laravel\Socialite\Contracts\User as SocialiteUser;
use Illuminate\Support\Facades\Session;

class AzureAuthService
{
    public function storeUserInSession(SocialiteUser $user): void
    {
        Session::put('user', [
            'name' => $user->getName(),
            'email' => $user->getEmail(),
        ]);
    }

    public function clearSession(): void
    {
        Session::forget('user');
    }

    public function isAuthenticated(): bool
    {
        return Session::has('user');
    }

    public function user(): ?array
    {
        return Session::get('user');
    }

     public function getDelegatedBusinessCentralToken(string $refreshToken)
    {
        $tenant = env('AZURE_TENANT_ID');
        $clientId = env('AZURE_CLIENT_ID');
        $clientSecret = env('AZURE_CLIENT_SECRET');

        $response = Http::asForm()->post("https://login.microsoftonline.com/$tenant/oauth2/v2.0/token", [
            'client_id'     => $clientId,
            'client_secret' => $clientSecret,
            'grant_type'    => 'refresh_token',
            'refresh_token' => $refreshToken,
            'scope'         => 'https://api.businesscentral.dynamics.com/.default'
        ]);

        if ($response->failed()) {
            return null;
        }

        return $response->json()['access_token'] ?? null;
    }
}
