<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use GuzzleHttp\Promise;
use GuzzleHttp\Promise\Create;
use GuzzleHttp\Promise\Utils;
use Illuminate\Support\Str;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Bus;

class requestToApproveService
{
    public function getAccessToken()
    {
        $client = new Client();
        $response = $client->post("https://login.microsoftonline.com/".env('AZURE_TENANT_ID')."/oauth2/v2.0/token", [
            'form_params' => [
                'grant_type' => 'client_credentials',
                'client_id' => env('AZURE_CLIENT_ID'),
                'client_secret' => env('AZURE_CLIENT_SECRET'),
                'scope' => 'https://api.businesscentral.dynamics.com/.default'
            ]
        ]);
        $body = json_decode((string)$response->getBody(), true);

        return $body['access_token'];
    }

    public function getCompanyId($token)
    {
        $client = new Client();
        $response = $client->get("https://api.businesscentral.dynamics.com/v2.0/" . env('AZURE_TENANT_ID') . "/" . env('BC_ENVIRONMENT') . "/api/v2.0/companies", [
            'headers' => [
                'Authorization' => "Bearer {$token}",
                'Accept'        => 'application/json'
            ]
        ]);
        $companies = json_decode((string)$response->getBody(), true);
        $role = session('user')['role'] ?? null; 
        $companyId1 = $companies['value'][0]['id'];
        $companyId2 = $companies['value'][1]['id'];
        // For Production
        // $companyId1 = $companies['value'][0]['id'];
        // $companyId2 = $companies['value'][1]['id'];
        return [
            'companyId1' => $companyId1,
            'companyId2' => $companyId2
        ];
    }

    public function __construct()
    {
     $this->token = $this->getAccessToken();
     $companyIds = $this->getCompanyId($this->token);
     $this->companyRegent = $companyIds['companyId1'];
     $this->companyHIN    = $companyIds['companyId2'];
     
     $activeCompany = session('current_company_name') ?? session('user')['role'];
    if ($activeCompany === 'Regent' or $activeCompany === 'SUPER') {
        $this->companyId = $this->companyRegent;
    } elseif ($activeCompany === 'HIN' ) {
        $this->companyId = $this->companyHIN;
    }
     $this->client = new Client();
    }

    public function getReqToApprove()
    {
        $start = microtime(true);
        $url = "https://api.businesscentral.dynamics.com/v2.0/"
        . env('AZURE_TENANT_ID') . "/"
        . env('BC_ENVIRONMENT') .
        "/ODataV4/Company('" . $this->companyId . "')/ApprovalEntryAPI?"
        . "\$filter=Status eq 'Open' and ApproverID eq 'MICHAEL DANIEL' and TableId eq 38";


        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ];

        $allData = [];

        $response = $this->client->get($url, $headers);
        $name = session('user.name');

        $decoded = json_decode((string)$response->getBody(), true);

        $value = $decoded['value'];


        return $value;
    }

        public function getPurchaseLines()
    {
        $start = microtime(true);
        $url = "https://api.businesscentral.dynamics.com/v2.0/" 
        . env('AZURE_TENANT_ID') . "/" 
        . env('BC_ENVIRONMENT') .
        "/ODataV4/Company('" . $this->companyId . "')/Purchase_Lines_Excel?"
        . "\$filter=Status eq 'Pending Approval' and Outstanding_Quantity gt 0";



        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ];

        $allData = [];

        $response = $this->client->get($url, $headers);
        $decoded = json_decode((string)$response->getBody(), true);

        $name = session('user.name');
        $value = $decoded['value'];

        return $value;
    }

    public function getPurchaseLinesX($documentNos)
    {
        if (empty($documentNos)) {
            return []; // No approvals assigned to this user
        }

        // Build OData filter for Document_No
        $docFilter = implode(' or ', array_map(function($no) {
            return "Document_No eq '$no'";
        }, $documentNos));

        $url = "https://api.businesscentral.dynamics.com/v2.0/" 
            . env('AZURE_TENANT_ID') . "/" 
            . env('BC_ENVIRONMENT') .
            "/ODataV4/Company('" . $this->companyId . "')/Purchase_Lines_Excel?"
            . "\$filter=Status eq 'Pending Approval' "
            . "and Outstanding_Quantity gt 0 "
            . "and ($docFilter)";

        

        $headers = [
            'headers' => [
                'Authorization' => "Bearer {$this->token}",
                'Accept'        => 'application/json'
            ]
        ];

        $response = $this->client->get($url, $headers);
        $decoded  = json_decode((string)$response->getBody(), true);

        return $decoded['value'];
    }

    public function getMyApprovalLines()
    {
        // Step 1: Get approval entries
        $approvals = $this->getReqToApprove();

        // Extract only document numbers
        $docNos = array_column($approvals, 'DocumentNo');

        // Step 2: Get purchase lines filtered by these document numbers
        $lines = $this->getPurchaseLinesX($docNos);

        dd($lines);
    }
}