import sys
import fitz  # PyMuPDF
from reportlab.lib.units import mm

if len(sys.argv) < 5:
    print("Usage: sign_pdf.py input.pdf output.pdf signature.png signer_name")
    sys.exit(1)

input_pdf = sys.argv[1]
output_pdf = sys.argv[2]
signature = sys.argv[3]
TARGET_TEXT = sys.argv[4]

doc = fitz.open(input_pdf)
signature_placed = False

for page in doc:
    text_instances = page.search_for(TARGET_TEXT)

    if text_instances:
        for rect in text_instances:
            sig_width = 400
            sig_height = 200

            x = rect.x0 - 150
            y = rect.y0 - sig_height + 50

            page.insert_image(
                fitz.Rect(x, y, x + sig_width, y + sig_height),
                filename=signature
            )

            signature_placed = True

# =============================
# FALLBACK IF NAME NOT FOUND
# =============================
if not signature_placed:
    print(f"WARNING: '{TARGET_TEXT}' not found – using fallback coordinates")

    page = doc[-1]  # last page
    width = page.rect.width
    height = page.rect.height

    sig_w = 140 * mm
    sig_h = 70 * mm

    x = width - sig_w - 40
    y = height - sig_h - 120

    page.insert_image(
        fitz.Rect(x, y, x + sig_w, y + sig_h),
        filename=signature
    )

doc.save(output_pdf)
doc.close()

print("SIGNED OK")
