@extends('layouts.app')

@section('title', 'Create User')

@section('content')
<div class="mb-4">
    <h3 class="fw-bold mb-1">➕ Create New User</h3>
    <p class="text-muted mb-0">Fill out the form to add a new user.</p>
</div>

<div class="card card-soft p-4">
    <form action="{{ route('admin.users.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label class="form-label">Name</label>
            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
            @error('name') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
            @error('email') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <div class="mb-3">
            <label class="form-label">Role</label>
            <select name="role_id" class="form-select" required>
                <option value="">Select role</option>
        
                @foreach($roles as $role)
                    <option value="{{ $role->id }}"
                        {{ old('role_id') == $role->id ? 'selected' : '' }}>
                        {{ strtoupper($role->code) }}
                    </option>
                @endforeach
            </select>
        
            @error('role_id')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>


        <button class="btn btn-primary"><i class="fa-solid fa-save me-1"></i> Create User</button>
    </form>
</div>
@endsection
