@extends('layouts.app')

@section('title', 'Dashboards')

@section('content')

<!-- Page Header -->
<div class="mb-4">
    <h3 class="fw-bold mb-1">📊 Power BI Dashboards</h3>
    <p class="text-muted mb-0">
        Centralized access to operational, financial, and room performance reports
    </p>
</div>

<!-- Dashboard Cards -->
<div class="row g-4">
    @foreach ($reports as $r)
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card card-soft h-100">
                <div class="card-body d-flex flex-column">

                    <!-- Icon + Category -->
                    <div class="d-flex align-items-center gap-3 mb-3">
                        <div class="icon-circle">
                            <i class="fa-solid {{ $r['icon'] }}"></i>
                        </div>
                        <div>
                            <div class="fw-semibold">{{ $r['title'] }}</div>
                            <small class="text-muted">{{ $r['category'] }}</small>
                        </div>
                    </div>

                    <!-- Spacer -->
                    <div class="flex-grow-1"></div>

                    <!-- Action -->
                    <a href="{{ $r['url'] }}" target="_blank"
                       class="btn btn-outline-primary btn-sm w-100">
                        Open Report
                    </a>
                </div>
            </div>
        </div>
    @endforeach
</div>

@endsection

@push('styles')
<style>
.icon-circle {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    background: rgba(37,99,235,.12);
    color: #2563eb;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
}

body[data-theme="dark"] .icon-circle {
    background: rgba(37,99,235,.25);
}
</style>
@endpush
