

<?php $__env->startSection('title', 'Signed PDF Forms'); ?>

<?php $__env->startSection('content'); ?>

<div class="mb-4">
    <h3 class="fw-bold mb-1">📄 Signed PDF Forms</h3>
    <p class="text-muted mb-0">All PDFs that have been signed.</p>
</div>

<div class="row g-4">
    <div class="row g-2 mb-3 align-items-center">
        <div class="col">
            <input type="text"
                id="searchInput"
                class="form-control"
                placeholder="Search title / uploader">
        </div>

        <div class="col-auto">
            <select id="filterFlow" class="form-select">
                <option value="">All Flows</option>
                <option value="engineering">ENGINEERING</option>
                <option value="building">BUILDING</option>
            </select>
        </div>
        <div class="col-auto">
            <select id="sortBy" class="form-select">
                <option value="created">Signed Date</option>
                <option value="title">Title</option>
                <option value="size">File Size</option>
            </select>
        </div>

        <div class="col-auto">
            <select id="sortDir" class="form-select">
                <option value="desc">Desc</option>
                <option value="asc">Asc</option>
            </select>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card card-soft h-100">
            <div class="card-body">

                <?php if($forms->isEmpty()): ?>
                    <div class="text-muted small">
                        No signed PDFs yet.
                    </div>
                <?php else: ?>
                    <div class="row g-3">
                        <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12">
                                <div class="card card-hover p-3 d-flex flex-row align-items-center justify-content-between shadow-sm signed-item"
                                    data-title="<?php echo e(strtolower($form->title ?? $form->original_name)); ?>"
                                    data-user="<?php echo e(strtolower($form->user->name ?? '')); ?>"
                                    data-created="<?php echo e($form->updated_at->timestamp); ?>"
                                    data-size="<?php echo e($form->size); ?>"
                                    data-flow="<?php echo e(strtolower($form->flow ?? '')); ?>">
                                    <!-- File Info -->
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="pdf-icon">
                                            <i class="fa-solid fa-file-pdf fa-lg"></i>
                                        </div>
                                        <div>
                                            <div class="fw-semibold">
                                                <?php echo e($form->title ?? $form->original_name); ?>

                                            </div>

                                            <small class="text-muted">
                                                <?php echo e(number_format($form->size / 1024, 1)); ?> KB
                                            </small>

                                           <div class="d-flex justify-content-between align-items-center small text-muted mt-2">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="fa-solid fa-user text-secondary"></i>
                                                    <span>
                                                        Uploaded by
                                                        <strong class="fw-semibold"><?php echo e($form->user->name); ?></strong>
                                                    </span>
                                                </div>
                                                <span class="text-nowrap">
                                                    <i class="fa-regular fa-clock me-1"></i>
                                                    <?php echo e($form->created_at->format('d M Y, H:i')); ?>

                                                </span>
                                            </div>

                                            <div class="d-flex justify-content-between align-items-center small text-muted mt-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="fa-solid fa-pen-nib text-success"></i>
                                                    <span>
                                                        Signed by
                                                        <strong class="text-dark"><?php echo e($form->signed_by->name ?? '-'); ?></strong>
                                                    </span>
                                                </div>
                                                <span class="text-nowrap">
                                                    <i class="fa-regular fa-calendar-check me-1"></i>
                                                    <?php echo e($form->updated_at->format('d M Y, H:i')); ?>

                                                </span>
                                            </div>

                                            <div class="mt-1">
                                                <span class="badge bg-success">Signed</span>
                                                <?php if($form->flow): ?>
                                                    <span class="badge bg-info-subtle text-info-emphasis ms-1">
                                                        <?php echo e($form->flow); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Actions -->
                                    <div class="d-flex gap-2">
                                        <a href="<?php echo e(asset('public/storage/'.$form->path)); ?>"
                                        target="_blank"
                                        class="btn btn-outline-primary btn-sm">
                                            <i class="fa-solid fa-eye me-1"></i> View
                                        </a>
                                    </div>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {

    const searchInput = document.getElementById('searchInput');
    const sortBy      = document.getElementById('sortBy');
    const sortDir     = document.getElementById('sortDir');
    const filterFlow  = document.getElementById('filterFlow');
    const container   = document.querySelector('.row.g-3');

    let items = Array.from(container.querySelectorAll('.col-12'));

    function filterAndSort() {
        const q        = searchInput.value.toLowerCase();
        const sortKey = sortBy.value;
        const dir     = sortDir.value;
        const flow    = filterFlow.value;

        /* ================= FILTER ================= */
        items.forEach(item => {
            const card = item.querySelector('.signed-item');

            const matchText =
                card.dataset.title.includes(q) ||
                card.dataset.user.includes(q);

            const matchFlow =
                !flow || card.dataset.flow === flow;

            item.style.display = (matchText && matchFlow) ? '' : 'none';
        });

        /* ================= SORT ================= */
        items.sort((a, b) => {
            const A = a.querySelector('.signed-item');
            const B = b.querySelector('.signed-item');

            let va, vb;

            if (sortKey === 'created') {
                va = parseInt(A.dataset.created);
                vb = parseInt(B.dataset.created);
            } else if (sortKey === 'size') {
                va = parseInt(A.dataset.size);
                vb = parseInt(B.dataset.size);
            } else {
                va = A.dataset[sortKey];
                vb = B.dataset[sortKey];
            }

            return dir === 'asc'
                ? va > vb ? 1 : -1
                : va < vb ? 1 : -1;
        });

        items.forEach(item => container.appendChild(item));
    }

    /* EVENTS */
    searchInput.addEventListener('input', filterAndSort);
    sortBy.addEventListener('change', filterAndSort);
    sortDir.addEventListener('change', filterAndSort);
    filterFlow.addEventListener('change', filterAndSort);
});
</script>

<?php $__env->stopPush(); ?>


<?php $__env->startPush('styles'); ?>
<style>
.card-soft {
    border: 0;
    border-radius: 14px;
    box-shadow: 0 8px 24px rgba(0,0,0,.05);
}

.pdf-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: rgba(34,197,94,.12); /* green for signed */
    color: #22c55e;
    display: flex;
    align-items: center;
    justify-content: center;
}

.card-hover {
    border-radius: 12px;
    transition: transform 0.2s, box-shadow 0.2s;
    background: #ffffff;
}

.card-hover:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 24px rgba(0,0,0,.1);
}

body[data-theme="dark"] .card-soft {
    background: #0f172a;
}

body[data-theme="dark"] .pdf-icon {
    background: rgba(34,197,94,.25);
}

body[data-theme="dark"] .card-hover {
    background: #1e293b;
}
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/payment-req/resources/views/signed-forms.blade.php ENDPATH**/ ?>