<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudIdentity;

class GoogleAppsCloudidentityDevicesV1CertificateTemplate extends \Google\Model
{
  /**
   * The template id of the template. Example: "1.3.6.1.4.1.311.21.8.15608621.11
   * 768144.5720724.16068415.6889630.81.2472537.7784047".
   *
   * @var string
   */
  public $id;
  /**
   * The Major version of the template. Example: 100.
   *
   * @var int
   */
  public $majorVersion;
  /**
   * The minor version of the template. Example: 12.
   *
   * @var int
   */
  public $minorVersion;

  /**
   * The template id of the template. Example: "1.3.6.1.4.1.311.21.8.15608621.11
   * 768144.5720724.16068415.6889630.81.2472537.7784047".
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * The Major version of the template. Example: 100.
   *
   * @param int $majorVersion
   */
  public function setMajorVersion($majorVersion)
  {
    $this->majorVersion = $majorVersion;
  }
  /**
   * @return int
   */
  public function getMajorVersion()
  {
    return $this->majorVersion;
  }
  /**
   * The minor version of the template. Example: 12.
   *
   * @param int $minorVersion
   */
  public function setMinorVersion($minorVersion)
  {
    $this->minorVersion = $minorVersion;
  }
  /**
   * @return int
   */
  public function getMinorVersion()
  {
    return $this->minorVersion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsCloudidentityDevicesV1CertificateTemplate::class, 'Google_Service_CloudIdentity_GoogleAppsCloudidentityDevicesV1CertificateTemplate');
