<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CustomSearchAPI;

class SearchUrl extends \Google\Model
{
  /**
   * The actual [OpenSearch template](http://www.opensearch.org/specifications/o
   * pensearch/1.1#opensearch_url_template_syntax) for this API.
   *
   * @var string
   */
  public $template;
  /**
   * The MIME type of the OpenSearch URL template for the Custom Search JSON
   * API.
   *
   * @var string
   */
  public $type;

  /**
   * The actual [OpenSearch template](http://www.opensearch.org/specifications/o
   * pensearch/1.1#opensearch_url_template_syntax) for this API.
   *
   * @param string $template
   */
  public function setTemplate($template)
  {
    $this->template = $template;
  }
  /**
   * @return string
   */
  public function getTemplate()
  {
    return $this->template;
  }
  /**
   * The MIME type of the OpenSearch URL template for the Custom Search JSON
   * API.
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SearchUrl::class, 'Google_Service_CustomSearchAPI_SearchUrl');
