<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Directory;

class DirectoryUsersCreateGuestRequest extends \Google\Model
{
  /**
   * Optional. Immutable ID of the Google Workspace account.
   *
   * @var string
   */
  public $customer;
  /**
   * Immutable. External email of the guest user being created.
   *
   * @var string
   */
  public $primaryGuestEmail;

  /**
   * Optional. Immutable ID of the Google Workspace account.
   *
   * @param string $customer
   */
  public function setCustomer($customer)
  {
    $this->customer = $customer;
  }
  /**
   * @return string
   */
  public function getCustomer()
  {
    return $this->customer;
  }
  /**
   * Immutable. External email of the guest user being created.
   *
   * @param string $primaryGuestEmail
   */
  public function setPrimaryGuestEmail($primaryGuestEmail)
  {
    $this->primaryGuestEmail = $primaryGuestEmail;
  }
  /**
   * @return string
   */
  public function getPrimaryGuestEmail()
  {
    return $this->primaryGuestEmail;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DirectoryUsersCreateGuestRequest::class, 'Google_Service_Directory_DirectoryUsersCreateGuestRequest');
