<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class WebToken extends \Google\Collection
{
  protected $collection_key = 'permissions';
  /**
   * The features to enable. Use this if you want to control exactly which
   * feature(s) will be activated; leave empty to allow all
   * features.Restrictions / things to note: - If no features are listed here,
   * all features are enabled — this is the default behavior where you give
   * access to all features to your admins. - This must not contain any
   * FEATURE_UNSPECIFIED values. - Repeated values are ignored
   *
   * @var string[]
   */
  public $enabledFeatures;
  /**
   * The name of the web token, which is generated by the server during creation
   * in the form enterprises/{enterpriseId}/webTokens/{webTokenId}.
   *
   * @var string
   */
  public $name;
  /**
   * The URL of the parent frame hosting the iframe with the embedded UI. To
   * prevent XSS, the iframe may not be hosted at other URLs. The URL must use
   * the https scheme.
   *
   * @var string
   */
  public $parentFrameUrl;
  /**
   * Permissions available to an admin in the embedded UI. An admin must have
   * all of these permissions in order to view the UI. This field is deprecated.
   *
   * @deprecated
   * @var string[]
   */
  public $permissions;
  /**
   * The token value which is used in the hosting page to generate the iframe
   * with the embedded UI. This is a read-only field generated by the server.
   *
   * @var string
   */
  public $value;

  /**
   * The features to enable. Use this if you want to control exactly which
   * feature(s) will be activated; leave empty to allow all
   * features.Restrictions / things to note: - If no features are listed here,
   * all features are enabled — this is the default behavior where you give
   * access to all features to your admins. - This must not contain any
   * FEATURE_UNSPECIFIED values. - Repeated values are ignored
   *
   * @param string[] $enabledFeatures
   */
  public function setEnabledFeatures($enabledFeatures)
  {
    $this->enabledFeatures = $enabledFeatures;
  }
  /**
   * @return string[]
   */
  public function getEnabledFeatures()
  {
    return $this->enabledFeatures;
  }
  /**
   * The name of the web token, which is generated by the server during creation
   * in the form enterprises/{enterpriseId}/webTokens/{webTokenId}.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The URL of the parent frame hosting the iframe with the embedded UI. To
   * prevent XSS, the iframe may not be hosted at other URLs. The URL must use
   * the https scheme.
   *
   * @param string $parentFrameUrl
   */
  public function setParentFrameUrl($parentFrameUrl)
  {
    $this->parentFrameUrl = $parentFrameUrl;
  }
  /**
   * @return string
   */
  public function getParentFrameUrl()
  {
    return $this->parentFrameUrl;
  }
  /**
   * Permissions available to an admin in the embedded UI. An admin must have
   * all of these permissions in order to view the UI. This field is deprecated.
   *
   * @deprecated
   * @param string[] $permissions
   */
  public function setPermissions($permissions)
  {
    $this->permissions = $permissions;
  }
  /**
   * @deprecated
   * @return string[]
   */
  public function getPermissions()
  {
    return $this->permissions;
  }
  /**
   * The token value which is used in the hosting page to generate the iframe
   * with the embedded UI. This is a read-only field generated by the server.
   *
   * @param string $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WebToken::class, 'Google_Service_AndroidManagement_WebToken');
