<?php

use Illuminate\Support\Facades\Route;
use App\Services\BusinessCentralService;
use App\Services\InventoryBC;
use App\Http\Controllers\BusinessCentralController;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\AzureAuthController;
use SocialiteProviders\Manager\SocialiteWasCalled;
use Illuminate\Support\Facades\Event;
use SocialiteProviders\Microsoft\MicrosoftExtendSocialite;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use App\Http\Controllers\OneDriveController;
use App\Http\Controllers\ItemRequestController;
use App\Http\Controllers\ApproveController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ItemRequestCommentController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\UserRequestController;
use App\Http\Controllers\TransferHeaderController;
use App\Services\requestToApproveService;
use App\Http\Controllers\DashboardHubController;




Route::get('/', function () {
    return redirect()->route('login');
});
Route::get('/csrf/refresh', fn() => response()->json(['token' => csrf_token()]))->name('csrf.refresh');
Route::get('/login', [AzureAuthController::class, 'redirectToProvider'])->name('login');
Route::get('/auth/callback', [AzureAuthController::class, 'handleProviderCallback']);
Route::get('/logout', [AzureAuthController::class, 'logout'])->name('logout');

Route::middleware('bc.auth')->group(function () {
    Route::get('/pbi-dashboards', [DashboardHubController::class, 'index'])
    ->name('dashboards.index');
    Route::get('/switch-company/{type}', function ($type) {
        $role = session('user')['role'] ?? null;
        $email = session('user')['email'] ?? null;
    
        if ($role === 'Regent' && $type !== 'Regent') {
            abort(403, 'Unauthorized');
        }
        if ($role === 'HIN' && $type !== 'HIN') {
            abort(403, 'Unauthorized');
        }
    
        session(['current_company_name' => $type]);
    
        if ($email) {
            $cacheKey = 'po_suggestions_' . md5($email);
            Cache::forget($cacheKey);
            
        }
        
        $skuCacheKey = 'sku_mapping_cache';
        if (Cache::has($skuCacheKey)) {
            Cache::forget($skuCacheKey);
        }
        
        Session::forget(['po_items', 'vendor_map']);

        $prev = url()->previous();
        $prevRouteName = null;
        try {
            $prevRouteName = app('router')
                ->getRoutes()
                ->match(Request::create($prev))
                ->getName();
        } catch (\Throwable $e) {

        }

        $msg = "Switched to {$type} environment and cleared caches.";

        if (in_array($prevRouteName, ['approvals.show', 'approvals.edit'], true)) {
            return redirect()->route('approvals.mine')->with('success', $msg);
        }
    
        return redirect()
        ->back()
        ->with('success', "Switched to {$type} environment and cleared caches.");
    })->name('switch-company');
    //getItemInvenLoc
}); 
