<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class BcToken extends Model
{
    protected $fillable = [
        'token_type',
        'access_token',
        'expires_in',
        'expires_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
    ];

    public function isExpired(): bool
    {
        return Carbon::now()->greaterThanOrEqualTo($this->expires_at);
    }

    public static function getValidToken(): ?string
    {
        $token = self::latest()->first();

        if ($token && !$token->isExpired()) {
            return $token->access_token;
        }

        return null;
    }
}