<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('po_rekap', function (Blueprint $table) {
            $table->id();
            $table->string('document_no')->index();
            $table->string('company')->index(); // TBI or CI
            $table->string('category')->index(); // HIRBND, HO, CI, HIRBC, RBC, LDR
            $table->date('document_date')->nullable();
            $table->string('buy_from_vendor_name')->nullable();
            $table->string('shortcut_dimension_1_code')->nullable();
            $table->decimal('amount', 20, 2)->default(0);
            $table->decimal('amount_including_vat', 20, 2)->default(0);
            $table->string('approver_id')->index();
            $table->string('document_type')->nullable();
            $table->string('status')->nullable();
            $table->string('auxiliary_index1')->nullable();
            $table->bigInteger('auxiliary_index2')->nullable();
            $table->timestamps();
            
            // Composite unique index
            $table->unique(['document_no', 'company', 'category', 'approver_id'], 'po_rekap_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('po_rekap');
    }
};