<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('approval_history', function (Blueprint $table) {
            $table->id();
            $table->string('document_no')->index();
            $table->string('company')->index();
            $table->string('category')->index();
            $table->string('approver_id')->index();
            $table->string('approver_email');
            $table->enum('action', ['approved', 'rejected']);
            $table->text('remarks')->nullable();
            $table->timestamp('action_date');
            $table->json('response_data')->nullable(); // Store API response
            $table->timestamps();
            
            // Index for admin dashboard
            $table->index(['action', 'action_date'], 'history_admin_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('approval_history');
    }
};