@extends('layouts.app')

@section('title', 'Login - PO Approval System')

@section('content')
<style>
    .login-container {
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .login-box {
        background: white;
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        overflow: hidden;
        width: 100%;
        max-width: 900px;
        display: flex;
    }

    .login-left {
        flex: 1;
        background: linear-gradient(135deg, #2c7a3f 0%, #1e5630 100%);
        padding: 60px 40px;
        color: white;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .login-left h1 {
        font-size: 32px;
        margin-bottom: 20px;
        font-weight: 700;
    }

    .login-left p {
        font-size: 16px;
        opacity: 0.9;
        line-height: 1.8;
    }

    .login-left .company-info {
        margin-top: 40px;
        padding-top: 30px;
        border-top: 1px solid rgba(255,255,255,0.2);
    }

    .login-left .company-info h3 {
        font-size: 18px;
        margin-bottom: 10px;
    }

    .login-right {
        flex: 1;
        padding: 60px 40px;
    }

    .login-tabs {
        display: flex;
        border-bottom: 2px solid var(--border-color);
        margin-bottom: 30px;
    }

    .login-tab {
        flex: 1;
        padding: 15px;
        text-align: center;
        cursor: pointer;
        font-weight: 600;
        color: var(--text-light);
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
    }

    .login-tab.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
    }

    .login-tab:hover {
        color: var(--primary-dark);
    }

    .tab-content {
        display: none;
    }

    .tab-content.active {
        display: block;
    }

    .microsoft-btn {
        background: white;
        border: 2px solid var(--border-color);
        color: var(--text-dark);
        padding: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .microsoft-btn:hover {
        border-color: var(--primary-color);
        background: #f8f9fa;
        transform: translateY(-2px);
    }

    .microsoft-icon {
        width: 24px;
        height: 24px;
    }

    .divider {
        text-align: center;
        margin: 30px 0;
        position: relative;
    }

    .divider::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 1px;
        background: var(--border-color);
    }

    .divider span {
        background: white;
        padding: 0 15px;
        position: relative;
        color: var(--text-light);
        font-size: 14px;
    }

    @media (max-width: 768px) {
        .login-box {
            flex-direction: column;
        }

        .login-left {
            padding: 40px 30px;
        }

        .login-right {
            padding: 40px 30px;
        }

        .login-left h1 {
            font-size: 24px;
        }
    }
</style>

<div class="login-container">
    <div class="login-box">
        <div class="login-left">
            <h1>PO Approval System</h1>
            <p>Streamline your purchase order approval process with our integrated Business Central solution.</p>
            <p>Access real-time data, approve or reject orders, and maintain complete audit trails.</p>
            
            <div class="company-info">
                <h3>BALI</h3>
                <p style="font-size: 14px; opacity: 0.8;">TBI & CI Division</p>
            </div>
        </div>

        <div class="login-right">
            <div class="login-tabs">
                <div class="login-tab active" data-tab="microsoft">
                    Microsoft Login
                </div>
                <div class="login-tab" data-tab="admin">
                    Admin Login
                </div>
            </div>

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <!-- Microsoft Login Tab -->
            <div class="tab-content active" id="microsoft-tab">
                <h2 style="margin-bottom: 10px; font-size: 24px;">Sign in with Microsoft</h2>
                <p style="color: var(--text-light); margin-bottom: 30px;">Use your company Microsoft account to access the system</p>

                <a href="{{ route('auth.microsoft') }}" class="btn microsoft-btn btn-block">
                    <svg class="microsoft-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 23 23">
                        <path fill="#f3f3f3" d="M0 0h23v23H0z"/>
                        <path fill="#f35325" d="M1 1h10v10H1z"/>
                        <path fill="#81bc06" d="M12 1h10v10H12z"/>
                        <path fill="#05a6f0" d="M1 12h10v10H1z"/>
                        <path fill="#ffba08" d="M12 12h10v10H12z"/>
                    </svg>
                    Continue with Microsoft
                </a>

                <div class="divider">
                    <span>Secure Authentication</span>
                </div>

                <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; font-size: 13px; color: var(--text-light);">
                    <strong>Note:</strong> You will be redirected to Microsoft login page. Please use your @citbi.onmicrosoft.com email address.
                </div>
            </div>

            <!-- Admin Login Tab -->
            <div class="tab-content" id="admin-tab">
                <h2 style="margin-bottom: 10px; font-size: 24px;">Admin Login</h2>
                <p style="color: var(--text-light); margin-bottom: 30px;">System administrators only</p>

                <form method="POST" action="{{ route('admin.login') }}">
                    @csrf

                    <div class="form-group">
                        <label class="form-label">Email Address</label>
                        <input type="email" name="email" class="form-control" 
                               placeholder="admin@citbi.com" required value="{{ old('email') }}">
                        @error('email')
                            <small style="color: var(--danger-color);">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control" 
                               placeholder="Enter your password" required>
                        @error('password')
                            <small style="color: var(--danger-color);">{{ $message }}</small>
                        @enderror
                    </div>

                    <button type="submit" class="btn btn-primary btn-block">
                        Login as Admin
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Tab switching
    document.querySelectorAll('.login-tab').forEach(tab => {
        tab.addEventListener('click', function() {
            const tabName = this.dataset.tab;
            
            // Remove active class from all tabs and contents
            document.querySelectorAll('.login-tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
            
            // Add active class to clicked tab and corresponding content
            this.classList.add('active');
            document.getElementById(tabName + '-tab').classList.add('active');
        });
    });
</script>
@endsection