@extends('layouts.dashboard')

@section('title', 'Dashboard - PO Approval System')
@section('page-title', 'Dashboard')

@section('content')
<style>
    .welcome-section {
        text-align: center;
        padding: 60px 20px;
    }

    .welcome-icon {
        width: 120px;
        height: 120px;
        margin: 0 auto 30px;
        background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(44, 122, 63, 0.2);
    }

    .welcome-icon img {
        width: 70px;
        height: 70px;
        object-fit: contain;
    }

    .welcome-icon svg {
        width: 60px;
        height: 60px;
        fill: #2c7a3f;
    }

    .welcome-section h2 {
        font-size: 32px;
        color: #2c3e50;
        margin-bottom: 15px;
        font-weight: 700;
    }

    .welcome-section p {
        color: #6c757d;
        font-size: 16px;
        max-width: 600px;
        margin: 0 auto;
        line-height: 1.6;
    }

    .company-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        max-width: 800px;
        margin: 0 auto;
        padding: 40px 20px;
    }

    .company-card {
        background: white;
        border-radius: 15px;
        padding: 40px 30px;
        text-decoration: none;
        color: inherit;
        transition: all 0.3s ease;
        box-shadow: 0 2px 15px rgba(0,0,0,0.08);
        text-align: center;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .company-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #2c7a3f 0%, #1e5630 100%);
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }

    .company-card:hover::before {
        transform: scaleX(1);
    }

    .company-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
    }

    .company-icon-card {
        width: 80px;
        height: 80px;
        margin: 0 auto 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .company-icon-card img {
        width: 60px;
        height: 60px;
        object-fit: contain;
    }

    .company-icon-card svg {
        width: 50px;
        height: 50px;
        fill: #495057;
    }

    .company-name {
        font-size: 24px;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 10px;
    }

    .company-count {
        font-size: 48px;
        font-weight: 700;
        color: #2c7a3f;
        margin-bottom: 10px;
        line-height: 1;
    }

    .company-label {
        font-size: 14px;
        color: #6c757d;
        font-weight: 500;
    }

    @media (max-width: 768px) {
        .company-cards {
            grid-template-columns: 1fr;
            padding: 30px 20px;
        }

        .welcome-section {
            padding: 40px 20px;
        }

        .welcome-section h2 {
            font-size: 24px;
        }

        .welcome-icon {
            width: 100px;
            height: 100px;
        }

        .welcome-icon img {
            width: 60px;
            height: 60px;
        }

        .welcome-icon svg {
            width: 50px;
            height: 50px;
        }

        .company-count {
            font-size: 40px;
        }

        .company-name {
            font-size: 20px;
        }
    }
</style>

<div class="welcome-section">
    <div class="welcome-icon">
        <img src="{{ asset('images/logo-po.png') }}" alt="Release PO" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
        <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M20 6h-2.18c.11-.31.18-.65.18-1a2.996 2.996 0 0 0-5.5-1.65l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z"/>
        </svg>
    </div>
    <h2>Welcome to Release PO System</h2>
    <p>Select a location and category from the sidebar to view and manage purchase orders. You can release or reject purchase orders based on your approval workflow.</p>
</div>

<div class="company-cards">
    <!-- TBI Card -->
    <a href="{{ route('tbi.hirbnd') }}" class="company-card">
        <div class="company-icon-card">
            <img src="{{ asset('images/tbi.jpg') }}" alt="TBI" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
            <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M12 2L4 5v6.09c0 5.05 3.41 9.76 8 10.91 4.59-1.15 8-5.86 8-10.91V5l-8-3zm6 9.09c0 4-2.55 7.7-6 8.83-3.45-1.13-6-4.82-6-8.83V6.31l6-2.12 6 2.12v4.78z"/>
            </svg>
        </div>
        <div class="company-name">Tanjung Benoa Indonesia</div>
        <div class="company-count">{{ $stats['tbi_hirbnd'] + $stats['tbi_ho'] }}</div>
        <div class="company-label">Purchase Orders</div>
    </a>

    <!-- CI Card -->
    <a href="{{ route('ci.ci') }}" class="company-card">
        <div class="company-icon-card">
            <img src="{{ asset('images/ci.jpg') }}" alt="CI" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
            <svg style="display: none;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M12 2L4 5v6.09c0 5.05 3.41 9.76 8 10.91 4.59-1.15 8-5.86 8-10.91V5l-8-3zm6 9.09c0 4-2.55 7.7-6 8.83-3.45-1.13-6-4.82-6-8.83V6.31l6-2.12 6 2.12v4.78z"/>
            </svg>
        </div>
        <div class="company-name">Canggu International</div>
        <div class="company-count">{{ $stats['ci_ci'] + $stats['ci_hirbc'] + $stats['ci_rbc'] + $stats['ci_ldr'] }}</div>
        <div class="company-label">Purchase Orders</div>
    </a>
</div>
@endsection