<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ApprovalController;

// ==================== PUBLIC ROUTES ====================
Route::get('/', function () {
    return redirect()->route('login');
});

// Login Routes (with guest middleware)
Route::middleware(['guest'])->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/admin/login', [AuthController::class, 'adminLogin'])->name('admin.login');
    Route::get('/auth/microsoft', [AuthController::class, 'redirectToMicrosoft'])->name('auth.microsoft');
});

// Microsoft OAuth Callback (outside guest middleware)
Route::get('/auth/callback', [AuthController::class, 'handleMicrosoftCallback'])->name('auth.callback');

// Logout
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// ==================== AUTHENTICATED USER ROUTES ====================
Route::middleware(['auth.user'])->group(function () {
    
    // Data Loading
    Route::get('/data/load', [AuthController::class, 'showDataLoad'])->name('data.load');
    Route::post('/data/load', [AuthController::class, 'loadData'])->name('data.load.process');
    
    // Dashboard (User)
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // TBI Routes
    Route::prefix('tbi')->name('tbi.')->group(function () {
        Route::get('/hirbnd', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'TBI')
            ->defaults('category', 'HIRBND')
            ->name('hirbnd');
            
        Route::get('/ho', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'TBI')
            ->defaults('category', 'HO')
            ->name('ho');
    });
    
    // CI Routes
    Route::prefix('ci')->name('ci.')->group(function () {
        Route::get('/ci', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'CI')
            ->defaults('category', 'CI')
            ->name('ci');
            
        Route::get('/ci-supplies', [DashboardController::class, 'showCategoryNoApi'])
            ->defaults('company', 'CI')
            ->defaults('category', 'CI_SUPPLIES')
            ->name('ci_supplies');
            
        Route::get('/hirbc', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'CI')
            ->defaults('category', 'HIRBC')
            ->name('hirbc');
            
        Route::get('/rbc', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'CI')
            ->defaults('category', 'RBC')
            ->name('rbc');
            
        Route::get('/ldr', [DashboardController::class, 'showCategory'])
            ->defaults('company', 'CI')
            ->defaults('category', 'LDR')
            ->name('ldr');
    });
    
    // Get PO Details (AJAX)
    Route::get('/po/details/{company}/{category}/{documentNo}', [DashboardController::class, 'getPoDetails'])
        ->name('po.details');
    
    // Approval Actions
    Route::post('/po/approve', [ApprovalController::class, 'approve'])->name('po.approve');
    Route::post('/po/reject', [ApprovalController::class, 'reject'])->name('po.reject');
    
    // Bulk Approval Actions
    Route::post('/po/bulk-approve', [ApprovalController::class, 'bulkApprove'])->name('po.bulk.approve');
    Route::post('/po/bulk-reject', [ApprovalController::class, 'bulkReject'])->name('po.bulk.reject');
    
    // Approval History
    Route::get('/history', [DashboardController::class, 'history'])->name('history');
});

// ==================== ADMIN ROUTES ====================
Route::middleware(['auth.admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/approvals/export', [AdminController::class, 'exportApprovals'])->name('approvals.export');
});