

<?php $__env->startSection('title', 'Loading Data - PO Approval System'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .load-container {
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .load-box {
        background: white;
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        padding: 60px 40px;
        text-align: center;
        max-width: 600px;
        width: 100%;
    }

    .load-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 30px;
        background: linear-gradient(135deg, #2c7a3f 0%, #1e5630 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .load-icon svg {
        width: 40px;
        height: 40px;
        fill: white;
    }

    .load-title {
        font-size: 28px;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 15px;
    }

    .load-subtitle {
        font-size: 16px;
        color: var(--text-light);
        margin-bottom: 40px;
    }

    .load-spinner {
        border: 6px solid rgba(44, 122, 63, 0.1);
        border-top: 6px solid var(--primary-color);
        border-radius: 50%;
        width: 60px;
        height: 60px;
        animation: spin 1s linear infinite;
        margin: 0 auto 30px;
    }

    .load-status {
        font-size: 14px;
        color: var(--text-dark);
        margin-bottom: 20px;
        min-height: 40px;
    }

    .load-progress {
        background: #f0f0f0;
        height: 8px;
        border-radius: 10px;
        overflow: hidden;
        margin-bottom: 20px;
    }

    .load-progress-bar {
        background: linear-gradient(90deg, var(--primary-color) 0%, var(--primary-light) 100%);
        height: 100%;
        width: 0%;
        transition: width 0.3s ease;
        animation: progress-pulse 1.5s ease-in-out infinite;
    }

    @keyframes progress-pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.7; }
    }

    .load-details {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-top: 30px;
        text-align: left;
    }

    .load-detail-item {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        border-bottom: 1px solid var(--border-color);
        font-size: 14px;
    }

    .load-detail-item:last-child {
        border-bottom: none;
    }

    .load-detail-label {
        color: var(--text-light);
        font-weight: 600;
    }

    .load-detail-value {
        color: var(--text-dark);
        font-weight: 700;
    }

    .success-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 30px;
        background: var(--success-color);
        border-radius: 50%;
        display: none;
        align-items: center;
        justify-content: center;
    }

    .success-icon svg {
        width: 40px;
        height: 40px;
        fill: white;
    }

    .error-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 30px;
        background: var(--danger-color);
        border-radius: 50%;
        display: none;
        align-items: center;
        justify-content: center;
    }

    .error-icon svg {
        width: 40px;
        height: 40px;
        fill: white;
    }
</style>

<div class="load-container">
    <div class="load-box">
        <!-- Loading Icon -->
        <div class="load-icon" id="loadIcon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M20 6h-2.18c.11-.31.18-.65.18-1a2.996 2.996 0 0 0-5.5-1.65l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z"/>
            </svg>
        </div>

        <!-- Success Icon -->
        <div class="success-icon" id="successIcon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
            </svg>
        </div>

        <!-- Error Icon -->
        <div class="error-icon" id="errorIcon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
            </svg>
        </div>

        <h1 class="load-title">Loading Purchase Order Data</h1>
        <p class="load-subtitle">Connecting to Business Central system...</p>

        <div class="load-spinner" id="loadSpinner"></div>

        <div class="load-status" id="loadStatus">
            Initializing connection...
        </div>

        <div class="load-progress">
            <div class="load-progress-bar" id="progressBar"></div>
        </div>

        <div class="load-details" id="loadDetails" style="display: none;">
            <div class="load-detail-item">
                <span class="load-detail-label">Rekap Records:</span>
                <span class="load-detail-value" id="rekapCount">0</span>
            </div>
            <div class="load-detail-item">
                <span class="load-detail-label">Detail Records:</span>
                <span class="load-detail-value" id="detailCount">0</span>
            </div>
            <div class="load-detail-item">
                <span class="load-detail-label">Status:</span>
                <span class="load-detail-value" id="statusText">Processing...</span>
            </div>
        </div>

        <div id="errorMessage" style="display: none; margin-top: 20px;">
            <div class="alert alert-danger">
                <strong>Error:</strong> <span id="errorText"></span>
            </div>
            <button class="btn btn-primary" onclick="retryLoad()">Retry</button>
        </div>
    </div>
</div>

<script>
    let progressInterval;
    let currentProgress = 0;

    // Start loading on page load
    window.addEventListener('load', function() {
        startLoading();
    });

    function startLoading() {
        currentProgress = 0;
        updateProgress(10);
        updateStatus('Connecting to BC system...');

        // Simulate progress
        progressInterval = setInterval(() => {
            if (currentProgress < 90) {
                currentProgress += Math.random() * 15;
                updateProgress(Math.min(currentProgress, 90));
            }
        }, 500);

        // Call API to load data
        fetch('<?php echo e(route('data.load.process')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            clearInterval(progressInterval);
            
            if (data.success) {
                updateProgress(100);
                updateStatus('Data loaded successfully!');
                showSuccess(data.stats);
                
                // Redirect to dashboard
                setTimeout(() => {
                    window.location.href = data.redirect;
                }, 2000);
            } else {
                showError(data.message);
            }
        })
        .catch(error => {
            clearInterval(progressInterval);
            showError('Network error: ' + error.message);
        });
    }

    function updateProgress(percent) {
        document.getElementById('progressBar').style.width = percent + '%';
    }

    function updateStatus(message) {
        document.getElementById('loadStatus').textContent = message;
    }

    function showSuccess(stats) {
        document.getElementById('loadIcon').style.display = 'none';
        document.getElementById('loadSpinner').style.display = 'none';
        document.getElementById('successIcon').style.display = 'flex';
        
        document.getElementById('rekapCount').textContent = stats.rekap_synced || 0;
        document.getElementById('detailCount').textContent = stats.detail_synced || 0;
        document.getElementById('statusText').textContent = 'Completed';
        document.getElementById('statusText').style.color = 'var(--success-color)';
        
        document.getElementById('loadDetails').style.display = 'block';
    }

    function showError(message) {
        document.getElementById('loadIcon').style.display = 'none';
        document.getElementById('loadSpinner').style.display = 'none';
        document.getElementById('errorIcon').style.display = 'flex';
        
        updateStatus('Loading failed');
        document.getElementById('errorText').textContent = message;
        document.getElementById('errorMessage').style.display = 'block';
    }

    function retryLoad() {
        // Reset UI
        document.getElementById('loadIcon').style.display = 'flex';
        document.getElementById('successIcon').style.display = 'none';
        document.getElementById('errorIcon').style.display = 'none';
        document.getElementById('loadSpinner').style.display = 'block';
        document.getElementById('errorMessage').style.display = 'none';
        document.getElementById('loadDetails').style.display = 'none';
        
        // Restart loading
        startLoading();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/po-approval-system/laravel/resources/views/auth/data-load.blade.php ENDPATH**/ ?>