<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Admin Dashboard - PO Approval System</title>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .admin-header {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: var(--shadow-lg);
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 20px;
        }

        .admin-header h1 {
            font-size: 28px;
            color: var(--text-dark);
            margin: 0;
        }

        .admin-header p {
            color: var(--text-light);
            margin: 5px 0 0 0;
        }

        .admin-actions {
            display: flex;
            gap: 10px;
            align-items: center;
        }

        .admin-user {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 15px;
            background: var(--bg-light);
            border-radius: 8px;
        }

        .admin-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: var(--shadow);
        }

        .stat-card-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .stat-icon.success {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        }

        .stat-icon.danger {
            background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%);
        }

        .stat-icon.info {
            background: linear-gradient(135deg, #17a2b8 0%, #6610f2 100%);
        }

        .stat-icon svg {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .stat-value {
            font-size: 36px;
            font-weight: 700;
            color: var(--text-dark);
        }

        .stat-label {
            color: var(--text-light);
            font-size: 14px;
            font-weight: 600;
        }

        .filters-section {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: var(--shadow);
        }

        .filters-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        .approvals-table {
            background: white;
            border-radius: 15px;
            box-shadow: var(--shadow);
            overflow: hidden;
        }

        .table-header {
            padding: 25px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .table-header h3 {
            font-size: 20px;
            color: var(--text-dark);
            margin: 0;
        }

        .approval-table {
            width: 100%;
            border-collapse: collapse;
        }

        .approval-table thead {
            background: var(--bg-light);
        }

        .approval-table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            font-size: 13px;
            color: var(--text-dark);
            border-bottom: 2px solid var(--border-color);
            white-space: nowrap;
        }

        .approval-table td {
            padding: 15px;
            border-bottom: 1px solid var(--border-color);
            font-size: 14px;
        }

        .approval-table tbody tr:hover {
            background: #f8f9fa;
        }

        .company-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }

        .company-badge.tbi {
            background: #d4edda;
            color: #155724;
        }

        .company-badge.ci {
            background: #d1ecf1;
            color: #0c5460;
        }

        .no-data {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-light);
        }

        .no-data svg {
            width: 80px;
            height: 80px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        .pagination {
            padding: 20px;
            display: flex;
            justify-content: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            text-decoration: none;
            color: var(--text-dark);
            background: white;
        }

        .pagination a:hover {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        .pagination .active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        @media (max-width: 768px) {
            .admin-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .filters-grid {
                grid-template-columns: 1fr;
            }

            .approvals-table {
                overflow-x: auto;
            }

            .approval-table {
                min-width: 1000px;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <!-- Header -->
        <div class="admin-header">
            <div>
                <h1>Admin Dashboard</h1>
                <p>Monitor all purchase order approvals across the system</p>
            </div>
            <div class="admin-actions">
                <div class="admin-user">
                    <div class="admin-avatar">AD</div>
                    <div>
                        <div style="font-weight: 600; font-size: 14px;"><?php echo e(Auth::user()->name); ?></div>
                        <div style="font-size: 12px; color: var(--text-light);">Administrator</div>
                    </div>
                </div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 5px;">
                            <path d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" fill="currentColor"/>
                        </svg>
                        Logout
                    </button>
                </form>
            </div>
        </div>

        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-card-header">
                    <div class="stat-icon success">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                        </svg>
                    </div>
                    <div class="stat-value"><?php echo e($stats['total_approved']); ?></div>
                </div>
                <div class="stat-label">Total Approved</div>
            </div>

            <div class="stat-card">
                <div class="stat-card-header">
                    <div class="stat-icon danger">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
                        </svg>
                    </div>
                    <div class="stat-value"><?php echo e($stats['total_rejected']); ?></div>
                </div>
                <div class="stat-label">Total Rejected</div>
            </div>

            <div class="stat-card">
                <div class="stat-card-header">
                    <div class="stat-icon info">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                        </svg>
                    </div>
                    <div class="stat-value"><?php echo e($stats['today_approved']); ?></div>
                </div>
                <div class="stat-label">Approved Today</div>
            </div>
        </div>

        <!-- Filters -->
        <div class="filters-section">
            <h3 style="margin-bottom: 10px;">Filter Approvals</h3>
            <form method="GET" action="<?php echo e(route('admin.dashboard')); ?>">
                <div class="filters-grid">
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
                    </div>

                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label">End Date</label>
                        <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
                    </div>

                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label">Company</label>
                        <select name="company" class="form-control">
                            <option value="">All Companies</option>
                            <option value="TBI" <?php echo e(request('company') == 'TBI' ? 'selected' : ''); ?>>TBI</option>
                            <option value="CI" <?php echo e(request('company') == 'CI' ? 'selected' : ''); ?>>CI</option>
                        </select>
                    </div>

                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="form-label">Category</label>
                        <select name="category" class="form-control">
                            <option value="">All Categories</option>
                            <option value="HIRBND" <?php echo e(request('category') == 'HIRBND' ? 'selected' : ''); ?>>HIRBND</option>
                            <option value="HO" <?php echo e(request('category') == 'HO' ? 'selected' : ''); ?>>HO</option>
                            <option value="CI" <?php echo e(request('category') == 'CI' ? 'selected' : ''); ?>>CI</option>
                            <option value="HIRBC" <?php echo e(request('category') == 'HIRBC' ? 'selected' : ''); ?>>HIRBC</option>
                            <option value="RBC" <?php echo e(request('category') == 'RBC' ? 'selected' : ''); ?>>RBC</option>
                            <option value="LDR" <?php echo e(request('category') == 'LDR' ? 'selected' : ''); ?>>LDR</option>
                        </select>
                    </div>
                </div>

                <div style="display: flex; gap: 10px; margin-top: 20px;">
                    <button type="submit" class="btn btn-primary">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 5px;">
                            <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z" fill="currentColor"/>
                        </svg>
                        Apply Filters
                    </button>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">Clear Filters</a>
                    <a href="<?php echo e(route('admin.approvals.export')); ?>" class="btn btn-success">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 5px;">
                            <path d="M19 12v7H5v-7H3v7c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-7h-2zm-6 .67l2.59-2.58L17 11.5l-5 5-5-5 1.41-1.41L11 12.67V3h2z" fill="currentColor"/>
                        </svg>
                        Export CSV
                    </a>
                </div>
            </form>
        </div>

        <!-- Approvals Table -->
        <div class="approvals-table">
            <div class="table-header">
                <h3>Approved Purchase Orders (<?php echo e($approvals->total()); ?>)</h3>
            </div>

            <?php if($approvals->count() > 0): ?>
                <table class="approval-table">
                    <thead>
                        <tr>
                            <th>Date & Time</th>
                            <th>Document No</th>
                            <th>Company</th>
                            <th>Category</th>
                            <th>Approver ID</th>
                            <th>Approver Email</th>
                            <th>Remarks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($approval->action_date->format('d M Y H:i')); ?></td>
                            <td><strong><?php echo e($approval->document_no); ?></strong></td>
                            <td>
                                <span class="company-badge <?php echo e(strtolower($approval->company)); ?>">
                                    <?php echo e($approval->company); ?>

                                </span>
                            </td>
                            <td><?php echo e($approval->category); ?></td>
                            <td><strong><?php echo e($approval->approver_id); ?></strong></td>
                            <td><?php echo e($approval->approver_email); ?></td>
                            <td><?php echo e($approval->remarks ?: '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="pagination">
                    <?php echo e($approvals->links()); ?>

                </div>
            <?php else: ?>
                <div class="no-data">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M19 3h-4.18C14.4 1.84 13.3 1 12 1c-1.3 0-2.4.84-2.82 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z"/>
                    </svg>
                    <h3>No Approvals Found</h3>
                    <p>No approved purchase orders match your current filters.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
</body>
</html><?php /**PATH /home/pawc5944/public_html/po-approval-system/laravel/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>