<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Dashboard - PO Approval System'); ?></title>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/dashboard.css')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="dashboard-wrapper">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="logo">
                    <svg width="40" height="40" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M20 6h-2.18c.11-.31.18-.65.18-1a2.996 2.996 0 0 0-5.5-1.65l-.5.67-.5-.68C10.96 2.54 10.05 2 9 2 7.34 2 6 3.34 6 5c0 .35.07.69.18 1H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-5-2c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM9 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm11 15H4v-2h16v2zm0-5H4V8h5.08L7 10.83 8.62 12 11 8.76l1-1.36 1 1.36L15.38 12 17 10.83 14.92 8H20v6z" fill="currentColor"/>
                    </svg>
                    <div class="logo-text-container">
                        <span class="logo-text">Release PO</span>
                        <span class="logo-subtext">BALI</span>
                    </div>
                </div>
            </div>

            <div class="sidebar-user">
                <div class="user-avatar">
                    <?php echo e(strtoupper(substr(Auth::user()->name ?? Auth::user()->approver_id, 0, 2))); ?>

                </div>
                <div class="user-info">
                    <div class="user-name"><?php echo e(Auth::user()->name ?? Auth::user()->approver_id); ?></div>
                    <div class="user-email"><?php echo e(Auth::user()->email); ?></div>
                </div>
            </div>

            <nav class="sidebar-nav">
                <a href="<?php echo e(route('dashboard')); ?>" class="nav-item <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z" fill="currentColor"/>
                    </svg>
                    <span>Dashboard</span>
                </a>

                <!-- TBI Menu - REMOVE "open" CLASS -->
<div class="nav-group">
    <div class="nav-group-header">
        <img src="<?php echo e(asset('images/tbi.jpg')); ?>" alt="TBI" class="company-icon" onerror="this.style.display='none'">
        <span>Tanjung Benoa Indonesia</span>
        <svg class="nav-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z" fill="currentColor"/>
        </svg>
    </div>
    <div class="nav-group-items">
        <a href="<?php echo e(route('tbi.hirbnd')); ?>" class="nav-item <?php echo e(request()->routeIs('tbi.hirbnd') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/hin.jpg')); ?>" alt="HIRBND" class="category-icon" onerror="this.style.display='none'">
            <span>HIRBND</span>
            <span class="badge"><?php echo e($stats['tbi_hirbnd'] ?? 0); ?></span>
        </a>
        <a href="<?php echo e(route('tbi.ho')); ?>" class="nav-item <?php echo e(request()->routeIs('tbi.ho') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/ho.jpg')); ?>" alt="HO" class="category-icon" onerror="this.style.display='none'">
            <span>HO</span>
            <span class="badge"><?php echo e($stats['tbi_ho'] ?? 0); ?></span>
        </a>
    </div>
</div>

<!-- CI Menu - REMOVE "open" CLASS -->
<div class="nav-group">
    <div class="nav-group-header">
        <img src="<?php echo e(asset('images/ci.jpg')); ?>" alt="CI" class="company-icon" onerror="this.style.display='none'">
        <span>Canggu International</span>
        <svg class="nav-arrow" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z" fill="currentColor"/>
        </svg>
    </div>
    <div class="nav-group-items">
        <a href="<?php echo e(route('ci.ci')); ?>" class="nav-item <?php echo e(request()->routeIs('ci.ci') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/cic.jpg')); ?>" alt="CI" class="category-icon" onerror="this.style.display='none'">
            <span>CI</span>
            <span class="badge"><?php echo e($stats['ci_ci'] ?? 0); ?></span>
        </a>
        <a href="<?php echo e(route('ci.ci_supplies')); ?>" class="nav-item <?php echo e(request()->routeIs('ci.ci_supplies') ? 'active' : ''); ?>">
            <span>CI Supplies</span>
            <span class="badge badge-warning">No API</span>
        </a>
        <a href="<?php echo e(route('ci.hirbc')); ?>" class="nav-item <?php echo e(request()->routeIs('ci.hirbc') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/hic.jpg')); ?>" alt="HIRBC" class="category-icon" onerror="this.style.display='none'">
            <span>HIRBC</span>
            <span class="badge"><?php echo e($stats['ci_hirbc'] ?? 0); ?></span>
        </a>
        <a href="<?php echo e(route('ci.rbc')); ?>" class="nav-item <?php echo e(request()->routeIs('ci.rbc') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/rbc.jpg')); ?>" alt="RBC" class="category-icon" onerror="this.style.display='none'">
            <span>RBC</span>
            <span class="badge"><?php echo e($stats['ci_rbc'] ?? 0); ?></span>
        </a>
        <a href="<?php echo e(route('ci.ldr')); ?>" class="nav-item <?php echo e(request()->routeIs('ci.ldr') ? 'active' : ''); ?>">
            <img src="<?php echo e(asset('images/ldr.jpg')); ?>" alt="LDR" class="category-icon" onerror="this.style.display='none'">
            <span>LDR</span>
            <span class="badge"><?php echo e($stats['ci_ldr'] ?? 0); ?></span>
        </a>
    </div>
</div>

                <div class="nav-divider"></div>

                <!-- <a href="<?php echo e(route('history')); ?>" class="nav-item <?php echo e(request()->routeIs('history') ? 'active' : ''); ?>">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z" fill="currentColor"/>
                    </svg>
                    <span>History</span>
                </a> -->
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content" id="mainContent">
            <!-- Header -->
            <header class="content-header">
                <button class="hamburger" id="hamburger">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                <h1 class="page-title"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h1>
                <div class="header-actions">
                    <span class="sync-status" id="syncStatus">
                        <svg width="12" height="12" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="10" fill="#ffc107"/>
                        </svg>
                        Sync Paused
                    </span>
                    <div class="user-dropdown-wrapper">
                        <button class="user-dropdown-toggle" id="userDropdownToggle">
                            <span class="user-name-header"><?php echo e(strtoupper(Auth::user()->name ?? Auth::user()->approver_id)); ?></span>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z" fill="currentColor"/>
                            </svg>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" fill="currentColor"/>
                                    </svg>
                                    Logout
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Content -->
            <div class="content-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dashboard.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\po-approval\resources\views/layouts/dashboard.blade.php ENDPATH**/ ?>