<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    // 'talenta' => [
    //     'base_url'      => env('MEKARI_TALENTA_BASE_URL'),
    //     'hmac_username' => env('MEKARI_TALENTA_HMAC_USERNAME'),
    //     'hmac_secret'   => env('MEKARI_TALENTA_HMAC_SECRET'),
    //     'scan_pages'    => env('MEKARI_TALENTA_SCAN_PAGES'),
    //     'scan_chunk'    => env('MEKARI_TALENTA_SCAN_CHUNK'),
    // ],

    'talenta' => [
        'base_url'      => env('MEKARI_TALENTA_BASE_URL', 'https://api.mekari.com'),
        'hmac_username' => env('MEKARI_TALENTA_HMAC_USERNAME'),
        'hmac_secret'   => env('MEKARI_TALENTA_HMAC_SECRET'),
        'scan' => [
            'max_pages'      => (int) env('MEKARI_TALENTA_SCAN_PAGES', 500),
            'pages_per_wave' => (int) env('MEKARI_TALENTA_PAGES_PER_WAVE', 12),
        ],
    ],

    // 'talenta_sandbox' => [
    //     'base_url'      => env('MEKARI_TALENTA_SANDBOX_BASE_URL', 'https://sandbox-api.mekari.com'),
    //     'hmac_username' => env('MEKARI_TALENTA_SANDBOX_HMAC_USERNAME'),
    //     'hmac_secret'   => env('MEKARI_TALENTA_SANDBOX_HMAC_SECRET'),
    // ],
    'mekari_talenta_sandbox' => [
        'base_url'  => env('MEKARI_TALENTA_SANDBOX_BASE_URL', 'https://sandbox-api.mekari.com'),
        'username'  => env('MEKARI_TALENTA_SANDBOX_HMAC_USERNAME'),
        'secret'    => env('MEKARI_TALENTA_SANDBOX_HMAC_SECRET'),
        'actor_user_id' => env('MEKARI_TALENTA_SANDBOX_ACTOR_USER_ID', 0),
    ],

];
