<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();

            // Relasi via model saja (tidak pakai FK di DB)
            $table->unsignedBigInteger('candidate_id')->unique();
            $table->unsignedBigInteger('position_id')->nullable();
            
            $table->string('employee_id')->nullable()->unique(); // ID Karyawan (jika ada)
            $table->string('barcode')->nullable()->unique(); // Untuk absensi

            // Identitas internal
            $table->string('employee_code')->nullable()->unique();
            $table->string('full_name');

            // Penempatan & organisasi (snapshot teks)
            $table->string('company_name')->default('PT. Kayu Mebel Indonesia');
            $table->string('branch')->nullable();         // "PT. Kayu Mebel Indonesia - Sidoarjo"
            $table->string('department')->nullable();     // "Produksi"
            $table->string('position_name')->nullable();  // snapshot posisi
            $table->string('job_level')->nullable();      // "MT", "Staff", "Supervisor", dll

            // Status hubungan kerja & periode
            $table->enum('employment_type', ['full-time', 'part-time', 'contract', 'internship'])->default('full-time');
            $table->enum('contract_type', ['PKWT','PKWTT','Magang','Kontrak','Tetap'])->default('PKWT');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->boolean('is_active')->default(true);

            // Kompensasi & payroll
            // $table->decimal('base_salary', 12, 2)->nullable();
            // $table->string('salary_currency', 8)->default('IDR');
            // $table->decimal('allowance', 12, 2)->nullable();
            // $table->decimal('meal_transport', 12, 2)->nullable();
            // $table->decimal('other_benefits', 12, 2)->nullable();

            // Pajak & kepesertaan
            // $table->string('npwp')->nullable();
            // $table->string('bpjs_ketenagakerjaan')->nullable();
            // $table->string('bpjs_kesehatan')->nullable();
            $table->enum('tax_status', ['TK/0','TK/1','TK/2','TK/3','K/0','K/1','K/2','K/3'])->nullable();

            // Bank
            // $table->string('bank_name')->nullable();
            // $table->string('bank_account_no')->nullable();
            // $table->string('bank_account_holder')->nullable();

            // Operasional
            $table->string('supervisor_name')->nullable();
            $table->string('work_schedule')->nullable();       // "Shift A" / "Non Shift"
            $table->string('work_location_detail')->nullable();// blok/line/gedung

            $table->timestamps();
            $table->softDeletes();

            // Index untuk filter umum
            $table->index(['is_active', 'employment_type']);
            $table->index('department');
            $table->index('branch');
            $table->index('position_name');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
