/* ===== app-layout.js =====
   Global: sidebar mobile/desktop + overlay + persistence
*/
(function(){
  const sidebar   = document.getElementById('sidebar');
  const overlay   = document.getElementById('sidebar-overlay');
  const btnMobile = document.getElementById('mobile-menu-button');
  const btnDesk   = document.getElementById('desktop-sidebar-toggle');
  const LS_KEY    = 'sidebarCollapsedV1';

  if (!sidebar) return;

  // ===== Mobile: off-canvas =====
  const openMobile  = () => {
    sidebar.classList.remove('-translate-x-full');
    overlay?.classList.remove('hidden');
    document.body.classList.add('no-scroll');
  };
  const closeMobile = () => {
    sidebar.classList.add('-translate-x-full');
    overlay?.classList.add('hidden');
    document.body.classList.remove('no-scroll');
  };

  btnMobile?.addEventListener('click', () => {
    if (sidebar.classList.contains('-translate-x-full')) openMobile(); else closeMobile();
  });
  overlay?.addEventListener('click', closeMobile);
  window.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && overlay && !overlay.classList.contains('hidden')) closeMobile();
  });

  // Auto-close ketika klik link di sidebar (khusus mobile)
  document.querySelectorAll('#sidebar a').forEach(a => {
    a.addEventListener('click', () => { if (window.innerWidth < 1024) closeMobile(); });
  });

  // ===== Desktop: collapse width with persistence =====
  const applyCollapsed = (collapsed) => collapsed ? sidebar.classList.add('collapsed') : sidebar.classList.remove('collapsed');
  applyCollapsed(localStorage.getItem(LS_KEY) === 'true');

  btnDesk?.addEventListener('click', () => {
    const collapsed = sidebar.classList.toggle('collapsed');
    localStorage.setItem(LS_KEY, collapsed ? 'true' : 'false');
  });

  // Ensure sidebar visible saat kembali ke desktop
  const onResize = () => {
    if (window.innerWidth >= 1024) {
      overlay?.classList.add('hidden');
      document.body.classList.remove('no-scroll');
      sidebar.classList.remove('-translate-x-full');
    }
  };
  window.addEventListener('resize', onResize);
  onResize();
})();
