{{-- resources/views/candidates/edit.blade.php --}}
@extends('layouts.app')

@section('title', isset($candidate) ? 'Edit Lamaran Kerja' : 'Form Lamaran Kerja')
@section('page-title', isset($candidate) ? 'Edit Lamaran Kerja' : 'Form Lamaran Kerja')

@push('styles')
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
  <style>
    .form-section{background:#fff;border-radius:12px;padding:24px;margin-bottom:24px;box-shadow:0 4px 6px -1px rgba(0,0,0,.1);transition:all .3s}
    .form-section:hover{box-shadow:0 10px 15px -3px rgba(0,0,0,.1)}
    .section-title{color:#1f2937;font-size:20px;font-weight:600;margin-bottom:16px;padding-bottom:8px;border-bottom:2px solid #e5e7eb}
    .form-group{margin-bottom:16px}
    .form-label{display:block;font-weight:500;color:#374151;margin-bottom:4px}
    .form-input{width:100%;padding:8px 12px;border:1px solid #d1d5db;border-radius:6px;font-size:14px;transition:all .2s}
    .form-input:focus{outline:none;border-color:#3b82f6;box-shadow:0 0 0 3px rgba(59,130,246,.1)}
    .btn-primary{background:#3b82f6;color:#fff;padding:12px 24px;border:0;border-radius:6px;font-weight:500;cursor:pointer;transition:.2s}
    .btn-primary:hover{background:#2563eb;transform:translateY(-1px);box-shadow:0 4px 6px -1px rgba(0,0,0,.1)}
    .btn-secondary{background:#6b7280;color:#fff;padding:8px 16px;border:0;border-radius:6px;font-size:14px;cursor:pointer;transition:.2s}
    .btn-add{background:#10b981;color:#fff;padding:6px 12px;border:0;border-radius:4px;font-size:12px;cursor:pointer;transition:.2s}
    .btn-add:hover{background:#059669}
    .btn-remove{background:#ef4444;color:#fff;padding:6px 12px;border:0;border-radius:4px;font-size:12px;cursor:pointer;transition:.2s}
    .btn-remove:hover{background:#dc2626}
    .dynamic-group{border:1px solid #e5e7eb;border-radius:8px;padding:16px;margin-bottom:12px;background:#f9fafb;position:relative}
    .checkbox-group{display:flex;flex-wrap:wrap;gap:12px}
    .checkbox-item{display:flex;align-items:center;gap:6px}
    .required-star{color:#ef4444;font-weight:700}
    .company-logo{max-height:80px;margin:0 auto}
    .file-list{margin-top:8px;font-size:12px;color:#6b7280}
    .file-item{display:flex;align-items:center;gap:8px;margin-top:4px}
    .preview-img{max-height:120px;border-radius:8px;border:1px solid #e5e7eb}
  </style>
@endpush

@section('content')
  <div class="max-w-4xl mx-auto py-4">
    {{-- Header w/ Logo --}}
    <div class="text-center mb-8">
      <x-company-logo class="company-logo mb-4" />
      <h1 class="text-3xl font-bold text-gray-900 mb-2">
        {{ isset($candidate) ? 'Edit Lamaran Kerja' : 'Form Lamaran Kerja' }}
      </h1>
      <p class="text-lg text-gray-600">PT Kayu Mebel Indonesia</p>
      <p class="text-sm text-gray-500 mt-2">Silakan lengkapi semua data dengan benar</p>
    </div>

    {{-- Errors --}}
    @if ($errors->any())
      <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
        <h3 class="text-red-800 font-medium mb-2">Terdapat kesalahan pada form:</h3>
        <ul class="text-red-700 text-sm list-disc list-inside">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    @php
      // Normalisasi old()/DB untuk array kompleks
      $familyMembers        = old('family_members',        $candidate->family_members        ?? [['relationship'=>'','name'=>'','age'=>'','education'=>'','occupation'=>'']]);
      $formalEducation      = old('formal_education',      $candidate->formal_education      ?? [['education_level'=>'','institution_name'=>'','major'=>'','start_year'=>'','end_year'=>'','gpa'=>'']]);
      $nonFormalEducation   = old('non_formal_education',  $candidate->non_formal_education  ?? [['course_name'=>'','organizer'=>'','date'=>'','description'=>'']]);
      $workExperiences      = old('work_experiences',      $candidate->work_experiences      ?? [['company_name'=>'','company_address'=>'','company_field'=>'','position'=>'','start_year'=>'','end_year'=>'','salary'=>'','reason_for_leaving'=>'','supervisor_contact'=>'']]);
      $languageSkills       = old('language_skills',       $candidate->language_skills       ?? [['language'=>'','speaking_level'=>'','writing_level'=>'']]);
      $socialActivities     = old('social_activities',     $candidate->social_activities     ?? [['organization_name'=>'','field'=>'','period'=>'','description'=>'']]);
      $achievements         = old('achievements',          $candidate->achievements          ?? [['achievement'=>'','year'=>'','description'=>'']]);
      // SIM (checkbox array)
      $drivingLicensesOld   = old('driving_licenses',      $candidate->driving_licenses      ?? []);
      $drivingLicenses      = is_array($drivingLicensesOld) ? $drivingLicensesOld : (empty($drivingLicensesOld) ? [] : explode(',', $drivingLicensesOld));
      // Dokumen
      $cvPath         = $candidate->cv_path         ?? null;
      $photoPath      = $candidate->photo_path      ?? null;
      $transcriptPath = $candidate->transcript_path ?? null;
      $certificates   = $candidate->certificates    ?? []; // array path
      if (!is_array($certificates)) { $certificates = $certificates ? (array)$certificates : []; }
    @endphp

    <form method="POST"
          action="{{ isset($candidate) ? route('candidates.update', $candidate->id) : route('candidates.store') }}"
          enctype="multipart/form-data"
          id="applicationForm">
      @csrf
      @if(isset($candidate))
        @method('PUT')
      @endif

      {{-- 1. Informasi Posisi --}}
      <div class="form-section" data-section="1">
        <h2 class="section-title">Informasi Posisi yang Dilamar</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label" for="position_applied">Posisi yang Dilamar <span class="required-star">*</span></label>
            <select name="position_applied" id="position_applied" class="form-input" required>
              <option value="">Pilih Posisi</option>
              @foreach($positions as $position)
                <option value="{{ $position->position_name }}"
                  {{ old('position_applied', $candidate->position_applied ?? '') == $position->position_name ? 'selected' : '' }}>
                  {{ $position->position_name }} - {{ $position->department }}
                </option>
              @endforeach
            </select>
          </div>
          <div class="form-group">
            <label class="form-label" for="expected_salary">Gaji yang Diharapkan (Rp)</label>
            <input type="number" name="expected_salary" id="expected_salary" class="form-input"
                   value="{{ old('expected_salary', $candidate->expected_salary ?? '') }}" placeholder="contoh: 5000000">
          </div>
        </div>
      </div>

      {{-- 2. Data Pribadi --}}
      <div class="form-section" data-section="2">
        <h2 class="section-title">Data Pribadi</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label" for="full_name">Nama Lengkap <span class="required-star">*</span></label>
            <input type="text" name="full_name" id="full_name" class="form-input"
                   value="{{ old('full_name', $candidate->full_name ?? '') }}" required>
          </div>
          <div class="form-group">
            <label class="form-label" for="email">Email <span class="required-star">*</span></label>
            <input type="email" name="email" id="email" class="form-input"
                   value="{{ old('email', $candidate->email ?? '') }}" required>
          </div>
          <div class="form-group">
            <label class="form-label" for="phone_number">Nomor Telepon</label>
            <input type="text" name="phone_number" id="phone_number" class="form-input"
                   value="{{ old('phone_number', $candidate->phone_number ?? '') }}" placeholder="08xxxxxxxxxx">
          </div>
          <div class="form-group">
            <label class="form-label" for="phone_alternative">Telepon Alternatif</label>
            <input type="text" name="phone_alternative" id="phone_alternative" class="form-input"
                   value="{{ old('phone_alternative', $candidate->phone_alternative ?? '') }}">
          </div>
          <div class="form-group">
            <label class="form-label" for="birth_place">Tempat Lahir</label>
            <input type="text" name="birth_place" id="birth_place" class="form-input"
                   value="{{ old('birth_place', $candidate->birth_place ?? '') }}">
          </div>
          <div class="form-group">
            <label class="form-label" for="birth_date">Tanggal Lahir</label>
            <input type="date" name="birth_date" id="birth_date" class="form-input"
                   value="{{ old('birth_date', optional($candidate->birth_date ?? null)->format('Y-m-d')) }}">
          </div>
          <div class="form-group">
            <label class="form-label" for="gender">Jenis Kelamin</label>
            <select name="gender" id="gender" class="form-input">
              <option value="">Pilih Jenis Kelamin</option>
              @foreach(['Laki-laki','Perempuan'] as $g)
                <option value="{{ $g }}" {{ old('gender', $candidate->gender ?? '') == $g ? 'selected' : '' }}>{{ $g }}</option>
              @endforeach
            </select>
          </div>
          <div class="form-group">
            <label class="form-label" for="religion">Agama</label>
            <input type="text" name="religion" id="religion" class="form-input"
                   value="{{ old('religion', $candidate->religion ?? '') }}">
          </div>
          <div class="form-group">
            <label class="form-label" for="marital_status">Status Pernikahan</label>
            <select name="marital_status" id="marital_status" class="form-input">
              <option value="">Pilih Status</option>
              @foreach(['Lajang','Menikah','Janda','Duda'] as $s)
                <option value="{{ $s }}" {{ old('marital_status', $candidate->marital_status ?? '') == $s ? 'selected' : '' }}>{{ $s }}</option>
              @endforeach
            </select>
          </div>
          <div class="form-group">
            <label class="form-label" for="ethnicity">Suku Bangsa</label>
            <input type="text" name="ethnicity" id="ethnicity" class="form-input"
                   value="{{ old('ethnicity', $candidate->ethnicity ?? '') }}">
          </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
          <div class="form-group">
            <label class="form-label" for="current_address">Alamat Tempat Tinggal Saat Ini</label>
            <textarea name="current_address" id="current_address" class="form-input" rows="3">{{ old('current_address', $candidate->current_address ?? '') }}</textarea>
            <div class="mt-2">
              <label class="form-label" for="current_address_status">Status Tempat Tinggal</label>
              <select name="current_address_status" id="current_address_status" class="form-input">
                <option value="">Pilih Status</option>
                @foreach(['Milik Sendiri','Orang Tua','Kontrak','Sewa'] as $st)
                  <option value="{{ $st }}" {{ old('current_address_status', $candidate->current_address_status ?? '') == $st ? 'selected' : '' }}>{{ $st }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="form-group">
            <label class="form-label" for="ktp_address">Alamat Sesuai KTP</label>
            <textarea name="ktp_address" id="ktp_address" class="form-input" rows="3">{{ old('ktp_address', $candidate->ktp_address ?? '') }}</textarea>
          </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
          <div class="form-group">
            <label class="form-label" for="height_cm">Tinggi Badan (cm)</label>
            <input type="number" name="height_cm" id="height_cm" class="form-input"
                   value="{{ old('height_cm', $candidate->height_cm ?? '') }}" min="100" max="250">
          </div>
          <div class="form-group">
            <label class="form-label" for="weight_kg">Berat Badan (kg)</label>
            <input type="number" name="weight_kg" id="weight_kg" class="form-input"
                   value="{{ old('weight_kg', $candidate->weight_kg ?? '') }}" min="30" max="200">
          </div>
          <div class="form-group">
            <label class="form-label" for="vaccination_status">Status Vaksinasi</label>
            <select name="vaccination_status" id="vaccination_status" class="form-input">
              <option value="">Pilih Status</option>
              @foreach(['Vaksin 1','Vaksin 2','Vaksin 3','Booster'] as $vx)
                <option value="{{ $vx }}" {{ old('vaccination_status', $candidate->vaccination_status ?? '') == $vx ? 'selected' : '' }}>{{ $vx }}</option>
              @endforeach
            </select>
          </div>
        </div>
      </div>

      {{-- 3. Data Keluarga --}}
      <div class="form-section" data-section="3">
        <h2 class="section-title">Data Keluarga</h2>
        <div id="familyMembers">
          @foreach($familyMembers as $i => $fm)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="form-group">
                  <label class="form-label">Hubungan Keluarga</label>
                  <select name="family_members[{{ $i }}][relationship]" class="form-input">
                    <option value="">Pilih Hubungan</option>
                    @foreach(['Pasangan','Anak','Ayah','Ibu','Saudara'] as $rel)
                      <option value="{{ $rel }}" {{ old("family_members.$i.relationship", $fm['relationship'] ?? '') == $rel ? 'selected' : '' }}>{{ $rel }}</option>
                    @endforeach
                  </select>
                </div>
                <div class="form-group">
                  <label class="form-label">Nama</label>
                  <input type="text" name="family_members[{{ $i }}][name]" class="form-input"
                         value="{{ old("family_members.$i.name", $fm['name'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Usia</label>
                  <input type="number" name="family_members[{{ $i }}][age]" class="form-input" min="0" max="120"
                         value="{{ old("family_members.$i.age", $fm['age'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Pendidikan</label>
                  <input type="text" name="family_members[{{ $i }}][education]" class="form-input"
                         value="{{ old("family_members.$i.education", $fm['education'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Pekerjaan</label>
                  <input type="text" name="family_members[{{ $i }}][occupation]" class="form-input"
                         value="{{ old("family_members.$i.occupation", $fm['occupation'] ?? '') }}">
                </div>
                <div class="form-group flex items-end">
                  <button type="button" class="btn-remove" onclick="removeFamilyMember(this)">Hapus</button>
                </div>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addFamilyMember()">+ Tambah Anggota Keluarga</button>
      </div>

      {{-- 4. Pendidikan --}}
      <div class="form-section" data-section="4">
        <h2 class="section-title">Latar Belakang Pendidikan</h2>

        <h3 class="text-lg font-medium mb-4">Pendidikan Formal</h3>
        <div id="formalEducation">
          @foreach($formalEducation as $i => $ed)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="form-group">
                  <label class="form-label">Jenjang Pendidikan</label>
                  <select name="formal_education[{{ $i }}][education_level]" class="form-input">
                    <option value="">Pilih Jenjang</option>
                    @foreach(['SMA/SMK','Diploma','S1','S2','S3'] as $lvl)
                      <option value="{{ $lvl }}" {{ old("formal_education.$i.education_level", $ed['education_level'] ?? '') == $lvl ? 'selected' : '' }}>{{ $lvl }}</option>
                    @endforeach
                  </select>
                </div>
                <div class="form-group">
                  <label class="form-label">Nama Institusi</label>
                  <input type="text" name="formal_education[{{ $i }}][institution_name]" class="form-input"
                         value="{{ old("formal_education.$i.institution_name", $ed['institution_name'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Jurusan</label>
                  <input type="text" name="formal_education[{{ $i }}][major]" class="form-input"
                         value="{{ old("formal_education.$i.major", $ed['major'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tahun Mulai</label>
                  <input type="number" name="formal_education[{{ $i }}][start_year]" class="form-input" min="1950" max="2030"
                         value="{{ old("formal_education.$i.start_year", $ed['start_year'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tahun Selesai</label>
                  <input type="number" name="formal_education[{{ $i }}][end_year]" class="form-input" min="1950" max="2030"
                         value="{{ old("formal_education.$i.end_year", $ed['end_year'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">IPK/Nilai</label>
                  <input type="number" step="0.01" name="formal_education[{{ $i }}][gpa]" class="form-input" min="0"
                         value="{{ old("formal_education.$i.gpa", $ed['gpa'] ?? '') }}">
                </div>
              </div>
              <div class="mt-4">
                <button type="button" class="btn-remove" onclick="removeEducation(this)">Hapus Pendidikan</button>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addEducation()">+ Tambah Pendidikan</button>

        <h3 class="text-lg font-medium mb-4 mt-8">Pendidikan Non Formal (Kursus, Pelatihan, Seminar, dll)</h3>
        <div id="nonFormalEducation">
          @foreach($nonFormalEducation as $i => $nf)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="form-group">
                  <label class="form-label">Nama Kursus/Pelatihan</label>
                  <input type="text" name="non_formal_education[{{ $i }}][course_name]" class="form-input"
                         value="{{ old("non_formal_education.$i.course_name", $nf['course_name'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Penyelenggara</label>
                  <input type="text" name="non_formal_education[{{ $i }}][organizer]" class="form-input"
                         value="{{ old("non_formal_education.$i.organizer", $nf['organizer'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tanggal</label>
                  <input type="date" name="non_formal_education[{{ $i }}][date]" class="form-input"
                         value="{{ old("non_formal_education.$i.date", $nf['date'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Keterangan</label>
                  <input type="text" name="non_formal_education[{{ $i }}][description]" class="form-input"
                         value="{{ old("non_formal_education.$i.description", $nf['description'] ?? '') }}">
                </div>
              </div>
              <div class="mt-4">
                <button type="button" class="btn-remove" onclick="removeNonFormalEducation(this)">Hapus</button>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addNonFormalEducation()">+ Tambah Pelatihan</button>
      </div>

      {{-- 5. Kemampuan & Skills --}}
      <div class="form-section" data-section="5">
        <h2 class="section-title">Kemampuan & Skills</h2>

        {{-- SIM --}}
        <div class="form-group">
          <label class="form-label">SIM yang Dimiliki</label>
          <div class="checkbox-group">
            @foreach(['A','B1','B2','C'] as $sim)
              <div class="checkbox-item">
                <input type="checkbox" name="driving_licenses[]" value="{{ $sim }}" id="sim_{{ strtolower($sim) }}"
                       {{ in_array($sim, $drivingLicenses, true) ? 'checked' : '' }}>
                <label for="sim_{{ strtolower($sim) }}">SIM {{ $sim }}</label>
              </div>
            @endforeach
          </div>
        </div>

        {{-- Bahasa --}}
        <div class="mt-6">
          <h3 class="text-lg font-medium mb-4">Kemampuan Bahasa</h3>
          <div id="languageSkills">
            @foreach($languageSkills as $i => $ls)
              <div class="dynamic-group" data-index="{{ $i }}">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                  <div class="form-group">
                    <label class="form-label">Bahasa</label>
                    <select name="language_skills[{{ $i }}][language]" class="form-input">
                      <option value="">Pilih Bahasa</option>
                      @foreach(['Bahasa Inggris','Bahasa Mandarin','Lainnya'] as $lang)
                        <option value="{{ $lang }}" {{ old("language_skills.$i.language", $ls['language'] ?? '') == $lang ? 'selected' : '' }}>
                          {{ $lang }}
                        </option>
                      @endforeach
                    </select>
                  </div>
                  <div class="form-group">
                    <label class="form-label">Kemampuan Berbicara</label>
                    <select name="language_skills[{{ $i }}][speaking_level]" class="form-input">
                      @foreach(['Pemula','Menengah','Mahir'] as $lvl)
                        <option value="{{ $lvl }}" {{ old("language_skills.$i.speaking_level", $ls['speaking_level'] ?? '') == $lvl ? 'selected' : '' }}>{{ $lvl }}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="form-group">
                    <label class="form-label">Kemampuan Menulis</label>
                    <select name="language_skills[{{ $i }}][writing_level]" class="form-input">
                      @foreach(['Pemula','Menengah','Mahir'] as $lvl)
                        <option value="{{ $lvl }}" {{ old("language_skills.$i.writing_level", $ls['writing_level'] ?? '') == $lvl ? 'selected' : '' }}>{{ $lvl }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="mt-4">
                  <button type="button" class="btn-remove" onclick="removeLanguageSkill(this)">Hapus Bahasa</button>
                </div>
              </div>
            @endforeach
          </div>
          <button type="button" class="btn-add" onclick="addLanguageSkill()">+ Tambah Kemampuan Bahasa</button>
        </div>

        {{-- Komputer --}}
        <div class="mt-6">
          <h3 class="text-lg font-medium mb-4">Kemampuan Komputer</h3>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="form-group">
              <label class="form-label" for="hardware_skills">Hardware (pisahkan dengan koma)</label>
              <textarea name="hardware_skills" id="hardware_skills" class="form-input" rows="2"
                        placeholder="contoh: Instalasi PC, Troubleshooting, Network">{{ old('hardware_skills', $candidate->hardware_skills ?? '') }}</textarea>
            </div>
            <div class="form-group">
              <label class="form-label" for="software_skills">Software (pisahkan dengan koma)</label>
              <textarea name="software_skills" id="software_skills" class="form-input" rows="2"
                        placeholder="contoh: MS Office, Adobe Photoshop, AutoCAD">{{ old('software_skills', $candidate->software_skills ?? '') }}</textarea>
            </div>
          </div>
        </div>

        {{-- Lainnya --}}
        <div class="mt-6">
          <h3 class="text-lg font-medium mb-4">Kemampuan Lainnya</h3>
          <div class="form-group">
            <label class="form-label" for="other_skills">Jelaskan kemampuan lain yang Anda miliki</label>
            <textarea name="other_skills" id="other_skills" class="form-input" rows="3"
                      placeholder="contoh: Public Speaking, Leadership, Project Management, dll">{{ old('other_skills', $candidate->other_skills ?? '') }}</textarea>
          </div>
        </div>
      </div>

      {{-- 6. Organisasi & Prestasi --}}
      <div class="form-section" data-section="6">
        <h2 class="section-title">Latar Belakang Organisasi & Prestasi</h2>

        <h3 class="text-lg font-medium mb-4">Aktivitas Sosial/Organisasi</h3>
        <div id="socialActivities">
          @foreach($socialActivities as $i => $sa)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="form-group">
                  <label class="form-label">Nama Organisasi</label>
                  <input type="text" name="social_activities[{{ $i }}][organization_name]" class="form-input"
                         value="{{ old("social_activities.$i.organization_name", $sa['organization_name'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Bidang</label>
                  <input type="text" name="social_activities[{{ $i }}][field]" class="form-input"
                         value="{{ old("social_activities.$i.field", $sa['field'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Periode Kepesertaan</label>
                  <input type="text" name="social_activities[{{ $i }}][period]" class="form-input" placeholder="contoh: 2020-2022"
                         value="{{ old("social_activities.$i.period", $sa['period'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Keterangan</label>
                  <input type="text" name="social_activities[{{ $i }}][description]" class="form-input"
                         value="{{ old("social_activities.$i.description", $sa['description'] ?? '') }}">
                </div>
              </div>
              <div class="mt-4">
                <button type="button" class="btn-remove" onclick="removeSocialActivity(this)">Hapus</button>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addSocialActivity()">+ Tambah Aktivitas</button>

        <h3 class="text-lg font-medium mb-4 mt-8">Penghargaan/Prestasi</h3>
        <div id="achievements">
          @foreach($achievements as $i => $ac)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="form-group">
                  <label class="form-label">Prestasi</label>
                  <input type="text" name="achievements[{{ $i }}][achievement]" class="form-input"
                         value="{{ old("achievements.$i.achievement", $ac['achievement'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tahun</label>
                  <input type="number" name="achievements[{{ $i }}][year]" class="form-input" min="1950" max="2030"
                         value="{{ old("achievements.$i.year", $ac['year'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Keterangan</label>
                  <input type="text" name="achievements[{{ $i }}][description]" class="form-input"
                         value="{{ old("achievements.$i.description", $ac['description'] ?? '') }}">
                </div>
              </div>
              <div class="mt-4">
                <button type="button" class="btn-remove" onclick="removeAchievement(this)">Hapus</button>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addAchievement()">+ Tambah Prestasi</button>
      </div>

      {{-- 7. Pengalaman Kerja --}}
      <div class="form-section" data-section="7">
        <h2 class="section-title">Pengalaman Kerja</h2>
        <p class="text-sm text-gray-600 mb-4">Mohon isi dimulai dari pekerjaan terakhir</p>

        <div id="workExperiences">
          @foreach($workExperiences as $i => $we)
            <div class="dynamic-group" data-index="{{ $i }}">
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="form-group">
                  <label class="form-label">Nama Perusahaan</label>
                  <input type="text" name="work_experiences[{{ $i }}][company_name]" class="form-input"
                         value="{{ old("work_experiences.$i.company_name", $we['company_name'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Alamat Perusahaan</label>
                  <input type="text" name="work_experiences[{{ $i }}][company_address]" class="form-input"
                         value="{{ old("work_experiences.$i.company_address", $we['company_address'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Bergerak di Bidang</label>
                  <input type="text" name="work_experiences[{{ $i }}][company_field]" class="form-input"
                         value="{{ old("work_experiences.$i.company_field", $we['company_field'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Posisi/Jabatan</label>
                  <input type="text" name="work_experiences[{{ $i }}][position]" class="form-input"
                         value="{{ old("work_experiences.$i.position", $we['position'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tahun Mulai</label>
                  <input type="number" name="work_experiences[{{ $i }}][start_year]" class="form-input" min="1950" max="2030"
                         value="{{ old("work_experiences.$i.start_year", $we['start_year'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Tahun Selesai</label>
                  <input type="number" name="work_experiences[{{ $i }}][end_year]" class="form-input" min="1950" max="2030"
                         value="{{ old("work_experiences.$i.end_year", $we['end_year'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Gaji Terakhir</label>
                  <input type="number" name="work_experiences[{{ $i }}][salary]" class="form-input"
                         value="{{ old("work_experiences.$i.salary", $we['salary'] ?? '') }}">
                </div>
                <div class="form-group">
                  <label class="form-label">Alasan Berhenti</label>
                  <input type="text" name="work_experiences[{{ $i }}][reason_for_leaving]" class="form-input"
                         value="{{ old("work_experiences.$i.reason_for_leaving", $we['reason_for_leaving'] ?? '') }}">
                </div>
                <div class="form-group md:col-span-2">
                  <label class="form-label">Nama & No Telp Atasan Langsung</label>
                  <input type="text" name="work_experiences[{{ $i }}][supervisor_contact]" class="form-input"
                         value="{{ old("work_experiences.$i.supervisor_contact", $we['supervisor_contact'] ?? '') }}"
                         placeholder="contoh: Bpk. Ahmad - 081234567890">
                </div>
              </div>
              <div class="mt-4">
                <button type="button" class="btn-remove" onclick="removeWorkExperience(this)">Hapus Pengalaman</button>
              </div>
            </div>
          @endforeach
        </div>
        <button type="button" class="btn-add" onclick="addWorkExperience()">+ Tambah Pengalaman Kerja</button>
      </div>

      {{-- 8. Informasi Umum --}}
      <div class="form-section" data-section="8">
        <h2 class="section-title">Informasi Umum</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="willing_to_travel" value="1"
                     {{ old('willing_to_travel', $candidate->willing_to_travel ?? false) ? 'checked' : '' }}>
              Bersedia melakukan perjalanan dinas
            </label>
          </div>
          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="has_vehicle" value="1"
                     {{ old('has_vehicle', $candidate->has_vehicle ?? false) ? 'checked' : '' }}>
              Memiliki kendaraan pribadi
            </label>
          </div>
        </div>

        <div class="form-group">
          <label class="form-label" for="vehicle_types">Jenis Kendaraan (jika ada)</label>
          <input type="text" name="vehicle_types" id="vehicle_types" class="form-input"
                 value="{{ old('vehicle_types', $candidate->vehicle_types ?? '') }}" placeholder="contoh: Motor, Mobil">
        </div>

        <div class="form-group">
          <label class="form-label" for="motivation">Motivasi untuk bergabung dengan PT Kayu Mebel Indonesia</label>
          <textarea name="motivation" id="motivation" class="form-input" rows="3"
                    placeholder="Jelaskan motivasi Anda bergabung dengan perusahaan">{{ old('motivation', $candidate->motivation ?? '') }}</textarea>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label" for="strengths">Kelebihan Anda</label>
            <textarea name="strengths" id="strengths" class="form-input" rows="3"
                      placeholder="Sebutkan minimal 3 kelebihan Anda">{{ old('strengths', $candidate->strengths ?? '') }}</textarea>
          </div>
          <div class="form-group">
            <label class="form-label" for="weaknesses">Kekurangan Anda</label>
            <textarea name="weaknesses" id="weaknesses" class="form-input" rows="3"
                      placeholder="Sebutkan minimal 3 kekurangan Anda">{{ old('weaknesses', $candidate->weaknesses ?? '') }}</textarea>
          </div>
        </div>

        <div class="form-group">
          <label class="form-label" for="other_income">Sumber Penghasilan Lain (Apa dan Berapa)</label>
          <input type="text" name="other_income" id="other_income" class="form-input"
                 value="{{ old('other_income', $candidate->other_income ?? '') }}" placeholder="contoh: Freelance design - Rp 2.000.000/bulan">
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="has_police_record" value="1"
                     {{ old('has_police_record', $candidate->has_police_record ?? false) ? 'checked' : '' }}>
              Pernah terlibat dengan pihak Kepolisian (kriminal/perdata/pidana)
            </label>
            <input type="text" name="police_record_detail" class="form-input mt-2"
                   placeholder="Jika ya, jelaskan" value="{{ old('police_record_detail', $candidate->police_record_detail ?? '') }}">
          </div>

          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="has_serious_illness" value="1"
                     {{ old('has_serious_illness', $candidate->has_serious_illness ?? false) ? 'checked' : '' }}>
              Pernah mengalami sakit keras/kronis/kecelakaan berat/operasi
            </label>
            <input type="text" name="illness_detail" class="form-input mt-2"
                   placeholder="Jika ya, jelaskan" value="{{ old('illness_detail', $candidate->illness_detail ?? '') }}">
          </div>

          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="has_tattoo_piercing" value="1"
                     {{ old('has_tattoo_piercing', $candidate->has_tattoo_piercing ?? false) ? 'checked' : '' }}>
              Memiliki Tato/Tindik pada tubuh
            </label>
            <input type="text" name="tattoo_piercing_detail" class="form-input mt-2"
                   placeholder="Jika ya, jelaskan lokasi" value="{{ old('tattoo_piercing_detail', $candidate->tattoo_piercing_detail ?? '') }}">
          </div>

          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="has_other_business" value="1"
                     {{ old('has_other_business', $candidate->has_other_business ?? false) ? 'checked' : '' }}>
              Memiliki kepemilikan/keterikatan dengan perusahaan lain
            </label>
            <input type="text" name="other_business_detail" class="form-input mt-2"
                   placeholder="Jika ya, jelaskan" value="{{ old('other_business_detail', $candidate->other_business_detail ?? '') }}">
          </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label" for="absence_days">Berapa hari kerja yang hilang dalam 1 tahun? (Ijin Tidak Masuk)</label>
            <input type="number" name="absence_days" id="absence_days" class="form-input"
                   value="{{ old('absence_days', $candidate->absence_days ?? '') }}" min="0" max="365">
          </div>
          <div class="form-group">
            <label class="form-label" for="start_work_date">Jika diterima, kapan Anda dapat mulai bekerja?</label>
            <input type="date" name="start_work_date" id="start_work_date" class="form-input"
                   value="{{ old('start_work_date', optional($candidate->start_work_date ?? null)->format('Y-m-d')) }}">
          </div>
        </div>

        <div class="form-group">
          <label class="form-label" for="information_source">Sumber informasi lowongan kerja dari?</label>
          <input type="text" name="information_source" id="information_source" class="form-input"
                 value="{{ old('information_source', $candidate->information_source ?? '') }}"
                 placeholder="contoh: Website, Teman, Media Sosial, JobStreet">
        </div>
      </div>

      {{-- 9. Upload Dokumen & Pernyataan --}}
      <div class="form-section" data-section="9">
        <h2 class="section-title">Upload Dokumen & Pernyataan</h2>
        <p class="text-sm text-gray-600 mb-4">Format yang diterima: PDF, JPG, PNG (Maksimal 2MB per file)</p>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label" for="cv">CV/Resume</label>
            <input type="file" name="documents[cv]" id="cv" class="form-input" accept=".pdf,.jpg,.jpeg,.png">
            @if($cvPath)
              <div class="file-list">
                <div class="file-item">
                  <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                  </svg>
                  <a class="text-blue-600 underline" href="{{ Storage::url($cvPath) }}" target="_blank">Lihat CV saat ini</a>
                </div>
              </div>
            @endif
          </div>

          <div class="form-group">
            <label class="form-label" for="photo">Foto</label>
            <input type="file" name="documents[photo]" id="photo" class="form-input" accept=".jpg,.jpeg,.png">
            @if($photoPath)
              <div class="file-list">
                <div class="file-item">
                  <img src="{{ Storage::url($photoPath) }}" alt="Foto kandidat" class="preview-img">
                  <a class="text-blue-600 underline" href="{{ Storage::url($photoPath) }}" target="_blank">Buka Foto</a>
                </div>
              </div>
            @endif
          </div>

          <div class="form-group">
            <label class="form-label" for="certificates">Sertifikat (bisa lebih dari satu)</label>
            <input type="file" name="documents[certificates][]" id="certificates" class="form-input"
                   accept=".pdf,.jpg,.jpeg,.png" multiple>
            <div class="file-list" id="certificateList"></div>

            @if(!empty($certificates))
              <div class="file-list mt-2">
                <p class="text-sm text-gray-600">Sertifikat saat ini:</p>
                @foreach($certificates as $idx => $path)
                  <div class="file-item">
                    <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <a class="text-blue-600 underline" href="{{ Storage::url($path) }}" target="_blank">Sertifikat {{ $idx+1 }}</a>
                  </div>
                @endforeach
              </div>
            @endif
          </div>

          <div class="form-group">
            <label class="form-label" for="transcript">Transkrip Nilai</label>
            <input type="file" name="documents[transcript]" id="transcript" class="form-input" accept=".pdf,.jpg,.jpeg,.png">
            @if($transcriptPath)
              <div class="file-list">
                <div class="file-item">
                  <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                  </svg>
                  <a class="text-blue-600 underline" href="{{ Storage::url($transcriptPath) }}" target="_blank">Lihat Transkrip</a>
                </div>
              </div>
            @endif
          </div>
        </div>

        {{-- Pernyataan --}}
        <div class="mt-8 bg-blue-50 border border-blue-200 rounded-lg p-6">
          <h3 class="font-semibold text-lg mb-4">Pernyataan Pelamar</h3>
          <p class="text-gray-700 mb-4 italic">
            "Dengan ini saya menerangkan dan menyatakan bahwa saya memberikan wewenang kepada PT. Kayu Mebel Indonesia
            untuk menjaga informasi sehubungan dengan data pribadi dan menggunakannya untuk kepentingan proses seleksi.
            Semua data yang saya tuliskan diatas adalah benar, saya menyadari bahwa ketidakjujuran mengenai data-data
            di atas dapat mengakibatkan pembatalan atau pemutusan hubungan kerja dari pihak perusahaan."
          </p>
          <div class="form-group">
            <label class="form-label">
              <input type="checkbox" name="agreement" value="1" required
                     {{ old('agreement', isset($candidate) ? 1 : 0) ? 'checked' : '' }}>
              <span class="ml-2">Saya setuju dengan pernyataan di atas <span class="required-star">*</span></span>
            </label>
          </div>
        </div>
      </div>

      {{-- Submit --}}
      <div class="text-center mt-8">
        <button type="submit" class="btn-primary px-8 py-3 text-lg">
          {{ isset($candidate) ? 'Update' : 'Kirim Lamaran' }}
        </button>
        <p class="text-sm text-gray-500 mt-2">
          Pastikan semua data telah diisi dengan benar sebelum mengirim
        </p>
      </div>
    </form>
  </div>

  {{-- Save Indicator (opsional, dipakai oleh JS) --}}
  <div class="save-indicator" id="saveIndicator" style="display:none">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
    </svg>
    <span>Data tersimpan otomatis</span>
  </div>
@endsection

@push('scripts')
<script>
  // ==== Auto-save ringan (localStorage) ====
  const STORAGE_KEY = 'jobApplicationFormData';
  const form = document.getElementById('applicationForm');
  const saveIndicator = document.getElementById('saveIndicator');

  function debounce(fn, wait){ let t; return (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn(...a), wait); } }
  function showSave(){ if(!saveIndicator) return; saveIndicator.style.display='flex'; setTimeout(()=>saveIndicator.style.display='none', 1500); }

  function saveFormData(){
    const fd = new FormData(form);
    const data = {};
    for (let [k,v] of fd.entries()){
      if (!k.startsWith('documents[')) {
        if (data[k]) { if (!Array.isArray(data[k])) data[k] = [data[k]]; data[k].push(v); }
        else data[k] = v;
      }
    }
    // single checkboxes (boolean)
    form.querySelectorAll('input[type="checkbox"]').forEach(cb=>{
      if (!cb.name.endsWith('[]')) data[cb.name] = cb.checked ? '1' : '0';
    });
    localStorage.setItem(STORAGE_KEY, JSON.stringify(data));
    showSave();
  }
  const debouncedSave = debounce(saveFormData, 800);

  window.addEventListener('DOMContentLoaded', ()=>{
    // listeners
    form.querySelectorAll('input,select,textarea').forEach(el=>{
      el.addEventListener('change', saveFormData);
      el.addEventListener('input', debouncedSave);
    });

    // sertifikat input live list
    const certificateInput = document.getElementById('certificates');
    const fileList = document.getElementById('certificateList');
    certificateInput?.addEventListener('change', (e)=>{
      if(!fileList) return;
      fileList.innerHTML = '';
      if (e.target.files?.length) {
        fileList.innerHTML = '<p class="text-sm text-gray-600 mt-2">File yang dipilih:</p>';
        [...e.target.files].forEach(f=>{
          const d = document.createElement('div');
          d.className='file-item';
          d.innerHTML = `
            <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <span>${f.name}</span>`;
          fileList.appendChild(d);
        });
      }
    });
  });

  // ==== Dynamic groups (add/remove) ====
  let familyIndex = {{ count($familyMembers) - 1 }};
  let educationIndex = {{ count($formalEducation) - 1 }};
  let nonFormalEducationIndex = {{ count($nonFormalEducation) - 1 }};
  let workIndex = {{ count($workExperiences) - 1 }};
  let languageIndex = {{ count($languageSkills) - 1 }};
  let socialActivityIndex = {{ count($socialActivities) - 1 }};
  let achievementIndex = {{ count($achievements) - 1 }};

  function addFamilyMember(){
    familyIndex++;
    const c = document.getElementById('familyMembers');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${familyIndex}">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
          <div class="form-group">
            <label class="form-label">Hubungan Keluarga</label>
            <select name="family_members[${familyIndex}][relationship]" class="form-input">
              <option value="">Pilih Hubungan</option>
              <option value="Pasangan">Pasangan</option>
              <option value="Anak">Anak</option>
              <option value="Ayah">Ayah</option>
              <option value="Ibu">Ibu</option>
              <option value="Saudara">Saudara</option>
            </select>
          </div>
          <div class="form-group">
            <label class="form-label">Nama</label>
            <input type="text" name="family_members[${familyIndex}][name]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Usia</label>
            <input type="number" name="family_members[${familyIndex}][age]" class="form-input" min="0" max="120">
          </div>
          <div class="form-group">
            <label class="form-label">Pendidikan</label>
            <input type="text" name="family_members[${familyIndex}][education]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Pekerjaan</label>
            <input type="text" name="family_members[${familyIndex}][occupation]" class="form-input">
          </div>
          <div class="form-group flex items-end">
            <button type="button" class="btn-remove" onclick="removeFamilyMember(this)">Hapus</button>
          </div>
        </div>
      </div>
    `);
  }
  function removeFamilyMember(btn){ btn.closest('.dynamic-group').remove(); }

  function addEducation(){
    educationIndex++;
    const c = document.getElementById('formalEducation');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${educationIndex}">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
          <div class="form-group">
            <label class="form-label">Jenjang Pendidikan</label>
            <select name="formal_education[${educationIndex}][education_level]" class="form-input">
              <option value="">Pilih Jenjang</option>
              <option value="SMA/SMK">SMA/SMK</option>
              <option value="Diploma">Diploma</option>
              <option value="S1">S1</option>
              <option value="S2">S2</option>
              <option value="S3">S3</option>
            </select>
          </div>
          <div class="form-group">
            <label class="form-label">Nama Institusi</label>
            <input type="text" name="formal_education[${educationIndex}][institution_name]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Jurusan</label>
            <input type="text" name="formal_education[${educationIndex}][major]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Tahun Mulai</label>
            <input type="number" name="formal_education[${educationIndex}][start_year]" class="form-input" min="1950" max="2030">
          </div>
          <div class="form-group">
            <label class="form-label">Tahun Selesai</label>
            <input type="number" name="formal_education[${educationIndex}][end_year]" class="form-input" min="1950" max="2030">
          </div>
          <div class="form-group">
            <label class="form-label">IPK/Nilai</label>
            <input type="number" step="0.01" name="formal_education[${educationIndex}][gpa]" class="form-input" min="0">
          </div>
        </div>
        <div class="mt-4">
          <button type="button" class="btn-remove" onclick="removeEducation(this)">Hapus Pendidikan</button>
        </div>
      </div>
    `);
  }
  function removeEducation(btn){ btn.closest('.dynamic-group').remove(); }

  function addNonFormalEducation(){
    nonFormalEducationIndex++;
    const c = document.getElementById('nonFormalEducation');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${nonFormalEducationIndex}">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group">
            <label class="form-label">Nama Kursus/Pelatihan</label>
            <input type="text" name="non_formal_education[${nonFormalEducationIndex}][course_name]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Penyelenggara</label>
            <input type="text" name="non_formal_education[${nonFormalEducationIndex}][organizer]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Tanggal</label>
            <input type="date" name="non_formal_education[${nonFormalEducationIndex}][date]" class="form-input">
          </div>
          <div class="form-group">
            <label class="form-label">Keterangan</label>
            <input type="text" name="non_formal_education[${nonFormalEducationIndex}][description]" class="form-input">
          </div>
        </div>
        <div class="mt-4">
          <button type="button" class="btn-remove" onclick="removeNonFormalEducation(this)">Hapus</button>
        </div>
      </div>
    `);
  }
  function removeNonFormalEducation(btn){ btn.closest('.dynamic-group').remove(); }

  function addWorkExperience(){
    workIndex++;
    const c = document.getElementById('workExperiences');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${workIndex}">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group"><label class="form-label">Nama Perusahaan</label>
            <input type="text" name="work_experiences[${workIndex}][company_name]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Alamat Perusahaan</label>
            <input type="text" name="work_experiences[${workIndex}][company_address]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Bergerak di Bidang</label>
            <input type="text" name="work_experiences[${workIndex}][company_field]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Posisi/Jabatan</label>
            <input type="text" name="work_experiences[${workIndex}][position]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Tahun Mulai</label>
            <input type="number" name="work_experiences[${workIndex}][start_year]" class="form-input" min="1950" max="2030"></div>
          <div class="form-group"><label class="form-label">Tahun Selesai</label>
            <input type="number" name="work_experiences[${workIndex}][end_year]" class="form-input" min="1950" max="2030"></div>
          <div class="form-group"><label class="form-label">Gaji Terakhir</label>
            <input type="number" name="work_experiences[${workIndex}][salary]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Alasan Berhenti</label>
            <input type="text" name="work_experiences[${workIndex}][reason_for_leaving]" class="form-input"></div>
          <div class="form-group md:col-span-2"><label class="form-label">Nama & No Telp Atasan Langsung</label>
            <input type="text" name="work_experiences[${workIndex}][supervisor_contact]" class="form-input" placeholder="contoh: Bpk. Ahmad - 081234567890"></div>
        </div>
        <div class="mt-4"><button type="button" class="btn-remove" onclick="removeWorkExperience(this)">Hapus Pengalaman</button></div>
      </div>
    `);
  }
  function removeWorkExperience(btn){ btn.closest('.dynamic-group').remove(); }

  function addLanguageSkill(){
    languageIndex++;
    const c = document.getElementById('languageSkills');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${languageIndex}">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
          <div class="form-group"><label class="form-label">Bahasa</label>
            <select name="language_skills[${languageIndex}][language]" class="form-input">
              <option value="">Pilih Bahasa</option>
              <option value="Bahasa Inggris">Bahasa Inggris</option>
              <option value="Bahasa Mandarin">Bahasa Mandarin</option>
              <option value="Lainnya">Lainnya</option>
            </select>
          </div>
          <div class="form-group"><label class="form-label">Kemampuan Berbicara</label>
            <select name="language_skills[${languageIndex}][speaking_level]" class="form-input">
              <option value="">Pilih Level</option>
              <option value="Pemula">Pemula</option>
              <option value="Menengah">Menengah</option>
              <option value="Mahir">Mahir</option>
            </select>
          </div>
          <div class="form-group"><label class="form-label">Kemampuan Menulis</label>
            <select name="language_skills[${languageIndex}][writing_level]" class="form-input">
              <option value="">Pilih Level</option>
              <option value="Pemula">Pemula</option>
              <option value="Menengah">Menengah</option>
              <option value="Mahir">Mahir</option>
            </select>
          </div>
        </div>
        <div class="mt-4"><button type="button" class="btn-remove" onclick="removeLanguageSkill(this)">Hapus Bahasa</button></div>
      </div>
    `);
  }
  function removeLanguageSkill(btn){ btn.closest('.dynamic-group').remove(); }

  function addSocialActivity(){
    socialActivityIndex++;
    const c = document.getElementById('socialActivities');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${socialActivityIndex}">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="form-group"><label class="form-label">Nama Organisasi</label>
            <input type="text" name="social_activities[${socialActivityIndex}][organization_name]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Bidang</label>
            <input type="text" name="social_activities[${socialActivityIndex}][field]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Periode Kepesertaan</label>
            <input type="text" name="social_activities[${socialActivityIndex}][period]" class="form-input" placeholder="contoh: 2020-2022"></div>
          <div class="form-group"><label class="form-label">Keterangan</label>
            <input type="text" name="social_activities[${socialActivityIndex}][description]" class="form-input"></div>
        </div>
        <div class="mt-4"><button type="button" class="btn-remove" onclick="removeSocialActivity(this)">Hapus</button></div>
      </div>
    `);
  }
  function removeSocialActivity(btn){ btn.closest('.dynamic-group').remove(); }

  function addAchievement(){
    achievementIndex++;
    const c = document.getElementById('achievements');
    c.insertAdjacentHTML('beforeend', `
      <div class="dynamic-group" data-index="${achievementIndex}">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
          <div class="form-group"><label class="form-label">Prestasi</label>
            <input type="text" name="achievements[${achievementIndex}][achievement]" class="form-input"></div>
          <div class="form-group"><label class="form-label">Tahun</label>
            <input type="number" name="achievements[${achievementIndex}][year]" class="form-input" min="1950" max="2030"></div>
          <div class="form-group"><label class="form-label">Keterangan</label>
            <input type="text" name="achievements[${achievementIndex}][description]" class="form-input"></div>
        </div>
        <div class="mt-4"><button type="button" class="btn-remove" onclick="removeAchievement(this)">Hapus</button></div>
      </div>
    `);
  }
  function removeAchievement(btn){ btn.closest('.dynamic-group').remove(); }

  // Validasi minimum (client side)
  document.getElementById('applicationForm').addEventListener('submit', function(e){
    const required = ['full_name','email','position_applied'];
    let bad = false;
    required.forEach(id=>{
      const el = document.getElementById(id);
      if (!el || !el.value.trim()){ bad = true; el?.style && (el.style.borderColor = '#ef4444'); }
      else if(el.style) el.style.borderColor = '#d1d5db';
    });
    const agree = document.querySelector('input[name="agreement"]');
    if(!agree?.checked){ bad=true; alert('Anda harus menyetujui pernyataan untuk melanjutkan'); }
    if(bad){ e.preventDefault(); alert('Harap isi semua field yang wajib diisi (*)'); }
    else { localStorage.removeItem(STORAGE_KEY); }
  });
</script>
@endpush
