{{-- resources/views/dashboard/admin.blade.php --}}
@extends('layouts.app')

@section('title', 'Dashboard Admin')
@section('page-title', 'Dashboard')

@push('styles')
  <!-- Animations (CSS saja taruh di stack styles) -->
  <style>
    @keyframes slideInUp {
      from { opacity: 0; transform: translateY(24px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .animate-slide-up {
      animation: slideInUp 0.6s ease forwards;
    }
  </style>
@endpush

{{-- JANGAN muat Chart.js di sini. Sudah dimuat dari layout. --}}

@section('content')
<div class="space-y-6">
  {{-- ===== Stats Cards ===== --}}
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
    <!-- Total Kandidat -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card will-animate">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Total Kandidat</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">
            {{ number_format($totalCandidates ?? 1234) }}
          </p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">{{ $candidateGrowthText ?? '+12% dari bulan lalu' }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-blue-500 to-purple-600 p-3 rounded-xl">
          <i class="fas fa-users text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Active Users -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card will-animate">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Active Users</p>
          @php
            $hr = $activeUsersHr ?? 8;
            $interviewer = $activeUsersInterviewer ?? 17;
          @endphp
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ number_format($hr + $interviewer) }}</p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">HR: {{ $hr }}, Interviewer: {{ $interviewer }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-green-500 to-emerald-600 p-3 rounded-xl">
          <i class="fas fa-user-check text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Open Positions -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card will-animate">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Open Positions</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ number_format($openPositions ?? 15) }}</p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">{{ $newPositionsText ?? '+3 posisi baru' }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-amber-500 to-orange-600 p-3 rounded-xl">
          <i class="fas fa-briefcase text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Interview Hari Ini -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card will-animate">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Interview Hari Ini</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ number_format($todayInterviews ?? 12) }}</p>
          <div class="flex items-center mt-2 text-sm">
            @php $reschedulesCount = $reschedules ?? 2; @endphp
            <i class="fas {{ $reschedulesCount > 0 ? 'fa-arrow-down text-red-500' : 'fa-arrow-up text-green-500' }} mr-1"></i>
            <span class="{{ $reschedulesCount > 0 ? 'text-red-600' : 'text-green-600' }} font-medium">
              {{ $reschedulesCount }} reschedule
            </span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-red-500 to-rose-600 p-3 rounded-xl">
          <i class="fas fa-calendar-day text-white text-xl"></i>
        </div>
      </div>
    </div>
  </div>

  {{-- ===== Charts & Recent Activity ===== --}}
  <div class="grid grid-cols-1 xl:grid-cols-3 gap-6">
    <!-- Analytics Chart -->
    <div class="xl:col-span-2 bg-white rounded-xl shadow-lg p-6">
      <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-bold text-gray-900">Recruitment Analytics</h3>
        <form class="flex items-center space-x-2">
          <select name="range"
                  onchange="updateChart(this.value)"
                  class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            <option value="30"  {{ (request('range') ?? '30')=='30' ? 'selected' : '' }}>Last 30 days</option>
            <option value="90"  {{ (request('range') ?? '30')=='90' ? 'selected' : '' }}>Last 3 months</option>
            <option value="180" {{ (request('range') ?? '30')=='180' ? 'selected' : '' }}>Last 6 months</option>
          </select>
        </form>
      </div>

      <div class="relative h-80">
        <canvas id="recruitmentChart" aria-label="Recruitment Analytics Line Chart" role="img"></canvas>
      </div>
    </div>

    <!-- Recent Activity -->
    <div class="bg-white rounded-xl shadow-lg p-6">
      <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-bold text-gray-900">Recent Activity</h3>
        @if(Route::has('candidates.index'))
          <a href="{{ route('candidates.index') }}"
             class="text-blue-600 hover:text-blue-800 text-sm font-medium transition-colors">
            View All
          </a>
        @else
          <span class="text-gray-400 text-sm">View All</span>
        @endif
      </div>

      <div class="space-y-4">
        <!-- Item 1 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            HR
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Sarah HR</span> menambahkan kandidat baru
            </p>
            <p class="text-xs text-gray-500 mt-1">2 menit yang lalu</p>
          </div>
        </div>

        <!-- Item 2 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            IN
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">John Interviewer</span> menyelesaikan interview
            </p>
            <p class="text-xs text-gray-500 mt-1">15 menit yang lalu</p>
          </div>
        </div>

        <!-- Item 3 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-amber-500 to-orange-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            AD
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Admin</span> membuat user baru
            </p>
            <p class="text-xs text-gray-500 mt-1">1 jam yang lalu</p>
          </div>
        </div>

        <!-- Item 4 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-red-500 to-rose-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            HR
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Lisa HR</span> menjadwalkan interview
            </p>
            <p class="text-xs text-gray-500 mt-1">2 jam yang lalu</p>
          </div>
        </div>

        <!-- Show More -->
        <div class="pt-4 border-t border-gray-200">
          <button type="button" class="w-full text-center text-sm text-blue-600 hover:text-blue-800 font-medium transition-colors">
            <i class="fas fa-chevron-down mr-1"></i>
            Load More Activities
          </button>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
/** ===== Helpers ===== */
function rand(min, max) { return Math.floor(Math.random() * (max - min + 1)) + min; }

/** ===== Stat cards animation with IntersectionObserver ===== */
document.addEventListener('DOMContentLoaded', () => {
  const cards = document.querySelectorAll('.stat-card.will-animate');
  const obs = new IntersectionObserver((entries, observer) => {
    entries.forEach((e) => {
      if (e.isIntersecting) {
        e.target.classList.add('animate-slide-up');
        observer.unobserve(e.target);
      }
    });
  }, { threshold: 0.2 });

  cards.forEach((el, i) => {
    el.style.opacity = '0';
    el.style.transform = 'translateY(24px)';
    setTimeout(() => obs.observe(el), i * 80);
  });

  initRecruitmentChart();
});

/** ===== Chart.js: keep single instance ===== */
let recruitmentChart = null;

function initRecruitmentChart() {
  const canvas = document.getElementById('recruitmentChart');
  if (!canvas || typeof Chart === 'undefined') return;

  const ctx = canvas.getContext('2d');

  // Sample data (bisa diganti dari Controller via compact([...]))
  const initial = {
    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
    datasets: [
      {
        label: 'Applications',
        data: [65, 78, 90, 81, 95, 102],
        borderColor: 'rgb(59, 130, 246)',
        backgroundColor: 'rgba(59, 130, 246, 0.1)',
        fill: true,
        tension: 0.4
      },
      {
        label: 'Interviews',
        data: [28, 35, 42, 38, 45, 51],
        borderColor: 'rgb(16, 185, 129)',
        backgroundColor: 'rgba(16, 185, 129, 0.1)',
        fill: true,
        tension: 0.4
      },
      {
        label: 'Hired',
        data: [12, 15, 18, 16, 20, 23],
        borderColor: 'rgb(245, 158, 11)',
        backgroundColor: 'rgba(245, 158, 11, 0.1)',
        fill: true,
        tension: 0.4
      }
    ]
  };

  if (recruitmentChart) {
    recruitmentChart.destroy();
  }

  recruitmentChart = new Chart(ctx, {
    type: 'line',
    data: initial,
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'top',
          labels: { usePointStyle: true, padding: 20 }
        },
        tooltip: {
          mode: 'index',
          intersect: false,
          backgroundColor: 'rgba(0, 0, 0, 0.8)',
          titleColor: 'white',
          bodyColor: 'white',
          borderColor: 'rgba(255, 255, 255, 0.2)',
          borderWidth: 1
        }
      },
      scales: {
        x: { grid: { color: 'rgba(0, 0, 0, 0.05)' } },
        y: {
          beginAtZero: true,
          grid: { color: 'rgba(0, 0, 0, 0.05)' }
        }
      },
      interaction: { mode: 'nearest', axis: 'x', intersect: false }
    }
  });
}

/** ===== Update Chart (dummy randomizer; ganti dengan AJAX sesuai kebutuhan) ===== */
function updateChart(range) {
  if (!recruitmentChart) return;

  // Contoh: regenerate data sesuai range (30/90/180)
  const points = range === '180' ? 12 : (range === '90' ? 8 : 6);
  const labels = Array.from({length: points}, (_, i) => `P${i+1}`);
  recruitmentChart.data.labels = labels;

  recruitmentChart.data.datasets[0].data = labels.map(() => rand(60, 120));
  recruitmentChart.data.datasets[1].data = labels.map(() => rand(25, 60));
  recruitmentChart.data.datasets[2].data = labels.map(() => rand(10, 30));
  recruitmentChart.update();

  // Feedback (SweetAlert sudah ada di layout)
  if (typeof Swal !== 'undefined') {
    Swal.fire({
      title: 'Updating Chart...',
      text: `Loading data for ${range} days`,
      timer: 900,
      showConfirmButton: false,
      didOpen: () => { Swal.showLoading(); }
    });
  }
}

/** ===== Auto-refresh stats (placeholder) ===== */
setInterval(() => {
  // TODO: panggil endpoint untuk refresh angka KPI
  // fetch('/dashboard/stats?range=30').then(...)
  console.log('Auto-refreshing dashboard stats...');
}, 5 * 60 * 1000);
</script>
@endpush
