{{-- resources/views/employees/edit.blade.php --}}
@extends('layouts.app')

@section('title', 'Edit Karyawan')
@section('page-title', 'Edit Karyawan')

@section('content')
  {{-- Breadcrumb + actions --}}
  <div class="mb-6 flex items-center justify-between">
    <nav class="text-sm text-gray-500">
      <a href="{{ route('employees.index') }}" class="hover:text-gray-700">Karyawan Diterima</a>
      <span class="mx-1">/</span>
      <span>Edit</span>
    </nav>
    <div class="flex gap-2">
      <a href="{{ route('employees.show', $employee->id) }}"
         class="inline-flex items-center gap-2 px-4 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50">
        <i class="fas fa-arrow-left"></i> <span>Detail</span>
      </a>
    </div>
  </div>

  <form action="{{ route('employees.update', $employee->id) }}" method="POST"
        class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm space-y-6">
    @csrf
    @method('PUT')

    {{-- Notif error --}}
    @if ($errors->any())
      <div class="rounded-lg border border-rose-200 bg-rose-50 text-rose-800 p-4">
        <div class="font-semibold mb-2 flex items-center gap-2">
          <i class="fas fa-triangle-exclamation"></i>
          Periksa kembali isian
        </div>
        <ul class="list-disc pl-5 text-sm">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    {{-- Snapshot Kandidat (opsional) --}}
    <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-id-badge text-gray-500"></i> Kandidat Asal
      </h3>
      @php $cand = $employee->candidate ?? null; @endphp
      @if($cand)
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500 w-40">Kode</span>
            <span class="text-sm text-gray-900 flex-1 text-right">{{ $cand->candidate_code }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500 w-40">Nama</span>
            <span class="text-sm text-gray-900 flex-1 text-right">{{ $cand->full_name }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500 w-40">Email</span>
            <span class="text-sm text-gray-900 flex-1 text-right">{{ $cand->email }}</span>
          </div>
          <div class="flex justify-between gap-4">
            <span class="text-sm text-gray-500 w-40">Telepon</span>
            <span class="text-sm text-gray-900 flex-1 text-right">{{ $cand->phone_number ?? '—' }}</span>
          </div>
          <div class="flex justify-between gap-4 md:col-span-2">
            <span class="text-sm text-gray-500 w-40">Posisi Dilamar</span>
            <span class="text-sm text-gray-900 flex-1 text-right">
              {{ optional($cand->position)->position_name ?? $cand->position_applied }}
            </span>
          </div>
        </div>
      @else
        <div class="flex flex-col items-center justify-center text-gray-500 py-4">
          <i class="fas fa-circle-info text-lg mb-1"></i>
          <p class="text-sm">Tidak terhubung ke data kandidat.</p>
        </div>
      @endif
    </section>

    {{-- 1. Penempatan & Organisasi --}}
    <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-sitemap text-gray-500"></i> Penempatan & Organisasi
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        {{-- <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Pilih Posisi (master)</label>
          <select id="position_id" name="position_id"
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="">— Pilih Posisi —</option>
            @foreach($positions as $pos)
              <option
                value="{{ $pos->id }}"
                data-position-name="{{ $pos->position_name }}"
                data-department="{{ $pos->department }}"
                data-location="{{ $pos->location }}"
                @selected(old('position_id', $employee->position_id) == $pos->id)
              >
                {{ $pos->position_name }} — {{ $pos->department }} ({{ $pos->location }})
              </option>
            @endforeach
          </select>
          <p class="text-xs text-gray-500 mt-1">Memilih posisi akan mengisi otomatis kolom di bawah.</p>
        </div> --}}

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">
            Position Name (snapshot) <span class="text-rose-600">*</span>
          </label>
          <input type="text" id="position_name" name="position_name" required
                 value="{{ old('position_name', $employee->position_name) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Department <span class="text-rose-600">*</span></label>
          <select id="department" name="department" required
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="">— Pilih Department —</option>
            @foreach($departments as $dept)
              <option value="{{ $dept }}" @selected(old('department', $employee->department) == $dept)>{{ $dept }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Branch <span class="text-rose-600">*</span></label>
          <select id="branch" name="branch" required
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="">— Pilih Branch —</option>
            @foreach($branches as $b)
              <option value="{{ $b }}" @selected(old('branch', $employee->branch) == $b)>{{ $b }}</option>
            @endforeach
          </select>
          <p class="text-xs text-gray-500 mt-1">Format: PT. Kayu Mebel Indonesia - {Lokasi}</p>
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Job Level <span class="text-rose-600">*</span></label>
          <select name="job_level" id="job_level" required
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="">— Pilih Job Level —</option>
            @foreach($jobLevels as $jl)
              <option value="{{ $jl }}" @selected(old('job_level', $employee->job_level) == $jl)>{{ $jl }}</option>
            @endforeach
          </select>
        </div>
      </div>
    </section>

    {{-- 2. Status Kepegawaian --}}
    <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-id-card-clip text-gray-500"></i> Status Kepegawaian
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Employment Type <span class="text-rose-600">*</span></label>
          <select name="employment_type" required
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            @foreach($employmentTypes as $et)
              <option value="{{ $et }}" @selected(old('employment_type', $employee->employment_type) == $et)>{{ ucfirst($et) }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Contract Type <span class="text-rose-600">*</span></label>
          <select name="contract_type" required
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            @foreach($contractTypes as $ct)
              <option value="{{ $ct }}" @selected(old('contract_type', $employee->contract_type) == $ct)>{{ $ct }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Mulai Kerja</label>
          <input type="date" name="start_date"
                 value="{{ old('start_date', optional($employee->start_date)->format('Y-m-d')) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Akhir Kontrak</label>
          <input type="date" name="end_date"
                 value="{{ old('end_date', optional($employee->end_date)->format('Y-m-d')) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Status Aktif</label>
          <select name="is_active"
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="1" @selected(old('is_active', $employee->is_active)==1)>Aktif</option>
            <option value="0" @selected(old('is_active', $employee->is_active)==0)>Nonaktif</option>
          </select>
        </div>
      </div>
    </section>

    {{-- 3. Kompensasi --}}
    {{-- <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-money-bill-wave text-gray-500"></i> Kompensasi
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Mata Uang</label>
          <input type="text" name="salary_currency"
                 value="{{ old('salary_currency', $employee->salary_currency ?? 'IDR') }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Gaji Pokok</label>
          <input type="number" step="0.01" name="base_salary"
                 value="{{ old('base_salary', $employee->base_salary) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Tunjangan</label>
          <input type="number" step="0.01" name="allowance"
                 value="{{ old('allowance', $employee->allowance) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Uang Makan/Transport</label>
          <input type="number" step="0.01" name="meal_transport"
                 value="{{ old('meal_transport', $employee->meal_transport) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div class="md:col-span-2">
          <label class="block text-sm font-medium text-gray-700 mb-1">Benefit Lain</label>
          <input type="number" step="0.01" name="other_benefits"
                 value="{{ old('other_benefits', $employee->other_benefits) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
      </div>
    </section> --}}

    {{-- 4. Pajak & Kepesertaan --}}
    <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-receipt text-gray-500"></i> Pajak & Kepesertaan
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Status Pajak (PTKP)</label>
          @php $ptkpOptions = ['TK/0','TK/1','TK/2','TK/3','K/0','K/1','K/2','K/3']; @endphp
          <select name="tax_status"
                  class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
            <option value="">— Pilih —</option>
            @foreach($ptkpOptions as $ts)
              <option value="{{ $ts }}" @selected(old('tax_status', $employee->tax_status) == $ts)>{{ $ts }}</option>
            @endforeach
          </select>
        </div>
      </div>
    </section>

    {{-- 5. Rekening Payroll --}}
    {{-- <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-building-columns text-gray-500"></i> Rekening Payroll
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Nama Bank</label>
          <input type="text" name="bank_name"
                 value="{{ old('bank_name', $employee->bank_name) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">No. Rekening</label>
          <input type="text" name="bank_account_no"
                 value="{{ old('bank_account_no', $employee->bank_account_no) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div class="md:col-span-2">
          <label class="block text-sm font-medium text-gray-700 mb-1">Atas Nama</label>
          <input type="text" name="bank_account_holder"
                 value="{{ old('bank_account_holder', $employee->bank_account_holder ?? $employee->full_name) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
      </div>
    </section> --}}

    {{-- 6. Pengaturan Kerja --}}
    <section>
      <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center gap-2">
        <i class="fas fa-clipboard-check text-gray-500"></i> Pengaturan Kerja
      </h3>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Nama Atasan</label>
          <input type="text" name="supervisor_name"
                 value="{{ old('supervisor_name', $employee->supervisor_name) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Jadwal Kerja</label>
          <input type="text" name="work_schedule" placeholder="Shift A / Non Shift"
                 value="{{ old('work_schedule', $employee->work_schedule) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Lokasi Kerja (Detail)</label>
          <input type="text" name="work_location_detail" placeholder="Gedung/Line/Block"
                 value="{{ old('work_location_detail', $employee->work_location_detail) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
        <div>
          <label class="block text-sm font-medium text-gray-700 mb-1">Kode Karyawan (opsional)</label>
          <input type="text" name="employee_code"
                 value="{{ old('employee_code', $employee->employee_code) }}"
                 class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
        </div>
      </div>
    </section>

    {{-- Actions --}}
    <div class="flex items-center justify-end gap-2 pt-2">
      <a href="{{ route('employees.show', $employee->id) }}"
         class="inline-flex items-center gap-2 px-4 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50">
        <i class="fas fa-xmark"></i> Batal
      </a>
      <button type="submit"
              class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white hover:bg-indigo-700">
        <i class="fas fa-save"></i> Simpan
      </button>
    </div>
  </form>
@endsection

@push('scripts')
<script>
  (function(){
    const selectPos    = document.getElementById('position_id');
    const inputPosName = document.getElementById('position_name');
    const selectDept   = document.getElementById('department');
    const selectBranch = document.getElementById('branch');

    function setIfExists(select, value){
      if(!select) return;
      const exists = Array.from(select.options).some(o => o.value === value);
      if(value && exists) select.value = value;
    }

    // Prefill dari master posisi saat berubah
    selectPos?.addEventListener('change', (e)=>{
      const opt   = e.target.selectedOptions[0];
      if(!opt) return;

      const pname = opt.getAttribute('data-position-name') || '';
      const dept  = opt.getAttribute('data-department')   || '';
      const loc   = opt.getAttribute('data-location')     || '';
      const branch= loc ? `PT. Kayu Mebel Indonesia - ${loc}` : '';

      if(pname && inputPosName) inputPosName.value = pname;
      setIfExists(selectDept,   dept);
      setIfExists(selectBranch, branch);
    });
  })();
</script>
@endpush
