{{-- resources/views/positions/edit.blade.php --}}
@extends('layouts.app')

@section('title', 'Edit Posisi')
@section('page-title', 'Edit Posisi')

@push('styles')
<style>
  /* ===== Halaman Edit Posisi (scoped) ===== */
  .mb-6{margin-bottom:1.5rem}
  .flex{display:flex}.gap-2{gap:.5rem}.gap-3{gap:.75rem}.gap-4{gap:1rem}
  .text-gray-500{color:#6b7280}.text-gray-900{color:#111827}
  .text-primary{color:#4f46e5}
  .text-2xl{font-size:1.5rem}.font-bold{font-weight:700}

  .btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;font-weight:700;border:1px solid transparent;text-decoration:none}
  .btn-primary{background:linear-gradient(135deg,#4f46e5,#7c3aed);color:#fff}
  .btn-primary:hover{filter:brightness(.98)}
  .btn-secondary{background:#6b7280;color:#fff}
  .btn-secondary:hover{background:#4b5563}
  .btn-warning{background:linear-gradient(135deg,#f59e0b,#d97706);color:#fff}
  .btn-warning:hover{filter:brightness(.98)}
  .btn.loading{opacity:.7;pointer-events:none}
  .btn.loading::after{content:'';width:16px;height:16px;border:2px solid transparent;border-top:2px solid currentColor;border-radius:50%;animation:spin 1s linear infinite;margin-left:8px}
  @keyframes spin{to{transform:rotate(360deg)}}

  .alert{padding:12px 16px;border-radius:8px;margin-bottom:18px;display:flex;align-items:center;gap:10px}
  .alert-success{background:#d1fae5;color:#065f46;border:1px solid #a7f3d0}
  .alert-error{background:#fee2e2;color:#991b1b;border:1px solid #fecaca}

  .candidate-info-section{display:grid;grid-template-columns:1fr 1fr;gap:20px;margin-bottom:24px}
  .info-card{background:#fff;border-radius:12px;padding:20px;box-shadow:0 4px 20px rgba(0,0,0,.08);border-left:4px solid #e5e7eb}
  .info-card.has-candidates{border-left-color:#f59e0b;background:linear-gradient(135deg,#fefbf2,#ffffff)}
  .info-card.no-candidates{border-left-color:#10b981;background:linear-gradient(135deg,#f0fdf8,#ffffff)}
  .info-card-header{display:flex;align-items:center;gap:12px;margin-bottom:12px}
  .info-card-icon{width:40px;height:40px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:1.1rem}
  .info-card.has-candidates .info-card-icon{background:rgba(245,158,11,.1);color:#f59e0b}
  .info-card.no-candidates .info-card-icon{background:rgba(16,185,129,.1);color:#10b981}
  .info-card-title{font-size:1.05rem;font-weight:700;color:#111827}
  .info-card-subtitle{font-size:.86rem;color:#6b7280}

  .candidate-stats{display:grid;grid-template-columns:1fr 1fr;gap:12px}
  .stat-item{text-align:center;padding:12px;background:rgba(255,255,255,.7);border-radius:8px;border:1px solid #e5e7eb}
  .stat-number{font-size:1.3rem;font-weight:700;color:#111827;display:block}
  .stat-label{font-size:.75rem;color:#6b7280;text-transform:uppercase;letter-spacing:.04em}
  .warning-note{background:#fef3c7;border:1px solid #fbbf24;color:#92400e;padding:12px 15px;border-radius:8px;margin-top:12px;font-size:.85rem;display:flex;align-items:center;gap:8px}
  .success-note{background:#d1fae5;border:1px solid #a7f3d0;color:#065f46;padding:12px 15px;border-radius:8px;margin-top:12px;font-size:.85rem;display:flex;align-items:center;gap:8px}

  .form-container{background:#fff;border-radius:12px;box-shadow:0 4px 20px rgba(0,0,0,.1);overflow:hidden}
  .form-header{background:linear-gradient(135deg,#f59e0b,#d97706);color:#fff;padding:20px 24px}
  .form-title{font-size:1.2rem;font-weight:700}
  .form-subtitle{font-size:.9rem;opacity:.95}
  .form-body{padding:22px}
  .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:18px;margin-bottom:18px}
  .form-group{margin-bottom:18px}
  .form-group.full-width{grid-column:1 / -1}
  .form-label{display:block;font-size:.9rem;font-weight:700;color:#374151;margin-bottom:8px}
  .form-label.required::after{content:' *';color:#dc2626}
  .form-input,.form-select,.form-textarea{width:100%;padding:12px 14px;border:1px solid #d1d5db;border-radius:8px;font-size:.95rem;transition:.15s;background:#fff}
  .form-input:focus,.form-select:focus,.form-textarea:focus{outline:0;border-color:#f59e0b;box-shadow:0 0 0 3px rgba(245,158,11,.12)}
  .form-textarea{resize:vertical;min-height:100px}
  .form-textarea.large{min-height:120px}
  .form-row{display:grid;grid-template-columns:1fr 1fr;gap:15px}
  .form-help{font-size:.8rem;color:#6b7280;margin-top:6px}
  .checkbox-group{display:flex;align-items:center;gap:10px;margin-top:6px}
  .checkbox-input{width:18px;height:18px;border:2px solid #d1d5db;border-radius:4px;cursor:pointer}
  .checkbox-input:checked{background:#f59e0b;border-color:#f59e0b}
  .checkbox-label{font-size:.95rem;color:#374151;cursor:pointer}
  .form-input.error,.form-select.error,.form-textarea.error{border-color:#dc2626;box-shadow:0 0 0 3px rgba(220,38,38,.12)}
  .error-message{color:#dc2626;font-size:.8rem;margin-top:6px;display:flex;align-items:center;gap:6px}

  .form-actions{background:#f9fafb;padding:16px 22px;display:flex;justify-content:space-between;align-items:center;border-top:1px solid #e5e7eb}
  .form-actions-left{color:#6b7280;font-size:.88rem}
  .form-actions-right{display:flex;gap:10px}

  /* Responsive */
  @media (max-width: 1024px){
    .form-grid{grid-template-columns:1fr}
    .candidate-info-section{grid-template-columns:1fr}
    .form-row{grid-template-columns:1fr}
  }
</style>
@endpush

@section('content')
  {{-- Header + breadcrumb + actions --}}
  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <div class="text-sm text-gray-500">
        <a href="{{ route('dashboard') }}" class="text-primary hover:underline">Dashboard</a>
        <span class="mx-1">/</span>
        <a href="{{ route('positions.index') }}" class="text-primary hover:underline">Posisi</a>
        <span class="mx-1">/</span>
        <span>Edit</span>
      </div>
      <h1 class="text-2xl font-bold text-gray-900 mt-1">Edit Posisi: {{ $position->position_name }}</h1>
    </div>
    <div class="flex gap-2">
      <a href="{{ route('positions.show', $position) }}" class="btn btn-primary">
        <i class="fas fa-eye"></i> Lihat Detail
      </a>
      <a href="{{ route('positions.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali
      </a>
    </div>
  </div>

  {{-- Alert flash --}}
  @if(session('success'))
    <div class="alert alert-success"><i class="fas fa-check-circle"></i>{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="alert alert-error"><i class="fas fa-exclamation-circle"></i>{{ session('error') }}</div>
  @endif

  {{-- Info kandidat & status posisi --}}
  <div class="candidate-info-section">
    {{-- Kandidat --}}
    @if($hasActiveCandidates || $totalCandidates > 0)
      <div class="info-card has-candidates">
        <div class="info-card-header">
          <div class="info-card-icon"><i class="fas fa-users"></i></div>
          <div>
            <div class="info-card-title">Kandidat Terdaftar</div>
            <div class="info-card-subtitle">Posisi ini memiliki kandidat yang mendaftar</div>
          </div>
        </div>
        <div class="candidate-stats">
          <div class="stat-item">
            <span class="stat-number">{{ $totalCandidates }}</span>
            <span class="stat-label">Total Kandidat</span>
          </div>
          <div class="stat-item">
            <span class="stat-number" style="color: {{ $activeCandidates > 0 ? '#f59e0b' : '#6b7280' }};">{{ $activeCandidates }}</span>
            <span class="stat-label">Sedang Proses</span>
          </div>
        </div>
        @if($activeCandidates > 0)
          <div class="warning-note">
            <i class="fas fa-exclamation-triangle"></i>
            <div><strong>Perhatian!</strong> {{ $activeCandidates }} kandidat sedang dalam proses rekrutmen. Perubahan pada posisi ini dapat mempengaruhi proses yang berjalan.</div>
          </div>
        @else
          <div class="success-note">
            <i class="fas fa-info-circle"></i>
            <div>Semua aplikasi untuk posisi ini sudah selesai diproses.</div>
          </div>
        @endif
      </div>
    @else
      <div class="info-card no-candidates">
        <div class="info-card-header">
          <div class="info-card-icon"><i class="fas fa-user-plus"></i></div>
          <div>
            <div class="info-card-title">Belum Ada Kandidat</div>
            <div class="info-card-subtitle">Posisi ini belum memiliki kandidat yang mendaftar</div>
          </div>
        </div>
        <div class="candidate-stats">
          <div class="stat-item"><span class="stat-number">0</span><span class="stat-label">Total Kandidat</span></div>
          <div class="stat-item"><span class="stat-number">0</span><span class="stat-label">Sedang Proses</span></div>
        </div>
        <div class="success-note">
          <i class="fas fa-check-circle"></i>
          <div>Anda dapat mengubah semua informasi posisi dengan aman karena belum ada kandidat yang mendaftar.</div>
        </div>
      </div>
    @endif

    {{-- Status posisi --}}
    <div class="info-card {{ $position->detailed_status === 'aktif' ? 'no-candidates' : 'has-candidates' }}">
      <div class="info-card-header">
        <div class="info-card-icon">
          <i class="fas {{ $position->detailed_status === 'aktif' ? 'fa-check-circle' : 'fa-times-circle' }}"></i>
        </div>
        <div>
          <div class="info-card-title">Status Posisi</div>
          <div class="info-card-subtitle">{{ $position->detailed_status === 'aktif' ? 'Menerima Aplikasi' : 'Tidak Menerima Aplikasi' }}</div>
        </div>
      </div>

      <div style="text-align:center;padding:14px 0;">
        <span style="display:inline-block;padding:10px 24px;border-radius:25px;font-weight:700;font-size:1rem;background:{{ $position->detailed_status === 'aktif' ? '#d1fae5' : '#fef3c7' }};color:{{ $position->detailed_status === 'aktif' ? '#065f46' : '#92400e' }};">
          {{ $position->detailed_status === 'aktif' ? '✅ AKTIF' : '⏸️ TUTUP' }}
        </span>
      </div>

      <div style="background:rgba(255,255,255,.7);border-radius:8px;padding:12px;margin-top:8px;font-size:.88rem">
        @if($position->posted_date)
          <div style="color:#6b7280;margin-bottom:4px;"><i class="fas fa-calendar-plus"></i> Dibuat: {{ $position->posted_date->format('d M Y') }}</div>
        @endif
        @if($position->closing_date)
          @php
            $isExpired = $position->closing_date->isPast();
            $daysUntilClose = $position->closing_date->diffInDays(now(), false);
          @endphp
          <div style="color:{{ $isExpired ? '#dc2626' : '#f59e0b' }};margin-bottom:4px;">
            <i class="fas fa-calendar-times"></i> Tutup: {{ $position->closing_date->format('d M Y') }}
            @if($isExpired)
              <span style="font-size:.75rem;background:#fee2e2;color:#991b1b;padding:2px 6px;border-radius:10px;margin-left:6px;">Sudah Lewat {{ abs($daysUntilClose) }} hari</span>
            @else
              <span style="font-size:.75rem;background:#fef3c7;color:#92400e;padding:2px 6px;border-radius:10px;margin-left:6px;">{{ $daysUntilClose }} hari lagi</span>
            @endif
          </div>
        @endif

        <div style="margin-top:8px;padding-top:8px;border-top:1px solid #e5e7eb;color:#6b7280;font-size:.82rem">
          @if($position->detailed_status === 'aktif')
            <i class="fas fa-info-circle"></i> Posisi dapat menerima aplikasi baru
          @else
            <i class="fas fa-info-circle"></i>
            @if(!$position->is_active)
              Posisi dinonaktifkan secara manual
            @elseif($position->closing_date && $position->closing_date->isPast())
              Posisi ditutup karena melewati tanggal penutupan
            @else
              Posisi tidak menerima aplikasi baru
            @endif
          @endif
        </div>
      </div>
    </div>
  </div>

  {{-- Form Edit --}}
  <div class="form-container">
    <div class="form-header">
      <div class="form-title">Edit Informasi Posisi</div>
      <div class="form-subtitle">Perbarui informasi posisi sesuai kebutuhan</div>
    </div>

    <form method="POST" action="{{ route('positions.update', $position) }}" id="positionForm">
      @csrf
      @method('PUT')

      <div class="form-body">
        {{-- Basic --}}
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label required">Nama Posisi</label>
            <input type="text" name="position_name" class="form-input"
                   value="{{ old('position_name', $position->position_name) }}" placeholder="Contoh: Senior Software Engineer" required>
            @error('position_name')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label class="form-label required">Departemen</label>
            <input type="text" name="department" class="form-input"
                   value="{{ old('department', $position->department) }}" placeholder="Contoh: Technology" list="departments" required>
            <datalist id="departments">
              @foreach($departments as $dept)
                <option value="{{ $dept }}">
              @endforeach
            </datalist>
            @error('department')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label class="form-label">Lokasi</label>
            <input type="text" name="location" class="form-input"
                   value="{{ old('location', $position->location) }}" placeholder="Contoh: Jakarta Pusat" list="locations">
            <datalist id="locations">
              @foreach($locations as $location)
                <option value="{{ $location }}">
              @endforeach
            </datalist>
            @error('location')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label class="form-label required">Tipe Pekerjaan</label>
            <select name="employment_type" class="form-select" required>
              <option value="">Pilih Tipe Pekerjaan</option>
              @foreach($employmentTypes as $key => $label)
                <option value="{{ $key }}" {{ old('employment_type', $position->employment_type) == $key ? 'selected' : '' }}>{{ $label }}</option>
              @endforeach
            </select>
            @error('employment_type')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>
        </div>

        {{-- Salary --}}
        <div class="form-group">
          <label class="form-label">Rentang Gaji</label>
          <div class="form-row">
            <div>
              <input type="number" name="salary_range_min" class="form-input"
                     value="{{ old('salary_range_min', $position->salary_range_min) }}" placeholder="Gaji minimum" min="0">
              <div class="form-help">Gaji minimum (Rp)</div>
              @error('salary_range_min')
                <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
              @enderror
            </div>
            <div>
              <input type="number" name="salary_range_max" class="form-input"
                     value="{{ old('salary_range_max', $position->salary_range_max) }}" placeholder="Gaji maksimum" min="0">
              <div class="form-help">Gaji maksimum (Rp)</div>
              @error('salary_range_max')
                <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
              @enderror
            </div>
          </div>
          <div class="form-help">Kosongkan jika gaji dapat dinegosiasikan</div>
        </div>

        {{-- Description --}}
        <div class="form-group full-width">
          <label class="form-label">Deskripsi Posisi</label>
          <textarea name="description" class="form-textarea large" placeholder="Deskripsikan tugas, tanggung jawab, dan lingkup pekerjaan...">{{ old('description', $position->description) }}</textarea>
          <div class="form-help">Jelaskan secara detail tentang posisi ini</div>
          @error('description')
            <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
          @enderror
        </div>

        {{-- Requirements --}}
        <div class="form-group full-width">
          <label class="form-label">Persyaratan</label>
          <textarea name="requirements" class="form-textarea large" placeholder="Sebutkan persyaratan pendidikan, pengalaman, keahlian yang dibutuhkan...">{{ old('requirements', $position->requirements) }}</textarea>
          <div class="form-help">Jelaskan kriteria kandidat yang diharapkan</div>
          @error('requirements')
            <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
          @enderror
        </div>

        {{-- Dates --}}
        <div class="form-grid">
          <div class="form-group">
            <label class="form-label">Tanggal Posting</label>
            <input type="date" name="posted_date" class="form-input"
                   value="{{ old('posted_date', $position->posted_date?->format('Y-m-d')) }}">
            <div class="form-help">Tanggal posisi mulai dibuka</div>
            @error('posted_date')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>
          <div class="form-group">
            <label class="form-label">Tanggal Penutupan</label>
            <input type="date" name="closing_date" class="form-input"
                   value="{{ old('closing_date', $position->closing_date?->format('Y-m-d')) }}">
            <div class="form-help">Batas akhir aplikasi (opsional)</div>
            @error('closing_date')
              <div class="error-message"><i class="fas fa-exclamation-triangle"></i>{{ $message }}</div>
            @enderror
          </div>
        </div>

        {{-- Status --}}
        <div class="form-group">
          <div class="checkbox-group">
            <input type="hidden" name="is_active" value="0">
            <input type="checkbox" name="is_active" value="1" class="checkbox-input" id="is_active" {{ old('is_active', $position->is_active) ? 'checked' : '' }}>
            <label for="is_active" class="checkbox-label">Buka posisi ini (dapat menerima aplikasi)</label>
          </div>
          <div class="form-help">
            @if($activeCandidates > 0)
              @if($position->is_active)
                <strong style="color:#059669;">✅ Info:</strong> Posisi aktif dengan <strong>{{ $activeCandidates }} kandidat dalam proses</strong>.
                <br><small style="color:#dc2626;">⚠️ Menutup posisi menghentikan aplikasi baru, kandidat yang sudah mendaftar tetap diproses.</small>
              @else
                <strong style="color:#f59e0b;">⚠️ Peringatan:</strong> Ada <strong>{{ $activeCandidates }} kandidat masih dalam proses</strong>.
                <br><small style="color:#059669;">✅ Membuka kembali memungkinkan aplikasi baru.</small>
              @endif
            @else
              @if($position->is_active)
                <span style="color:#059669;">✅ Posisi sedang terbuka untuk menerima aplikasi baru.</span>
              @else
                <span style="color:#6b7280;">📝 Centang untuk membuka posisi dan menerima aplikasi baru.</span>
              @endif
            @endif
          </div>
        </div>
      </div>

      <div class="form-actions">
        <div class="form-actions-left">
          <i class="fas fa-info-circle"></i> Terakhir diubah: {{ $position->updated_at->format('d M Y H:i') }}
        </div>
        <div class="form-actions-right">
          <a href="{{ route('positions.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> Batal</a>
          <button type="submit" class="btn btn-warning" id="submitBtn"><i class="fas fa-save"></i> Simpan Perubahan</button>
        </div>
      </div>
    </form>
  </div>
@endsection

@push('scripts')
<script>
  // Form validation + prevent double submit
  const form = document.getElementById('positionForm');
  const submitBtn = document.getElementById('submitBtn');

  if (form) {
    form.addEventListener('submit', function(e){
      submitBtn.classList.add('loading');
      submitBtn.disabled = true;

      let isValid = true;
      const requiredFields = ['position_name','department','employment_type'];
      requiredFields.forEach(name=>{
        const f = document.querySelector(`[name="${name}"]`);
        if (f && !f.value.trim()){
          f.classList.add('error');
          isValid = false;
        } else if (f){
          f.classList.remove('error');
        }
      });

      // Salary range check
      const minSalary = document.querySelector('[name="salary_range_min"]');
      const maxSalary = document.querySelector('[name="salary_range_max"]');
      if (minSalary && maxSalary && minSalary.value && maxSalary.value){
        if (parseFloat(minSalary.value) > parseFloat(maxSalary.value)){
          maxSalary.classList.add('error');
          isValid = false;
          if (!maxSalary.parentNode.querySelector('.error-message')){
            const em = document.createElement('div');
            em.className = 'error-message';
            em.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Gaji maksimum harus lebih besar dari minimum';
            maxSalary.parentNode.appendChild(em);
          }
        } else {
          maxSalary.classList.remove('error');
          const em = maxSalary.parentNode.querySelector('.error-message');
          if (em) em.remove();
        }
      }

      // Dates check
      const postedDate = document.querySelector('[name="posted_date"]');
      const closingDate = document.querySelector('[name="closing_date"]');
      if (postedDate && closingDate && postedDate.value && closingDate.value){
        if (new Date(postedDate.value) > new Date(closingDate.value)){
          closingDate.classList.add('error');
          isValid = false;
          if (!closingDate.parentNode.querySelector('.error-message')){
            const em = document.createElement('div');
            em.className = 'error-message';
            em.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Tanggal penutupan harus setelah tanggal posting';
            closingDate.parentNode.appendChild(em);
          }
        } else {
          closingDate.classList.remove('error');
          const em = closingDate.parentNode.querySelector('.error-message');
          if (em && em.textContent.includes('Tanggal penutupan')) em.remove();
        }
      }

      if (!isValid){
        e.preventDefault();
        submitBtn.classList.remove('loading');
        submitBtn.disabled = false;
        const firstError = document.querySelector('.form-input.error, .form-select.error');
        if (firstError){ firstError.scrollIntoView({behavior:'smooth',block:'center'}); firstError.focus(); }
      }
    });

    // Realtime validity
    document.querySelectorAll('.form-input, .form-select').forEach(el=>{
      el.addEventListener('blur', function(){
        if (this.hasAttribute('required') && !this.value.trim()) this.classList.add('error');
        else this.classList.remove('error');
      });
      el.addEventListener('input', function(){
        if (this.classList.contains('error') && this.value.trim()) this.classList.remove('error');
      });
    });

    // Salary live check
    const minSalaryInput = document.querySelector('[name="salary_range_min"]');
    const maxSalaryInput = document.querySelector('[name="salary_range_max"]');
    function validateSalaryRange(){
      if (minSalaryInput.value && maxSalaryInput.value){
        if (parseFloat(minSalaryInput.value) > parseFloat(maxSalaryInput.value)){
          maxSalaryInput.classList.add('error');
        } else {
          maxSalaryInput.classList.remove('error');
          const em = maxSalaryInput.parentNode.querySelector('.error-message');
          if (em && em.textContent.includes('maksimum harus')) em.remove();
        }
      }
    }
    if (minSalaryInput && maxSalaryInput){
      minSalaryInput.addEventListener('input', validateSalaryRange);
      maxSalaryInput.addEventListener('input', validateSalaryRange);
    }

    // Dates live check
    const postedDateInput = document.querySelector('[name="posted_date"]');
    const closingDateInput = document.querySelector('[name="closing_date"]');
    function validateDates(){
      if (postedDateInput.value && closingDateInput.value){
        if (new Date(postedDateInput.value) > new Date(closingDateInput.value)){
          closingDateInput.classList.add('error');
        } else {
          closingDateInput.classList.remove('error');
          const em = closingDateInput.parentNode.querySelector('.error-message');
          if (em && em.textContent.includes('Tanggal penutupan')) em.remove();
        }
      }
    }
    if (postedDateInput && closingDateInput){
      postedDateInput.addEventListener('change', validateDates);
      closingDateInput.addEventListener('change', validateDates);
    }

    // Auto-hide alerts
    document.querySelectorAll('.alert').forEach(a=>{
      setTimeout(()=>{ a.style.transition='opacity .4s'; a.style.opacity='0'; setTimeout(()=>a.remove(), 400); }, 5000);
    });

    // Format number inputs on blur (helper hint)
    document.querySelectorAll('input[type="number"]').forEach(input=>{
      input.addEventListener('blur', function(){
        if (!this.value) return;
        const val = parseFloat(this.value);
        if (isNaN(val)) return;
        const help = this.parentNode.querySelector('.form-help');
        if (help && this.name.includes('salary')){
          const formatted = new Intl.NumberFormat('id-ID',{style:'currency',currency:'IDR',minimumFractionDigits:0}).format(val);
          help.textContent = `${help.textContent.split('(')[0]}(${formatted})`;
        }
      });
    });
  }
</script>
@endpush
