{{-- resources/views/positions/index.blade.php --}}
@extends('layouts.app')

@section('title', 'Manajemen Posisi')
@section('page-title', 'Manajemen Posisi')

@push('styles')
  <link href="{{ asset('css/positions-index.css') }}" rel="stylesheet">
  {{-- FIX: pastikan dropdown tidak terpotong & selalu di atas --}}
  <style>
    .table-container{overflow:visible!important;}
    .positions-table .action-dropdown{position:relative; z-index:5;}
    .positions-table .dropdown-menu,
    .mobile-cards .dropdown-menu{z-index:50;}
  </style>
@endpush

@section('content')
  <div class="content">
    <header class="header">
      <div class="header-left">
        {{-- Toggle sidebar (mobile) --}}
        <button type="button" class="sidebar-toggle" id="openSidebarMobile" aria-label="Open sidebar">
          <i class="fas fa-bars"></i>
        </button>

        <div class="header-info">
          <div class="breadcrumb">
            <a href="{{ route('dashboard') }}">Dashboard</a>
            <span>/</span>
            <span>Posisi</span>
          </div>
          <h1 class="page-title">Manajemen Posisi</h1>
        </div>
      </div>

      <div class="header-right">
        <a href="{{ route('positions.create') }}" class="btn btn-primary">
          <i class="fas fa-plus"></i><span class="btn-text">Tambah Posisi</span>
        </a>
        <a href="{{ route('positions.trashed') }}" class="btn btn-secondary">
          <i class="fas fa-trash"></i><span class="btn-text">Posisi Terhapus</span>
        </a>
      </div>
    </header>

    {{-- Filter --}}
    <div class="filters-section">
      <form id="filterForm" method="GET">
        <div class="filters-row">
          <div class="filter-group">
            <label class="filter-label">Pencarian</label>
            <div class="search-input-container">
              <i class="fas fa-search search-icon"></i>
              <input type="text" name="search" class="filter-input search-input"
                     placeholder="Cari posisi, departemen, atau lokasi..."
                     value="{{ request('search') }}">
            </div>
          </div>

          <div class="filter-group">
            <label class="filter-label">Departemen</label>
            <select name="department" class="filter-select">
              <option value="">Semua Departemen</option>
              @foreach(\App\Models\Position::getDepartments() as $dept)
                <option value="{{ $dept }}" {{ request('department') == $dept ? 'selected' : '' }}>
                  {{ $dept }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="filter-group">
            <label class="filter-label">Status</label>
            <select name="status" class="filter-select">
              <option value="">Semua Status</option>
              <option value="1" {{ request('status') == '1' ? 'selected' : '' }}>Aktif</option>
              <option value="0" {{ request('status') == '0' ? 'selected' : '' }}>Tutup</option>
            </select>
          </div>

          <div class="filter-group">
            <label class="filter-label">Tipe</label>
            <select name="employment_type" class="filter-select">
              <option value="">Semua Tipe</option>
              @foreach(\App\Models\Position::getEmploymentTypes() as $key => $label)
                <option value="{{ $key }}" {{ request('employment_type') == $key ? 'selected' : '' }}>
                  {{ $label }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="filter-group">
            <button type="submit" class="btn btn-primary">
              <i class="fas fa-filter"></i><span class="btn-text">Filter</span>
            </button>
          </div>
        </div>
      </form>
    </div>

    {{-- Tabel --}}
    <div class="table-container">
      <div class="table-header">
        <h3 class="table-title">Daftar Posisi</h3>
        <span class="table-info">Total: {{ $positions->total() }} posisi</span>
      </div>

      {{-- Desktop Table --}}
      <div class="desktop-table">
        <table class="positions-table">
          <thead>
          <tr>
            <th width="5%">No</th>
            <th width="25%">Posisi</th>
            <th width="15%">Tipe & Gaji</th>
            <th width="15%">Aplikasi</th>
            <th width="10%">Status</th>
            <th width="15%">Tanggal</th>
            <th width="10%">Aksi</th>
          </tr>
          </thead>
          <tbody>
          @forelse($positions as $index => $position)
            <tr>
              <td>{{ $positions->firstItem() + $index }}</td>
              <td>
                <div class="position-info">
                  <div class="position-name">{{ $position->position_name }}</div>
                  <div class="position-department">{{ $position->department }}</div>
                  @if($position->location)
                    <div class="position-location"><i class="fas fa-map-marker-alt"></i> {{ $position->location }}</div>
                  @endif
                </div>
              </td>
              <td>
                <div style="margin-bottom:8px;">
                  <span class="employment-badge employment-{{ str_replace('-', '-', $position->employment_type) }}">
                    {{ $position->employment_type_label }}
                  </span>
                </div>
                <div style="font-size:.85rem;color:#6b7280;">{{ $position->salary_range }}</div>
              </td>
              <td>
                <div class="application-stats">
                  <div class="stat-item">
                    <span class="stat-label"><i class="fas fa-users"></i> Total:</span>
                    <span class="stat-value {{ $position->total_applications_count == 0 ? 'zero' : '' }}">
                      {{ $position->total_applications_count }}
                    </span>
                  </div>
                  <div class="stat-item">
                    <span class="stat-label"><i class="fas fa-clock"></i> Proses:</span>
                    <span class="stat-value {{ $position->active_applications_count == 0 ? 'zero' : ($position->active_applications_count > 0 ? 'warning' : 'active') }}">
                      {{ $position->active_applications_count }}
                    </span>
                  </div>
                </div>
              </td>
              <td>
                @if($position->is_active == 1)
                  <span class="status-badge status-active"><i class="fas fa-check-circle"></i> Aktif</span>
                @else
                  <span class="status-badge status-closed"><i class="fas fa-times-circle"></i> Tutup</span>
                @endif
              </td>
              <td>
                <div style="font-size:.85rem;">
                  @if($position->posted_date)
                    <div style="color:#6b7280;margin-bottom:4px;">
                      Posted: {{ $position->posted_date->format('d M Y') }}
                    </div>
                  @endif
                  @if($position->closing_date)
                    <div style="color: {{ $position->closing_date->isPast() ? '#dc2626' : '#f59e0b' }};">
                      Tutup: {{ $position->closing_date->format('d M Y') }}
                      @if($position->closing_date->isPast())
                        <span style="font-size:.7rem;">(Lewat)</span>
                      @endif
                    </div>
                  @endif
                </div>
              </td>
              <td>
                <div class="action-dropdown">
                  <button class="action-btn" type="button" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v"></i>
                  </button>

                  <div class="dropdown-menu" role="menu">
                    {{-- LIHAT DETAIL --}}
                    <a href="{{ route('positions.show', $position->id) }}" class="dropdown-item">
                      <i class="fas fa-eye"></i> Lihat Detail
                    </a>

                    <a href="{{ route('positions.edit', $position->id) }}" class="dropdown-item">
                      <i class="fas fa-edit"></i> Edit
                    </a>
                    <div class="dropdown-divider"></div>

                    @if($position->is_active == 1)
                      <button class="dropdown-item btn-toggle-status" type="button"
                              data-position-id="{{ $position->id }}"
                              data-position-name="{{ addslashes($position->position_name) }}"
                              data-action="close"
                              data-active-apps="{{ $position->active_applications_count }}"
                              data-total-apps="{{ $position->total_applications_count }}">
                        <i class="fas fa-ban"></i> Tutup Posisi
                      </button>
                    @else
                      <button class="dropdown-item btn-toggle-status" type="button"
                              data-position-id="{{ $position->id }}"
                              data-position-name="{{ addslashes($position->position_name) }}"
                              data-action="open"
                              data-active-apps="{{ $position->active_applications_count }}"
                              data-total-apps="{{ $position->total_applications_count }}">
                        <i class="fas fa-check"></i> Buka Posisi
                      </button>
                    @endif

                    <div class="dropdown-divider"></div>
                    <button class="dropdown-item btn-delete-position" type="button"
                            data-position-id="{{ $position->id }}"
                            data-position-name="{{ addslashes($position->position_name) }}"
                            data-total-apps="{{ $position->total_applications_count }}"
                            data-active-apps="{{ $position->active_applications_count }}"
                            data-delete-url="{{ route('positions.destroy', $position->id) }}">
                      <i class="fas fa-trash-alt"></i> Hapus
                    </button>
                  </div>
                </div>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="7" class="empty-state">
                <i class="fas fa-briefcase"></i>
                <p>Tidak ada posisi yang tersedia</p>
                @if(request()->hasAny(['search','department','status','employment_type']))
                  <small>Coba ubah filter pencarian Anda</small>
                @endif
              </td>
            </tr>
          @endforelse
          </tbody>
        </table>
      </div>

      {{-- Mobile Cards --}}
      <div class="mobile-cards">
        @forelse($positions as $index => $position)
          <div class="position-card">
            <div class="card-header">
              <div class="position-info">
                <div class="position-name">{{ $position->position_name }}</div>
                <div class="position-department">{{ $position->department }}</div>
                @if($position->location)
                  <div class="position-location"><i class="fas fa-map-marker-alt"></i> {{ $position->location }}</div>
                @endif
              </div>
              <div class="card-actions">
                {{-- Tombol langsung ke Detail (mobile UX) --}}
                <a href="{{ route('positions.show', $position->id) }}" class="btn btn-primary" style="padding:8px 10px;">
                  <i class="fas fa-eye"></i> <span class="btn-text">Detail</span>
                </a>

                <div class="action-dropdown">
                  <button class="action-btn" type="button" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v"></i>
                  </button>
                  <div class="dropdown-menu" role="menu">
                    {{-- LIHAT DETAIL --}}
                    <a href="{{ route('positions.show', $position->id) }}" class="dropdown-item">
                      <i class="fas fa-eye"></i> Lihat Detail
                    </a>

                    <a href="{{ route('positions.edit', $position->id) }}" class="dropdown-item">
                      <i class="fas fa-edit"></i> Edit
                    </a>
                    <div class="dropdown-divider"></div>

                    @if($position->is_active == 1)
                      <button class="dropdown-item btn-toggle-status" type="button"
                              data-position-id="{{ $position->id }}"
                              data-position-name="{{ addslashes($position->position_name) }}"
                              data-action="close"
                              data-active-apps="{{ $position->active_applications_count }}"
                              data-total-apps="{{ $position->total_applications_count }}">
                        <i class="fas fa-ban"></i> Tutup Posisi
                      </button>
                    @else
                      <button class="dropdown-item btn-toggle-status" type="button"
                              data-position-id="{{ $position->id }}"
                              data-position-name="{{ addslashes($position->position_name) }}"
                              data-action="open"
                              data-active-apps="{{ $position->active_applications_count }}"
                              data-total-apps="{{ $position->total_applications_count }}">
                        <i class="fas fa-check"></i> Buka Posisi
                      </button>
                    @endif

                    <div class="dropdown-divider"></div>
                    <button class="dropdown-item btn-delete-position" type="button"
                            data-position-id="{{ $position->id }}"
                            data-position-name="{{ addslashes($position->position_name) }}"
                            data-total-apps="{{ $position->total_applications_count }}"
                            data-active-apps="{{ $position->active_applications_count }}"
                            data-delete-url="{{ route('positions.destroy', $position->id) }}">
                      <i class="fas fa-trash-alt"></i> Hapus
                    </button>
                  </div>
                </div>
              </div>
            </div>

            <div class="card-content">
              <div class="card-row">
                <div class="card-label"><i class="fas fa-briefcase"></i> Tipe</div>
                <div class="card-value">
                  <span class="employment-badge employment-{{ str_replace('-', '-', $position->employment_type) }}">
                    {{ $position->employment_type_label }}
                  </span>
                </div>
              </div>

              <div class="card-row">
                <div class="card-label"><i class="fas fa-money-bill-wave"></i> Gaji</div>
                <div class="card-value">{{ $position->salary_range }}</div>
              </div>

              <div class="card-row">
                <div class="card-label"><i class="fas fa-users"></i> Aplikasi</div>
                <div class="card-value">
                  <span class="stat-value {{ $position->total_applications_count == 0 ? 'zero' : '' }}">
                    {{ $position->total_applications_count }}
                  </span>
                  <small>({{ $position->active_applications_count }} aktif)</small>
                </div>
              </div>

              <div class="card-row">
                <div class="card-label"><i class="fas fa-info-circle"></i> Status</div>
                <div class="card-value">
                  @if($position->is_active == 1)
                    <span class="status-badge status-active"><i class="fas fa-check-circle"></i> Aktif</span>
                  @else
                    <span class="status-badge status-closed"><i class="fas fa-times-circle"></i> Tutup</span>
                  @endif
                </div>
              </div>

              @if($position->posted_date || $position->closing_date)
                <div class="card-row">
                  <div class="card-label"><i class="fas fa-calendar"></i> Tanggal</div>
                  <div class="card-value">
                    @if($position->posted_date)
                      <div style="font-size:.8rem; color:#6b7280;">Posted: {{ $position->posted_date->format('d M Y') }}</div>
                    @endif
                    @if($position->closing_date)
                      <div style="font-size:.8rem; color: {{ $position->closing_date->isPast() ? '#dc2626' : '#f59e0b' }};">
                        Tutup: {{ $position->closing_date->format('d M Y') }}
                        @if($position->closing_date->isPast())
                          <span style="font-size:.7rem;">(Lewat)</span>
                        @endif
                      </div>
                    @endif
                  </div>
                </div>
              @endif
            </div>
          </div>
        @empty
          <div class="empty-state">
            <i class="fas fa-briefcase"></i>
            <p>Tidak ada posisi yang tersedia</p>
            @if(request()->hasAny(['search','department','status','employment_type']))
              <small>Coba ubah filter pencarian Anda</small>
            @endif
          </div>
        @endforelse
      </div>

      {{-- Pagination --}}
      @if ($positions->hasPages())
        <div class="pagination-container">
          <div class="custom-pagination">
            <div class="pagination-info">
              <div class="pagination-summary">
                Menampilkan {{ $positions->firstItem() ?? 0 }} - {{ $positions->lastItem() ?? 0 }}
                dari {{ $positions->total() }} hasil
              </div>
              <div class="pagination-total">Halaman {{ $positions->currentPage() }} dari {{ $positions->lastPage() }}</div>
            </div>

            <div class="d-flex justify-content-center">
              <ul class="pagination">
                @if ($positions->onFirstPage())
                  <li class="page-item disabled"><span class="page-link">‹</span></li>
                @else
                  <li class="page-item"><a class="page-link" href="{{ $positions->previousPageUrl() }}" rel="prev">‹</a></li>
                @endif

                @foreach ($positions->links()->elements[0] as $page => $url)
                  @if ($page == $positions->currentPage())
                    <li class="page-item active"><span class="page-link">{{ $page }}</span></li>
                  @else
                    <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                  @endif
                @endforeach

                @if ($positions->hasMorePages())
                  <li class="page-item"><a class="page-link" href="{{ $positions->nextPageUrl() }}" rel="next">›</a></li>
                @else
                  <li class="page-item disabled"><span class="page-link">›</span></li>
                @endif
              </ul>
            </div>
          </div>
        </div>
      @endif
    </div>
  </div>

  <div class="loading-overlay" id="loadingOverlay">
    <div class="loading-spinner"></div>
  </div>
@endsection

@push('scripts')
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  {{-- Event helper minimal agar action bisa diklik walaupun JS utama gagal load --}}
  <script>
    document.addEventListener('click', (e) => {
      // Toggle sidebar mobile
      if (e.target.closest('#openSidebarMobile')) {
        document.getElementById('mobile-menu-button')?.click();
        return;
      }

      // Toggle dropdown
      const btn = e.target.closest('.action-btn');
      if (btn) {
        const menu = btn.parentElement.querySelector('.dropdown-menu');
        document.querySelectorAll('.dropdown-menu.show').forEach(m => m !== menu && m.classList.remove('show'));
        menu?.classList.toggle('show');
        return;
      }

      // Klik di luar -> tutup semua dropdown
      if (!e.target.closest('.action-dropdown')) {
        document.querySelectorAll('.dropdown-menu.show').forEach(m => m.classList.remove('show'));
      }

      // Delegasi tombol status/hapus ke fungsi global (dari positions-index.js)
      const toggleBtn = e.target.closest('.btn-toggle-status');
      if (toggleBtn && window.togglePositionStatus) {
        window.togglePositionStatus(
          toggleBtn.dataset.positionId,
          toggleBtn.dataset.positionName,
          toggleBtn.dataset.action,
          parseInt(toggleBtn.dataset.activeApps || '0', 10),
          parseInt(toggleBtn.dataset.totalApps || '0', 10)
        );
        document.querySelectorAll('.dropdown-menu.show').forEach(m => m.classList.remove('show'));
      }

      const delBtn = e.target.closest('.btn-delete-position');
      if (delBtn && window.deletePosition) {
        window.deletePosition(
          delBtn.dataset.positionId,
          delBtn.dataset.positionName,
          parseInt(delBtn.dataset.totalApps || '0', 10),
          parseInt(delBtn.dataset.activeApps || '0', 10)
        );
        document.querySelectorAll('.dropdown-menu.show').forEach(m => m.classList.remove('show'));
      }
    });

    // Tutup dropdown dengan Escape
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') {
        document.querySelectorAll('.dropdown-menu.show').forEach(m => m.classList.remove('show'));
      }
    });
  </script>

  {{-- JS utama kamu (konfirmasi Nonaktif/Aktif/Hapus sesuai mockup alert yang kamu minta) --}}
  <script src="{{ asset('js/positions-index.js') }}"></script>
@endpush
