<aside class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <div class="logo-wrap">
      <img src="{{ asset('images/PT. KAYU MEBEL INDONESIA GROUP.png') }}"
           alt="Logo" class="logo-img" />
      <div class="logo-text">HR System</div>
    </div>
  </div>

  <div class="user-panel">
    <div class="avatar">
      @if(Auth::user()->role === 'admin')
        <i class="fas fa-user-crown"></i>
      @elseif(Auth::user()->role === 'hr')
        <i class="fas fa-user-tie"></i>
      @else
        <i class="fas fa-user"></i>
      @endif
    </div>
    <div class="user-meta">
      <div class="user-name">{{ Auth::user()->full_name }}</div>
      <div class="user-role">{{ ucfirst(Auth::user()->role) }}</div>
    </div>
  </div>

  <nav class="nav-menu">
    <a href="{{ route('dashboard') }}"
       class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
      <i class="fas fa-gauge"></i>
      <span class="nav-text">Dashboard</span>
    </a>

    @if(in_array(Auth::user()->role, ['admin','hr']))
      <a href="{{ route('candidates.index') }}"
         class="nav-link {{ request()->routeIs('candidates.*') ? 'active' : '' }}">
        <i class="fas fa-user-tie"></i>
        <span class="nav-text">Kandidat</span>
      </a>

      <a href="{{ route('positions.index') }}"
         class="nav-link {{ request()->routeIs('positions.*') ? 'active' : '' }}">
        <i class="fas fa-briefcase"></i>
        <span class="nav-text">Posisi</span>
      </a>

      <a href="{{ route('employees.index') }}"
         class="nav-link {{ request()->routeIs('employees.*') ? 'active' : '' }}">
        <i class="fas fa-user-check"></i>
        <span class="nav-text">Karyawan Diterima</span>
      </a>
    @endif
  </nav>

  {{-- === Tombol Logout di bagian bawah sidebar === --}}
  <div class="sidebar-footer" style="margin-top:auto;padding:1rem;">
    <form action="{{ route('logout') }}" method="POST" id="logout-form">
      @csrf
      <button type="submit"
              class="nav-link"
              style="width:100%;display:flex;align-items:center;gap:.75rem;
                     background:none;border:none;color:#e53e3e;cursor:pointer">
        <i class="fas fa-sign-out-alt"></i>
        <span class="nav-text">Logout</span>
      </button>
    </form>
  </div>
</aside>
