@extends('layouts.app')
@section('title','Detail Karyawan')
@section('page-title','Detail Karyawan')

@section('content')
@php
  $gv = function(array $row, array $alts, $default='') {
    foreach ($alts as $k) { $v = data_get($row, $k); if (!is_null($v) && $v!=='') return $v; } return $default;
  };
  $fd = function($dateStr) { if(!$dateStr) return ''; try{ $dt=\Carbon\Carbon::parse($dateStr); return $dt->format('d M Y'); }catch(\Throwable $e){ return $dateStr; } };
  $p = $emp['personal'] ?? []; $e = $emp['employment'] ?? [];
@endphp

<div class="bg-white p-4 rounded-xl shadow space-y-6">
  <div class="flex items-center gap-4">
    @if(!empty($p['avatar']))
      <img src="{{ $p['avatar'] }}" class="w-16 h-16 rounded-full object-cover" alt="avatar">
    @endif
    <div>
      <h2 class="text-xl font-bold">{{ $gv($p,['first_name']) }} {{ $gv($p,['last_name']) }}</h2>
      <div class="text-sm text-gray-600">User ID: {{ $emp['user_id'] ?? '-' }} | Employee ID: {{ $gv($e,['employee_id']) }}</div>
    </div>
  </div>

  <div class="grid md:grid-cols-2 gap-6">
    <div class="border rounded-lg">
      <div class="px-4 py-2 bg-slate-50 font-semibold rounded-t-lg">Employment</div>
      <div class="p-4 text-sm space-y-2">
        <div><span class="font-medium">Branch:</span> {{ $gv($e,['branch']) }}</div>
        <div><span class="font-medium">Organization:</span> {{ $gv($e,['organization_name']) }}</div>
        <div><span class="font-medium">Job position:</span> {{ $gv($e,['job_position','job_title']) }}</div>
        <div><span class="font-medium">Job level:</span> {{ $gv($e,['job_level']) }}</div>
        <div><span class="font-medium">Employment status:</span> {{ $gv($e,['employment_status','status']) }}</div>
        <div><span class="font-medium">Status:</span> {{ $gv($e,['status']) }}</div>
        <div><span class="font-medium">Join date:</span> {{ $fd($gv($e,['join_date'])) ?: '-' }}</div>
        <div><span class="font-medium">End date:</span> {{ $fd($gv($e,['end_date'])) ?: '-' }}</div>
        <div><span class="font-medium">Sign date:</span> {{ $fd($gv($e,['sign_date'])) ?: '-' }}</div>
        <div><span class="font-medium">Resign date:</span> {{ $fd($gv($e,['resign_date'])) ?: '-' }}</div>
        <div><span class="font-medium">Barcode:</span> {{ $gv($p,['barcode']) ?: '-' }}</div>
      </div>
    </div>
    <div class="border rounded-lg">
      <div class="px-4 py-2 bg-slate-50 font-semibold rounded-t-lg">Personal</div>
      <div class="p-4 text-sm space-y-2">
        <div><span class="font-medium">Email:</span> {{ $gv($p,['email']) }}</div>
        <div><span class="font-medium">Phone:</span> {{ $gv($p,['mobile_phone','phone']) }}</div>
        <div><span class="font-medium">Birth date:</span> {{ $fd($gv($p,['birth_date'])) }}</div>
        <div><span class="font-medium">Birth place:</span> {{ $gv($p,['birth_place']) }}</div>
        <div><span class="font-medium">Address:</span> {{ $gv($p,['address']) }}</div>
        <div><span class="font-medium">Religion:</span> {{ $gv($p,['religion']) }}</div>
        <div><span class="font-medium">Gender:</span> {{ $gv($p,['gender']) }}</div>
        <div><span class="font-medium">Marital status:</span> {{ $gv($p,['marital_status']) }}</div>
        <div><span class="font-medium">NIK:</span> {{ $gv($p,['nik','identity_number']) }}</div>
      </div>
    </div>
  </div>

  <details class="mt-2">
    <summary class="cursor-pointer text-slate-600">Lihat RAW JSON</summary>
    <pre class="text-xs bg-slate-50 p-3 rounded overflow-auto">{{ json_encode($raw ?? $emp, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>
  </details>

  <a href="{{ route('talenta.employees.index') }}" class="inline-block px-4 py-2 rounded border">← Kembali</a>
</div>
@endsection
